/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.impl.AnnotationSessionImpl;
import com.intellij.codeInsight.daemon.impl.AnnotatorRunner;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoUpdater;
import com.intellij.codeInsight.daemon.impl.HighlightInfoUpdaterImpl;
import com.intellij.codeInsight.daemon.impl.HighlightRangeExtension;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightVisitorRunner;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.ManagedHighlighterRecycler;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.ResultSink;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.Problem;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@ApiStatus.Internal
public class GeneralHighlightingPass
extends ProgressableTextEditorHighlightingPass
implements DumbAware {
    static final Logger LOG = Logger.getInstance(GeneralHighlightingPass.class);
    private static final Key<Boolean> HAS_ERROR_ELEMENT = Key.create("HAS_ERROR_ELEMENT");
    static final Predicate<? super PsiFile> SHOULD_HIGHLIGHT_FILTER = file -> {
        HighlightingLevelManager manager = HighlightingLevelManager.getInstance(file.getProject());
        return manager != null && manager.shouldHighlight((PsiElement)file);
    };
    private static final Random RESTART_DAEMON_RANDOM = new Random();
    private final boolean myUpdateAll;
    @NotNull
    private final ProperTextRange myPriorityRange;
    private final List<HighlightInfo> myHighlights;
    private volatile boolean myHasErrorElement;
    private volatile boolean myHasErrorSeverity;
    private final boolean myRunAnnotators;
    private final HighlightInfoUpdater myHighlightInfoUpdater;
    private final HighlightVisitorRunner myHighlightVisitorRunner;
    @ApiStatus.Internal
    public static final int POST_UPDATE_ALL = 5;
    private static final AtomicInteger RESTART_REQUESTS = new AtomicInteger();

    GeneralHighlightingPass(@NotNull PsiFile psiFile, @NotNull Document document, int startOffset, int endOffset, boolean updateAll, @NotNull ProperTextRange priorityRange, @Nullable Editor editor, boolean runAnnotators, boolean runVisitors, boolean highlightErrorElements, @NotNull HighlightInfoUpdater highlightInfoUpdater) {
        if (psiFile == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(1);
        }
        if (priorityRange == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(2);
        }
        if (highlightInfoUpdater == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(3);
        }
        super(psiFile.getProject(), document, AnalysisBundle.message("pass.syntax", new Object[0]), psiFile, editor, TextRange.create(startOffset, endOffset), true, HighlightInfoProcessor.getEmpty());
        this.myHighlights = Collections.synchronizedList(new ArrayList());
        this.myUpdateAll = updateAll;
        this.myPriorityRange = priorityRange;
        this.myRunAnnotators = runAnnotators;
        this.myHighlightInfoUpdater = highlightInfoUpdater;
        PsiUtilCore.ensureValid(psiFile);
        boolean wholeFileHighlighting = this.isWholeFileHighlighting();
        this.myHasErrorElement = !wholeFileHighlighting && Boolean.TRUE.equals(this.getFile().getUserData(HAS_ERROR_ELEMENT));
        this.setProgressLimit(document.getTextLength() / 2);
        EditorColorsScheme globalScheme = editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme();
        this.myHighlightVisitorRunner = new HighlightVisitorRunner(psiFile, (TextAttributesScheme)globalScheme, runVisitors, highlightErrorElements);
    }

    boolean hasErrorElement() {
        return this.myHasErrorElement;
    }

    @NotNull
    private PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(4);
        }
        return psiFile;
    }

    public static void assertHighlightingPassNotRunning() {
        HighlightVisitorRunner.assertHighlightingPassNotRunning();
    }

    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        this.myHighlightVisitorRunner.createHighlightVisitorsFor(filteredVisitors -> {
            ArrayList dividedElements = new ArrayList();
            ArrayList notVisitableElements = new ArrayList();
            Divider.divideInsideAndOutsideAllRoots(this.getFile(), this.myRestrictRange, this.myPriorityRange, psiFile -> true, elements -> {
                if (SHOULD_HIGHLIGHT_FILTER.test(elements.psiRoot())) {
                    dividedElements.add(elements);
                } else {
                    notVisitableElements.add(elements);
                }
                return false;
            });
            List allInsideElements = ContainerUtil.concat(ContainerUtil.map(dividedElements, dividedForRoot -> {
                List<? extends PsiElement> inside = dividedForRoot.inside();
                PsiElement lastInside = ContainerUtil.getLastItem(inside);
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? inside.subList(0, inside.size() - 1) : inside;
            }));
            List<LongList> map2 = ContainerUtil.map(dividedElements, dividedForRoot -> {
                LongList insideRanges = dividedForRoot.insideRanges();
                PsiElement lastInside = ContainerUtil.getLastItem(dividedForRoot.inside());
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? insideRanges.subList(0, insideRanges.size() - 1) : insideRanges;
            });
            LongList allInsideRanges = ContainerUtil.reduce(map2, new LongArrayList(map2.isEmpty() ? 1 : map2.get(0).size()), (l1, l2) -> {
                l1.addAll((LongList)l2);
                return l1;
            });
            List allOutsideElements = ContainerUtil.concat(ContainerUtil.map(dividedElements, dividedForRoot -> {
                List<? extends PsiElement> outside = dividedForRoot.outside();
                PsiElement lastInside = ContainerUtil.getLastItem(dividedForRoot.inside());
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? ContainerUtil.append(outside, lastInside) : outside;
            }));
            List<LongList> map1 = ContainerUtil.map(dividedElements, dividedForRoot -> {
                long lastInsideRange;
                LongList outsideRanges = dividedForRoot.outsideRanges();
                PsiElement lastInside = ContainerUtil.getLastItem(dividedForRoot.inside());
                long l = lastInsideRange = dividedForRoot.insideRanges().isEmpty() ? -1L : dividedForRoot.insideRanges().getLong(dividedForRoot.insideRanges().size() - 1);
                if (lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) && lastInsideRange != -1L) {
                    LongArrayList r = new LongArrayList(outsideRanges);
                    r.add(lastInsideRange);
                    return r;
                }
                return outsideRanges;
            });
            LongList allOutsideRanges = ContainerUtil.reduce(map1, new LongArrayList(map1.isEmpty() ? 1 : map1.get(0).size()), (l1, l2) -> {
                l1.addAll((LongList)l2);
                return l1;
            });
            this.setProgressLimit(allInsideElements.size() + allOutsideElements.size());
            boolean forceHighlightParents = this.forceHighlightParents();
            Consumer<ManagedHighlighterRecycler> recyclerConsumer = invalidPsiRecycler -> {
                boolean success;
                for (Divider.DividedElements notVisitable : notVisitableElements) {
                    for (PsiElement psiElement2 : ContainerUtil.concat(notVisitable.inside(), notVisitable.outside())) {
                        for (HighlightVisitor visitor : filteredVisitors) {
                            this.myHighlightInfoUpdater.psiElementVisited(visitor.getClass(), psiElement2, List.of(), this.getDocument(), this.getFile(), this.myProject, this.getHighlightingSession(), (ManagedHighlighterRecycler)invalidPsiRecycler);
                        }
                    }
                }
                HighlightInfoUpdater patt11412$temp = this.myHighlightInfoUpdater;
                if (patt11412$temp instanceof HighlightInfoUpdaterImpl) {
                    HighlightInfoUpdaterImpl impl = (HighlightInfoUpdaterImpl)patt11412$temp;
                    List<Class> liveVisitorClasses = ContainerUtil.map(filteredVisitors, v -> v.getClass());
                    BiPredicate<Object, PsiFile> keepToolIdPredicate = (toolId, __) -> !HighlightInfoUpdaterImpl.isHighlightVisitorToolId(toolId) || liveVisitorClasses.contains(toolId);
                    impl.removeHighlightsForObsoleteTools(this.getHighlightingSession(), List.of(), keepToolIdPredicate);
                }
                if (success = allInsideElements.isEmpty() && allOutsideElements.isEmpty() ? true : this.collectHighlights(allInsideElements, allInsideRanges, allOutsideElements, allOutsideRanges, (HighlightVisitor[])filteredVisitors, forceHighlightParents, (toolId, psiElement, newInfos) -> {
                    this.myHighlightInfoUpdater.psiElementVisited(toolId, psiElement, newInfos, this.getDocument(), this.getFile(), this.myProject, this.getHighlightingSession(), (ManagedHighlighterRecycler)invalidPsiRecycler);
                    this.myHighlights.addAll(newInfos);
                    if (psiElement instanceof PsiErrorElement) {
                        this.myHasErrorElement = true;
                    }
                    for (HighlightInfo info : newInfos) {
                        if (info.getSeverity() != HighlightSeverity.ERROR) continue;
                        this.myHasErrorSeverity = true;
                        break;
                    }
                })) {
                    if (this.myUpdateAll) {
                        daemonCodeAnalyzer.getFileStatusMap().setErrorFoundFlag(this.getDocument(), this.getContext(), this.myHasErrorSeverity);
                        this.reportErrorsToWolf(this.myHasErrorSeverity);
                    }
                } else {
                    GeneralHighlightingPass.cancelAndRestartDaemonLater(progress, this.myProject, "GHP.collectHighlights() == false");
                }
            };
            HighlightInfoUpdater patt13324$temp = this.myHighlightInfoUpdater;
            if (patt13324$temp instanceof HighlightInfoUpdaterImpl) {
                HighlightInfoUpdaterImpl impl = (HighlightInfoUpdaterImpl)patt13324$temp;
                impl.runWithInvalidPsiRecycler(this.getHighlightingSession(), HighlightInfoUpdaterImpl.WhatTool.ANNOTATOR_OR_VISITOR, recyclerConsumer);
            } else {
                ManagedHighlighterRecycler.runWithRecycler(this.getHighlightingSession(), recyclerConsumer);
            }
        });
        if (LOG.isTraceEnabled()) {
            List<HighlightInfo> errors = ContainerUtil.filter(this.myHighlights, h -> h.getSeverity() == HighlightSeverity.ERROR);
            LOG.trace("GHP finished: myHasErrorElement=" + this.myHasErrorElement + "; highlights:" + this.myHighlights.size() + "; errors:" + errors.size() + ": " + StringUtil.join(errors, "\n"));
        }
    }

    private boolean isWholeFileHighlighting() {
        return this.myUpdateAll && this.myRestrictRange.equalsToRange(0, this.getDocument().getTextLength());
    }

    @Override
    protected void applyInformationWithProgress() {
        ((HighlightingSessionImpl)this.getHighlightingSession()).applyFileLevelHighlightsRequests();
        this.getFile().putUserData(HAS_ERROR_ELEMENT, this.myHasErrorElement);
    }

    @Override
    @NotNull
    public final List<HighlightInfo> getInfos() {
        List<HighlightInfo> list = this.myHighlights;
        if (list == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(6);
        }
        return list;
    }

    private boolean collectHighlights(@NotNull List<? extends PsiElement> elements1, @NotNull LongList ranges1, @NotNull List<? extends PsiElement> elements2, @NotNull LongList ranges2, HighlightVisitor @NotNull [] visitors, boolean forceHighlightParents, @NotNull ResultSink resultSink) {
        AnnotatorRunner annotatorRunner;
        if (elements1 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(7);
        }
        if (ranges1 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(8);
        }
        if (elements2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(9);
        }
        if (ranges2 == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(10);
        }
        if (resultSink == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(11);
        }
        if (visitors == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(12);
        }
        int chunkSize = Math.max(1, (elements1.size() + elements2.size()) / 100);
        ProgressManager.checkCanceled();
        Runnable runnable = () -> this.myHighlightVisitorRunner.runVisitors(this.getFile(), this.myRestrictRange, elements1, ranges1, elements2, ranges2, visitors, forceHighlightParents, chunkSize, this.myUpdateAll, () -> this.createInfoHolder(this.getFile()), resultSink);
        AnnotationSession session = AnnotationSessionImpl.create(this.getFile());
        GeneralHighlightingPass.setupAnnotationSession(session, this.myPriorityRange, this.myRestrictRange, ((HighlightingSessionImpl)this.getHighlightingSession()).getMinimumSeverity());
        AnnotatorRunner annotatorRunner2 = annotatorRunner = this.myRunAnnotators ? new AnnotatorRunner(session, false) : null;
        if (annotatorRunner == null) {
            runnable.run();
            return true;
        }
        return annotatorRunner.runAnnotatorsAsync(elements1, elements2, runnable, resultSink);
    }

    @TestOnly
    public static boolean isRestartPending() {
        return RESTART_REQUESTS.get() > 0;
    }

    private static void cancelAndRestartDaemonLater(@NotNull ProgressIndicator progress, @NotNull Project project, @NotNull String reason) throws ProcessCanceledException {
        if (progress == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(13);
        }
        if (project == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(14);
        }
        if (reason == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(15);
        }
        RESTART_REQUESTS.incrementAndGet();
        progress.cancel();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            RESTART_REQUESTS.decrementAndGet();
            if (!project.isDisposed()) {
                DaemonCodeAnalyzerEx.getInstanceEx(project).restart(reason);
            }
        } else {
            int delay = RESTART_DAEMON_RANDOM.nextInt(100);
            EdtExecutorService.getScheduledExecutorInstance().schedule(() -> {
                RESTART_REQUESTS.decrementAndGet();
                if (!project.isDisposed()) {
                    DaemonCodeAnalyzerEx.getInstanceEx(project).restart(reason);
                }
            }, (long)delay, TimeUnit.MILLISECONDS);
        }
        throw new ProcessCanceledException();
    }

    private boolean forceHighlightParents() {
        boolean forceHighlightParents = false;
        for (HighlightRangeExtension extension : HighlightRangeExtension.EP_NAME.getExtensionList()) {
            if (!extension.isForceHighlightParents(this.getFile())) continue;
            forceHighlightParents = true;
            break;
        }
        return forceHighlightParents;
    }

    @NotNull
    protected HighlightInfoHolder createInfoHolder(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(16);
        }
        HighlightInfoFilter[] filters = HighlightInfoFilter.EXTENSION_POINT_NAME.getExtensionList().toArray(HighlightInfoFilter.EMPTY_ARRAY);
        final EditorColorsScheme actualScheme = this.getColorsScheme() == null ? EditorColorsManager.getInstance().getGlobalScheme() : this.getColorsScheme();
        HighlightInfoHolder holder = new HighlightInfoHolder(psiFile, filters){

            @Override
            @NotNull
            public TextAttributesScheme getColorsScheme() {
                EditorColorsScheme editorColorsScheme = actualScheme;
                if (editorColorsScheme == null) {
                    1.$$$reportNull$$$0(0);
                }
                return editorColorsScheme;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean add(@Nullable HighlightInfo info) {
                boolean added;
                1 var3_2 = this;
                synchronized (var3_2) {
                    added = super.add(info);
                }
                if (info != null && added && info.getSeverity() == HighlightSeverity.ERROR) {
                    GeneralHighlightingPass.this.myHasErrorSeverity = true;
                }
                return added;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass$1", "getColorsScheme"));
            }
        };
        GeneralHighlightingPass.setupAnnotationSession(holder.getAnnotationSession(), this.myPriorityRange, this.myRestrictRange, ((HighlightingSessionImpl)this.getHighlightingSession()).getMinimumSeverity());
        HighlightInfoHolder highlightInfoHolder = holder;
        if (highlightInfoHolder == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(17);
        }
        return highlightInfoHolder;
    }

    @ApiStatus.Internal
    public static void setupAnnotationSession(@NotNull AnnotationSession annotationSession, @NotNull TextRange priorityRange, @NotNull TextRange highlightRange, @Nullable HighlightSeverity minimumSeverity) {
        if (annotationSession == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(18);
        }
        if (priorityRange == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(19);
        }
        if (highlightRange == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(20);
        }
        ((AnnotationSessionImpl)annotationSession).setMinimumSeverity(minimumSeverity);
        ((AnnotationSessionImpl)annotationSession).setVR(priorityRange, highlightRange);
    }

    private void reportErrorsToWolf(boolean hasErrors) {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (!this.getFile().getViewProvider().isPhysical()) {
            return;
        }
        Project project = this.getFile().getProject();
        if (!PsiManager.getInstance(project).isInProject(this.getFile())) {
            return;
        }
        VirtualFile file = this.getFile().getVirtualFile();
        if (file == null) {
            return;
        }
        List<Problem> problems = GeneralHighlightingPass.convertToProblems(this.getInfos(), file, this.myHasErrorElement);
        WolfTheProblemSolver wolf = WolfTheProblemSolver.getInstance(project);
        if (!hasErrors || this.isWholeFileHighlighting()) {
            wolf.reportProblems(file, problems);
        } else {
            wolf.weHaveGotProblems(file, problems);
        }
    }

    @NotNull
    private static List<Problem> convertToProblems(@NotNull Collection<? extends HighlightInfo> infos, @NotNull VirtualFile file, boolean hasErrorElement) {
        if (infos == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(21);
        }
        if (file == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(22);
        }
        SmartList<Problem> problems = new SmartList<Problem>();
        for (HighlightInfo highlightInfo : infos) {
            if (highlightInfo.getSeverity() != HighlightSeverity.ERROR) continue;
            ProblemImpl problem = new ProblemImpl(file, highlightInfo, hasErrorElement);
            problems.add(problem);
        }
        SmartList<Problem> smartList = problems;
        if (smartList == null) {
            GeneralHighlightingPass.$$$reportNull$$$0(23);
        }
        return smartList;
    }

    @Override
    public String toString() {
        return super.toString() + " updateAll=" + this.myUpdateAll + " range=" + String.valueOf(this.myRestrictRange);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 17, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoUpdater";
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements2";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSink";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitors";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationSession";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightRange";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfoHolder";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToProblems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 23: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationWithProgress";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectHighlights";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndRestartDaemonLater";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createInfoHolder";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setupAnnotationSession";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "convertToProblems";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 17, 23 -> new IllegalStateException(string);
        };
    }
}

