/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdentifierUtil {
    @Nullable
    public static PsiElement getNameIdentifier(@NotNull PsiElement element) {
        if (element == null) {
            IdentifierUtil.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiNameIdentifierOwner) {
            PsiNameIdentifierOwner owner = (PsiNameIdentifierOwner)element;
            return owner.getNameIdentifier();
        }
        if (element.isPhysical() && element instanceof PsiNamedElement) {
            PsiElement potentialIdentifier;
            PsiNamedElement namedElement = (PsiNamedElement)element;
            if (element.getContainingFile() != null && element.getTextRange() != null && (potentialIdentifier = element.findElementAt(element.getTextOffset() - element.getTextRange().getStartOffset())) != null && Comparing.equal(potentialIdentifier.getText(), namedElement.getName(), false)) {
                return potentialIdentifier;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/IdentifierUtil", "getNameIdentifier"));
    }
}

