/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoUpdater;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.InjectedGeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.InjectedLanguageHighlightingRangeReducer;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InjectedGeneralHighlightingPassFactory
implements MainHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar,
DumbAware {
    @NotNull
    private final List<InjectedLanguageHighlightingRangeReducer> myLanguageHighlightingRangeReducers = InjectedLanguageHighlightingRangeReducer.EP_NAME.getExtensionList();

    InjectedGeneralHighlightingPassFactory() {
    }

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        int[] nArray;
        int[] runAfterCompletionOf;
        boolean serialized;
        if (registrar == null) {
            InjectedGeneralHighlightingPassFactory.$$$reportNull$$$0(0);
        }
        if (project == null) {
            InjectedGeneralHighlightingPassFactory.$$$reportNull$$$0(1);
        }
        boolean bl = serialized = Registry.is("editor.injected.highlighting.serialization.allowed") && ((TextEditorHighlightingPassRegistrarImpl)registrar).isSerializeCodeInsightPasses();
        if (serialized) {
            int[] nArray2 = new int[1];
            v2 = nArray2;
            nArray2[0] = 4;
        } else {
            v2 = runAfterCompletionOf = null;
        }
        if (serialized) {
            nArray = null;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 4;
        }
        int[] runAfterStartingOf = nArray;
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, runAfterCompletionOf, runAfterStartingOf, false, 14);
    }

    @Override
    @NotNull
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        TextRange fileRange;
        if (psiFile == null) {
            InjectedGeneralHighlightingPassFactory.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            InjectedGeneralHighlightingPassFactory.$$$reportNull$$$0(3);
        }
        if ((fileRange = FileStatusMap.getDirtyTextRange(editor.getDocument(), psiFile, 14)) == null) {
            return new ProgressableTextEditorHighlightingPass.EmptyPass(psiFile.getProject(), editor.getDocument());
        }
        List<TextRange> adjustedRanges = this.computeReducedRanges(psiFile, editor);
        TextRange restrictRange = InjectedGeneralHighlightingPassFactory.computeRestrictRange(adjustedRanges, fileRange);
        boolean updateAll = InjectedGeneralHighlightingPassFactory.isUpdatingWholeFile(fileRange, adjustedRanges);
        ProperTextRange visibleRange = HighlightingSessionImpl.getFromCurrentIndicator(psiFile).getVisibleRange();
        return new InjectedGeneralHighlightingPass(psiFile, editor.getDocument(), (List<? extends TextRange>)(adjustedRanges != null && adjustedRanges.size() == 1 ? null : adjustedRanges), restrictRange.getStartOffset(), restrictRange.getEndOffset(), updateAll, visibleRange, editor, true, true, true, HighlightInfoUpdater.getInstance(psiFile.getProject()));
    }

    private static boolean isUpdatingWholeFile(@NotNull TextRange fileRange, @Nullable List<? extends @NotNull TextRange> ranges) {
        if (fileRange == null) {
            InjectedGeneralHighlightingPassFactory.$$$reportNull$$$0(4);
        }
        if (ranges == null) {
            return true;
        }
        if (ranges.size() == 1) {
            return fileRange.equals(ranges.get(0));
        }
        return false;
    }

    @NotNull
    private static TextRange computeRestrictRange(@Nullable List<? extends @NotNull TextRange> reduced, @NotNull TextRange fileRange) {
        if (fileRange == null) {
            InjectedGeneralHighlightingPassFactory.$$$reportNull$$$0(5);
        }
        if (reduced == null) {
            TextRange textRange = fileRange;
            if (textRange == null) {
                InjectedGeneralHighlightingPassFactory.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        if (reduced.size() == 1) {
            TextRange textRange = reduced.get(0);
            if (textRange == null) {
                InjectedGeneralHighlightingPassFactory.$$$reportNull$$$0(7);
            }
            return textRange;
        }
        int startOffSet = fileRange.getEndOffset();
        int endOffSet = fileRange.getStartOffset();
        for (TextRange textRange : reduced) {
            startOffSet = Math.min(startOffSet, textRange.getStartOffset());
            endOffSet = Math.max(endOffSet, textRange.getEndOffset());
        }
        TextRange textRange = TextRange.create(startOffSet, endOffSet);
        if (textRange == null) {
            InjectedGeneralHighlightingPassFactory.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    @Nullable
    private List<TextRange> computeReducedRanges(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        if (psiFile == null) {
            InjectedGeneralHighlightingPassFactory.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            InjectedGeneralHighlightingPassFactory.$$$reportNull$$$0(10);
        }
        for (InjectedLanguageHighlightingRangeReducer reducer : this.myLanguageHighlightingRangeReducers) {
            List<TextRange> reduced = reducer.reduceRange(psiFile, editor);
            if (reduced == null || reduced.isEmpty()) continue;
            return reduced;
        }
        return null;
    }

    @Override
    public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (psiFile == null) {
            InjectedGeneralHighlightingPassFactory.$$$reportNull$$$0(11);
        }
        if (document == null) {
            InjectedGeneralHighlightingPassFactory.$$$reportNull$$$0(12);
        }
        if (highlightInfoProcessor == null) {
            InjectedGeneralHighlightingPassFactory.$$$reportNull$$$0(13);
        }
        return new InjectedGeneralHighlightingPass(psiFile, document, null, 0, document.getTextLength(), true, new ProperTextRange(0, document.getTextLength()), null, true, true, true, HighlightInfoUpdater.EMPTY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileRange";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPassFactory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPassFactory";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRestrictRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerHighlightingPassFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightingPass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUpdatingWholeFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeRestrictRange";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeReducedRanges";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createMainHighlightingPass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

