/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.EditorContextManager;
import com.intellij.codeInsight.quickfix.LazyQuickFixUpdater;
import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.ClientEditorManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
@ApiStatus.Experimental
public final class LazyQuickFixUpdaterImpl
implements LazyQuickFixUpdater {
    private volatile boolean enabled = true;

    @Override
    @RequiresBackgroundThread
    public void waitQuickFixesSynchronously(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull HighlightInfo info) {
        if (psiFile == null) {
            LazyQuickFixUpdaterImpl.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            LazyQuickFixUpdaterImpl.$$$reportNull$$$0(1);
        }
        if (info == null) {
            LazyQuickFixUpdaterImpl.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertBackgroundThread();
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ReadAction.run(() -> {
            try {
                info.computeQuickFixesSynchronously(psiFile, editor.getDocument());
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        });
    }

    @Override
    public void startComputingNextQuickFixes(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull ProperTextRange visibleRange) {
        if (psiFile == null) {
            LazyQuickFixUpdaterImpl.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            LazyQuickFixUpdaterImpl.$$$reportNull$$$0(4);
        }
        if (visibleRange == null) {
            LazyQuickFixUpdaterImpl.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = psiFile.getProject();
        Document document = editor.getDocument();
        CodeInsightContext context = EditorContextManager.getEditorContext((Editor)editor, (Project)project);
        int startOffset = Math.max(0, visibleRange.getStartOffset());
        int endOffset = Math.min(document.getTextLength(), visibleRange.getEndOffset() + visibleRange.getLength());
        int caret = editor.getCaretModel().getOffset();
        TextRange caretLine = DocumentUtil.getLineTextRange(document, document.getLineNumber(caret));
        if (caretLine.getStartOffset() < startOffset || caretLine.getEndOffset() >= endOffset) {
            this.startLazyFixJobs(editor, project, context, caretLine.getStartOffset(), caretLine.getEndOffset());
        }
        this.startLazyFixJobs(editor, project, context, startOffset, endOffset);
        if (!ClientId.isLocal(ClientEditorManager.getClientId((Editor)editor))) {
            this.startLazyFixJobs(editor, project, context, 0, document.getTextLength());
        }
    }

    private void startLazyFixJobs(@NotNull Editor editor, @NotNull Project project, @NotNull CodeInsightContext context, int startOffset, int endOffset) {
        if (editor == null) {
            LazyQuickFixUpdaterImpl.$$$reportNull$$$0(6);
        }
        if (project == null) {
            LazyQuickFixUpdaterImpl.$$$reportNull$$$0(7);
        }
        if (context == null) {
            LazyQuickFixUpdaterImpl.$$$reportNull$$$0(8);
        }
        ArrayList infos = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights(editor.getDocument(), project, HighlightSeverity.ERROR, startOffset, endOffset, context, info -> {
            infos.add(info);
            return true;
        });
        for (HighlightInfo info2 : infos) {
            if (!info2.hasLazyQuickFixes()) continue;
            this.startJob(info2, editor, project);
        }
    }

    private void startJob(@NotNull HighlightInfo info, @NotNull Editor editor, @NotNull Project project) {
        if (info == null) {
            LazyQuickFixUpdaterImpl.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            LazyQuickFixUpdaterImpl.$$$reportNull$$$0(10);
        }
        if (project == null) {
            LazyQuickFixUpdaterImpl.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!this.enabled) {
            return;
        }
        info.startComputeQuickFixes(editor.getDocument(), project);
    }

    @TestOnly
    public void stopUntil(@NotNull Disposable disposable) {
        if (disposable == null) {
            LazyQuickFixUpdaterImpl.$$$reportNull$$$0(12);
        }
        this.enabled = false;
        Disposer.register(disposable, () -> {
            this.enabled = true;
        });
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    @RequiresEdt
    public void waitForBackgroundJobIfStartedInTests(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull HighlightInfo info, long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        void unit;
        if (psiFile == null) {
            LazyQuickFixUpdaterImpl.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            LazyQuickFixUpdaterImpl.$$$reportNull$$$0(14);
        }
        if (info == null) {
            LazyQuickFixUpdaterImpl.$$$reportNull$$$0(15);
        }
        if (timeUnit == null) {
            LazyQuickFixUpdaterImpl.$$$reportNull$$$0(16);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ApplicationManager.getApplication().assertIsDispatchThread();
        AppExecutorUtil.getAppExecutorService().submit(() -> this.waitQuickFixesSynchronously(psiFile, editor, info)).get(timeout, (TimeUnit)unit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRange";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/LazyQuickFixUpdaterImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "waitQuickFixesSynchronously";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startComputingNextQuickFixes";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "startLazyFixJobs";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "startJob";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "stopUntil";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForBackgroundJobIfStartedInTests";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

