/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProgressableTextEditorHighlightingPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(ProgressableTextEditorHighlightingPass.class);
    private volatile boolean myFinished;
    private volatile long myProgressLimit;
    private final AtomicLong myProgressCount;
    private final AtomicLong myNextChunkThreshold;
    @NotNull
    @Nls
    private final String myPresentableName;
    protected final PsiFile myFile;
    @Nullable
    private final Editor myEditor;
    @ApiStatus.Internal
    @NotNull
    protected final TextRange myRestrictRange;
    private final HighlightingSession myHighlightingSession;

    protected ProgressableTextEditorHighlightingPass(@NotNull Project project, @NotNull Document document, @NotNull @Nls String presentableName, @Nullable PsiFile psiFile, @Nullable Editor editor, @NotNull TextRange restrictRange, boolean runIntentionPassAfter, @Deprecated @Nullable(value="do not use") @Nullable(value="do not use") HighlightInfoProcessor highlightInfoProcessor) {
        if (project == null) {
            ProgressableTextEditorHighlightingPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            ProgressableTextEditorHighlightingPass.$$$reportNull$$$0(1);
        }
        if (presentableName == null) {
            ProgressableTextEditorHighlightingPass.$$$reportNull$$$0(2);
        }
        if (restrictRange == null) {
            ProgressableTextEditorHighlightingPass.$$$reportNull$$$0(3);
        }
        super(project, document, runIntentionPassAfter);
        this.myProgressCount = new AtomicLong();
        this.myNextChunkThreshold = new AtomicLong();
        this.myPresentableName = presentableName;
        this.myFile = psiFile;
        this.myEditor = editor;
        this.myRestrictRange = restrictRange;
        if (psiFile != null) {
            if (psiFile.getProject() != project) {
                throw new IllegalArgumentException("File '" + String.valueOf(psiFile) + "' (" + String.valueOf(psiFile.getClass()) + ") is from an alien project (" + String.valueOf(psiFile.getProject()) + ") but expected: " + String.valueOf(project));
            }
            if (InjectedLanguageManager.getInstance(project).isInjectedFragment(psiFile)) {
                throw new IllegalArgumentException("File '" + String.valueOf(psiFile) + "' (" + String.valueOf(psiFile.getClass()) + ") is an injected fragment but expected top-level");
            }
            this.myHighlightingSession = HighlightingSessionImpl.getFromCurrentIndicator(psiFile);
        } else {
            this.myHighlightingSession = null;
        }
        if (document instanceof DocumentWindow) {
            throw new IllegalArgumentException("Document '" + String.valueOf(document) + " is an injected fragment but expected top-level");
        }
        if (editor != null) {
            PsiUtilBase.assertEditorAndProjectConsistent(project, editor);
            if (editor.getDocument() != document) {
                throw new IllegalArgumentException("Editor '" + String.valueOf(editor) + "' (" + String.valueOf(editor.getClass()) + ") has document " + String.valueOf(editor.getDocument()) + " but expected: " + String.valueOf(document));
            }
        }
    }

    @Override
    protected boolean isValid() {
        return super.isValid() && (this.myFile == null || this.myFile.isValid());
    }

    private void sessionFinished() {
        this.advanceProgress(Math.max(1L, this.myProgressLimit - this.myProgressCount.get()));
    }

    @Override
    public final void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ProgressableTextEditorHighlightingPass.$$$reportNull$$$0(4);
        }
        GlobalInspectionContextBase.assertUnderDaemonProgress();
        ProgressManager.checkCanceled();
        this.myFinished = false;
        try {
            HighlightingSession session = this.getHighlightingSession();
            if (session.getProgressIndicator() == progress) {
                this.collectInformationWithProgress(progress);
            } else {
                LOG.debug("Skipped running the 2nd copy of " + String.valueOf(this) + "; myProgress=" + String.valueOf(progress) + "; session progress=" + String.valueOf(session.getProgressIndicator()));
            }
        }
        finally {
            if (this.myFile != null) {
                this.sessionFinished();
            }
        }
    }

    @Override
    @ApiStatus.Internal
    public void markUpToDateIfStillValid(@NotNull DaemonProgressIndicator progress) {
        HighlightingSession session;
        if (progress == null) {
            ProgressableTextEditorHighlightingPass.$$$reportNull$$$0(5);
        }
        if ((session = this.getHighlightingSession()).getProgressIndicator() == progress) {
            super.markUpToDateIfStillValid(progress);
        }
    }

    protected abstract void collectInformationWithProgress(@NotNull ProgressIndicator var1);

    @Override
    public final void doApplyInformationToEditor() {
        this.myFinished = true;
        this.applyInformationWithProgress();
    }

    protected abstract void applyInformationWithProgress();

    public double getProgress() {
        long progressLimit = this.getProgressLimit();
        if (progressLimit == 0L) {
            return -1.0;
        }
        long progressCount = this.getProgressCount();
        return progressCount > progressLimit ? 1.0 : (double)progressCount / (double)progressLimit;
    }

    private long getProgressLimit() {
        return this.myProgressLimit;
    }

    private long getProgressCount() {
        return this.myProgressCount.get();
    }

    public boolean isFinished() {
        return this.myFinished;
    }

    @Nullable(value="null means do not show progress")
    @Nls
    public @Nullable(value="null means do not show progress") @Nls String getPresentableName() {
        return this.myPresentableName;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    public void setProgressLimit(long limit) {
        this.myProgressLimit = limit;
        this.myNextChunkThreshold.set(Math.max(1L, limit / 100L));
    }

    public void advanceProgress(long delta) {
        long current;
        if (this.myHighlightingSession != null && (current = this.myProgressCount.addAndGet(delta)) >= this.myNextChunkThreshold.get() && current >= this.myNextChunkThreshold.updateAndGet(old -> current >= old ? old + Math.max(1L, this.myProgressLimit / 100L) : old)) {
            DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).progressIsAdvanced(this.myHighlightingSession, this.getEditor(), this.getProgress());
        }
    }

    @NotNull
    protected HighlightingSession getHighlightingSession() {
        HighlightingSession highlightingSession = this.myHighlightingSession;
        if (highlightingSession == null) {
            ProgressableTextEditorHighlightingPass.$$$reportNull$$$0(6);
        }
        return highlightingSession;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markUpToDateIfStillValid";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static final class EmptyPass
    extends TextEditorHighlightingPass {
        public EmptyPass(@NotNull Project project, @NotNull Document document) {
            if (project == null) {
                EmptyPass.$$$reportNull$$$0(0);
            }
            if (document == null) {
                EmptyPass.$$$reportNull$$$0(1);
            }
            super(project, document, false);
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            if (progress == null) {
                EmptyPass.$$$reportNull$$$0(2);
            }
        }

        @Override
        public void doApplyInformationToEditor() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass$EmptyPass";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCollectInformation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

