/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DisableHighlightingIntentionAction
extends IntentionAndQuickFixAction
implements DumbAware {
    private final String myShortName;

    public DisableHighlightingIntentionAction(String shortName) {
        this.myShortName = shortName;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = AnalysisBundle.message("intention.family.name.disable.highlighting.keep.fix", new Object[0]);
        if (string == null) {
            DisableHighlightingIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        InspectionProfileImpl profile;
        HighlightSeverity usedSeverity;
        if (project == null) {
            DisableHighlightingIntentionAction.$$$reportNull$$$0(1);
        }
        return (usedSeverity = (profile = InspectionProjectProfileManager.getInstance(project).getCurrentProfile()).getErrorLevel(HighlightDisplayKey.find(this.myShortName), psiFile).getSeverity()).compareTo(HighlightSeverity.INFORMATION) > 0;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getFamilyName();
        if (string == null) {
            DisableHighlightingIntentionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void applyFix(@NotNull Project project, PsiFile psiFile, @Nullable Editor editor) {
        if (project == null) {
            DisableHighlightingIntentionAction.$$$reportNull$$$0(3);
        }
        InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile(project, it -> {
            ToolsImpl tools = it.getToolsOrNull(this.myShortName, project);
            if (tools != null) {
                tools.setLevel(HighlightDisplayLevel.DO_NOT_SHOW);
            }
        });
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/actions/DisableHighlightingIntentionAction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/DisableHighlightingIntentionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3 -> new IllegalArgumentException(string);
        };
    }
}

