/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.actions.IntentionActionWithFixAllOption;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.EditorContextManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModCommandService;
import com.intellij.modcommand.ModCommandWithContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FixAllHighlightingProblems
implements IntentionAction {
    private final IntentionActionWithFixAllOption myAction;

    FixAllHighlightingProblems(@NotNull IntentionActionWithFixAllOption action2) {
        if (action2 == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(0);
        }
        this.myAction = action2;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myAction.getFixAllText();
        if (string == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = AnalysisBundle.message("intention.family.name.fix.all.problems.like.this", new Object[0]);
        if (string == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(4);
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance(project);
        PsiFile topLevelFile = manager.getTopLevelFile(psiFile);
        Editor topLevelEditor = InjectedLanguageEditorUtil.getTopLevelEditor(editor);
        ArrayList actions = new ArrayList();
        Document document = topLevelFile.getFileDocument();
        Processor<HighlightInfo> processor = info -> {
            IntentionAction fix = info.getSameFamilyFix(this.myAction);
            if (fix != null) {
                TextRange range = TextRange.create(info.getActualStartOffset(), info.getActualEndOffset());
                SmartPsiFileRange pointer = SmartPointerManager.getInstance(project).createSmartPsiFileRangePointer(topLevelFile, range);
                actions.add(Pair.create(fix, pointer));
            }
            return true;
        };
        CodeInsightContext context = EditorContextManager.getEditorContext((Editor)editor, (Project)project);
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> DaemonCodeAnalyzerEx.processHighlights(document, project, null, 0, document.getTextLength(), context, (Processor<? super HighlightInfo>)processor)), AnalysisBundle.message("command.name.gather.fixes", new Object[0]), true, project)) {
            return;
        }
        if (actions.isEmpty() || !FileModificationService.getInstance().preparePsiElementForWrite(psiFile)) {
            return;
        }
        Collections.reverse(actions);
        List<Pair<ModCommandAction, SmartPsiFileRange>> modCommands = ContainerUtil.map(actions, pair -> Pair.create(((IntentionAction)pair.first).asModCommandAction(), (SmartPsiFileRange)pair.second));
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(project);
        String actionName = this.myAction.getFamilyName();
        if (ContainerUtil.all(modCommands, pair -> pair.first != null)) {
            FixAllHighlightingProblems.runModCommands(topLevelEditor, topLevelFile, actionName, modCommands);
        } else {
            ApplicationManagerEx.getApplicationEx().runWriteActionWithCancellableProgressInDispatchThread(actionName, project, null, indicator -> {
                indicator.setIndeterminate(false);
                for (int i = 0; i < actions.size(); ++i) {
                    indicator.setFraction((double)i / (double)actions.size());
                    Pair pair = (Pair)actions.get(i);
                    IntentionAction action2 = (IntentionAction)pair.getFirst();
                    Segment range = ((SmartPsiFileRange)pair.getSecond()).getRange();
                    if (range == null) continue;
                    topLevelEditor.getCaretModel().moveToOffset(range.getStartOffset());
                    if (!action2.isAvailable(project, editor, psiFile)) continue;
                    action2.invoke(project, editor, psiFile);
                    psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
                    psiDocumentManager.commitDocument(document);
                }
            });
        }
    }

    private static void runModCommands(final @Nullable Editor editor, final @NotNull PsiFile psiFile, @Nls String actionName, final @NotNull List<Pair<ModCommandAction, SmartPsiFileRange>> modCommands) {
        if (psiFile == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(5);
        }
        if (modCommands == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(6);
        }
        Project project = psiFile.getProject();
        final Document document = psiFile.getFileDocument();
        final PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(project);
        SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, actionName, true);
        progressTask.setMinIterationTime(200L);
        SequentialTask task = new SequentialTask(){
            int fixNumber = 0;

            @Override
            public boolean isDone() {
                return this.fixNumber >= modCommands.size();
            }

            @Override
            public boolean iteration(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setFraction((double)this.fixNumber / (double)modCommands.size());
                return this.iteration();
            }

            @Override
            public boolean iteration() {
                Pair pair;
                Segment range;
                if ((range = ((SmartPsiFileRange)(pair = (Pair)modCommands.get(this.fixNumber++)).getSecond()).getRange()) != null) {
                    ModCommandWithContext contextAndCommand = ModCommandService.getInstance().chooseFileAndPerform(psiFile, editor, (ModCommandAction)pair.first, range.getStartOffset());
                    if (contextAndCommand == null) {
                        return true;
                    }
                    contextAndCommand.executeInBatch();
                    psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
                    psiDocumentManager.commitDocument(document);
                }
                return this.fixNumber == modCommands.size();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/actions/FixAllHighlightingProblems$1", "iteration"));
            }
        };
        progressTask.setTask(task);
        ProgressManager.getInstance().run(progressTask);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/actions/FixAllHighlightingProblems";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modCommands";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/FixAllHighlightingProblems";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runModCommands";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

