/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import java.util.EventObject;
import org.jetbrains.annotations.Nullable;

public final class LookupEvent
extends EventObject {
    private final Lookup myLookup;
    private final LookupElement myItem;
    private final char myCompletionChar;
    private final boolean myCanceledExplicitly;

    public LookupEvent(Lookup lookup, boolean canceledExplicitly) {
        super(lookup);
        this.myLookup = lookup;
        this.myItem = null;
        this.myCompletionChar = '\u0000';
        this.myCanceledExplicitly = canceledExplicitly;
    }

    public LookupEvent(Lookup lookup, LookupElement item, char completionChar) {
        super(lookup);
        this.myLookup = lookup;
        this.myItem = item;
        this.myCompletionChar = completionChar;
        this.myCanceledExplicitly = false;
    }

    public Lookup getLookup() {
        return this.myLookup;
    }

    @Nullable(value="in case ENTER was pressed when no suggestions were available")
    public @Nullable(value="in case ENTER was pressed when no suggestions were available") LookupElement getItem() {
        return this.myItem;
    }

    public char getCompletionChar() {
        return this.myCompletionChar;
    }

    public boolean isCanceledExplicitly() {
        return this.myCanceledExplicitly;
    }

    public static boolean isSpecialCompletionChar(char c) {
        return c == '\u0000' || c == '\r' || c == '\n' || c == '\t';
    }
}

