/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.LiveTemplateContext;
import com.intellij.codeInsight.template.LiveTemplateContextService;
import com.intellij.codeInsight.template.LiveTemplateContextsSnapshot;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.util.JdomKt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class TemplateContext {
    private volatile Map<String, Boolean> myContextStates = Map.of();

    @NotNull
    public TemplateContext createCopy() {
        TemplateContext cloneResult = new TemplateContext();
        cloneResult.myContextStates = this.myContextStates;
        TemplateContext templateContext = cloneResult;
        if (templateContext == null) {
            TemplateContext.$$$reportNull$$$0(0);
        }
        return templateContext;
    }

    @ApiStatus.Internal
    public static boolean contextsEqual(@NotNull LiveTemplateContextsSnapshot allContexts, @NotNull TemplateImpl thisTemplate, @NotNull TemplateImpl defaultTemplate) {
        if (allContexts == null) {
            TemplateContext.$$$reportNull$$$0(1);
        }
        if (thisTemplate == null) {
            TemplateContext.$$$reportNull$$$0(2);
        }
        if (defaultTemplate == null) {
            TemplateContext.$$$reportNull$$$0(3);
        }
        return TemplateContext.getDifference(allContexts, thisTemplate.getTemplateContext(), defaultTemplate.getTemplateContext()) == null;
    }

    @ApiStatus.Internal
    @Nullable
    public static LiveTemplateContext getDifference(@NotNull LiveTemplateContextsSnapshot allContexts, @NotNull TemplateContext thisContext, @NotNull TemplateContext defaultContext) {
        if (allContexts == null) {
            TemplateContext.$$$reportNull$$$0(4);
        }
        if (thisContext == null) {
            TemplateContext.$$$reportNull$$$0(5);
        }
        if (defaultContext == null) {
            TemplateContext.$$$reportNull$$$0(6);
        }
        for (LiveTemplateContext value : allContexts.getLiveTemplateContexts()) {
            if (thisContext.isEnabled(allContexts, value) == defaultContext.isEnabled(allContexts, value)) continue;
            return value;
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static TemplateContextType getDifferenceType(@NotNull LiveTemplateContextsSnapshot allContexts, @NotNull TemplateContext thisContext, @NotNull TemplateContext defaultContext) {
        LiveTemplateContext differenceExtension;
        if (allContexts == null) {
            TemplateContext.$$$reportNull$$$0(7);
        }
        if (thisContext == null) {
            TemplateContext.$$$reportNull$$$0(8);
        }
        if (defaultContext == null) {
            TemplateContext.$$$reportNull$$$0(9);
        }
        if ((differenceExtension = TemplateContext.getDifference(allContexts, thisContext, defaultContext)) != null) {
            return differenceExtension.getTemplateContextType();
        }
        return null;
    }

    public synchronized boolean isEnabled(@NotNull TemplateContextType contextType) {
        if (contextType == null) {
            TemplateContext.$$$reportNull$$$0(10);
        }
        LiveTemplateContextsSnapshot allContexts = LiveTemplateContextService.getInstance().getSnapshot();
        return this.isEnabledNoSync(allContexts, contextType.getContextId());
    }

    private synchronized boolean isEnabled(@NotNull LiveTemplateContextsSnapshot allContexts, @NotNull LiveTemplateContext contextType) {
        if (allContexts == null) {
            TemplateContext.$$$reportNull$$$0(11);
        }
        if (contextType == null) {
            TemplateContext.$$$reportNull$$$0(12);
        }
        return this.isEnabledNoSync(allContexts, contextType.getContextId());
    }

    private boolean isEnabledNoSync(@NotNull LiveTemplateContextsSnapshot allContexts, @NotNull String contextTypeId) {
        Boolean storedValue;
        if (allContexts == null) {
            TemplateContext.$$$reportNull$$$0(13);
        }
        if (contextTypeId == null) {
            TemplateContext.$$$reportNull$$$0(14);
        }
        if ((storedValue = this.getOwnValueNoSync(contextTypeId)) == null) {
            LiveTemplateContext liveTemplateContext = allContexts.getLiveTemplateContext(contextTypeId);
            String baseContextTypeId = liveTemplateContext != null ? liveTemplateContext.getBaseContextId() : null;
            return baseContextTypeId != null && !baseContextTypeId.equals(contextTypeId) && this.isEnabledNoSync(allContexts, baseContextTypeId);
        }
        return storedValue;
    }

    @Nullable
    public Boolean getOwnValue(@NotNull TemplateContextType contextType) {
        if (contextType == null) {
            TemplateContext.$$$reportNull$$$0(15);
        }
        return this.getOwnValue(contextType.getContextId());
    }

    @Nullable
    private synchronized Boolean getOwnValue(String contextTypeId) {
        return this.getOwnValueNoSync(contextTypeId);
    }

    @Nullable
    private Boolean getOwnValueNoSync(String contextTypeId) {
        return this.myContextStates.get(contextTypeId);
    }

    public synchronized void setEnabled(@NotNull TemplateContextType contextType, boolean value) {
        if (contextType == null) {
            TemplateContext.$$$reportNull$$$0(16);
        }
        HashMap<String, Boolean> map2 = new HashMap<String, Boolean>(this.myContextStates);
        map2.put(contextType.getContextId(), value);
        this.myContextStates = Map.copyOf(map2);
    }

    @VisibleForTesting
    public synchronized void setDefaultContext(@NotNull TemplateContext defContext) {
        if (defContext == null) {
            TemplateContext.$$$reportNull$$$0(17);
        }
        HashMap<String, Boolean> copy = new HashMap<String, Boolean>(defContext.myContextStates);
        copy.putAll(this.myContextStates);
        this.myContextStates = Map.copyOf(copy);
    }

    @ApiStatus.Internal
    public void readTemplateContext(@NotNull Element element, @NotNull LiveTemplateContextService ltContextService) {
        if (element == null) {
            TemplateContext.$$$reportNull$$$0(18);
        }
        if (ltContextService == null) {
            TemplateContext.$$$reportNull$$$0(19);
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        Map<String, String> internMap = ltContextService.getInternalIds();
        for (Element option : element.getChildren("option")) {
            String name = option.getAttributeValue("name");
            String value = option.getAttributeValue("value");
            if (name == null || value == null) continue;
            result.put(internMap.getOrDefault(name, name), Boolean.parseBoolean(value));
        }
        this.myContextStates = result;
        result.putAll(this.makeInheritanceExplicit(this, ltContextService.getSnapshot()));
        this.myContextStates = Map.copyOf(result);
    }

    @VisibleForTesting
    public void readTemplateContext(@NotNull Element element) {
        if (element == null) {
            TemplateContext.$$$reportNull$$$0(20);
        }
        this.readTemplateContext(element, LiveTemplateContextService.getInstance());
    }

    @NotNull
    private Map<String, Boolean> makeInheritanceExplicit(TemplateContext context, LiveTemplateContextsSnapshot allContexts) {
        HashMap<String, Boolean> explicitStates = new HashMap<String, Boolean>();
        for (LiveTemplateContext type : allContexts.getLiveTemplateContexts()) {
            if (!this.isDisabledByInheritance(context, allContexts, type)) continue;
            explicitStates.put(type.getContextId(), false);
        }
        HashMap<String, Boolean> hashMap = explicitStates;
        if (hashMap == null) {
            TemplateContext.$$$reportNull$$$0(21);
        }
        return hashMap;
    }

    private boolean isDisabledByInheritance(TemplateContext thisContext, LiveTemplateContextsSnapshot allContexts, LiveTemplateContext type) {
        if (!thisContext.hasOwnValue(type) && !thisContext.isEnabled(allContexts, type)) {
            LiveTemplateContext context = type;
            while (context != null) {
                if (this.hasOwnValue(context)) {
                    return true;
                }
                context = allContexts.getLiveTemplateContext(context.getBaseContextId());
            }
        }
        return false;
    }

    private boolean hasOwnValue(LiveTemplateContext t) {
        return this.getOwnValue(t.getContextId()) != null;
    }

    @TestOnly
    public Element writeTemplateContext(@Nullable TemplateContext defaultContext) {
        return this.writeTemplateContext(defaultContext, TemplateContext.getIdToType());
    }

    @VisibleForTesting
    @Nullable
    public Element writeTemplateContext(@Nullable TemplateContext defaultContext, @NotNull Lazy<? extends Map<String, TemplateContextType>> idToType) {
        if (idToType == null) {
            TemplateContext.$$$reportNull$$$0(22);
        }
        if (this.myContextStates.isEmpty()) {
            return null;
        }
        Element element = new Element("context");
        ArrayList<Map.Entry<String, Boolean>> entries = new ArrayList<Map.Entry<String, Boolean>>(this.myContextStates.entrySet());
        entries.sort(Map.Entry.comparingByKey());
        for (Map.Entry entry : entries) {
            Boolean ownValue = (Boolean)entry.getValue();
            if (ownValue == null) continue;
            TemplateContextType type = (TemplateContextType)((Map)idToType.getValue()).get(entry.getKey());
            if (type == null) {
                JdomKt.addOptionTag((Element)element, (String)((String)entry.getKey()), (String)ownValue.toString());
                continue;
            }
            if (!this.isValueChanged(ownValue, type, defaultContext)) continue;
            JdomKt.addOptionTag((Element)element, (String)type.getContextId(), (String)ownValue.toString());
        }
        return element;
    }

    @NotNull
    public static Lazy<Map<String, TemplateContextType>> getIdToType() {
        Lazy lazy = LazyKt.lazy(() -> {
            HashMap<String, TemplateContextType> idToType = new HashMap<String, TemplateContextType>();
            for (LiveTemplateContext type : LiveTemplateContextService.getInstance().getLiveTemplateContexts()) {
                idToType.put(type.getContextId(), type.getTemplateContextType());
            }
            return idToType;
        });
        if (lazy == null) {
            TemplateContext.$$$reportNull$$$0(23);
        }
        return lazy;
    }

    private boolean isValueChanged(@NotNull Boolean ownValue, @NotNull TemplateContextType type, @Nullable TemplateContext defaultContext) {
        Boolean defaultValue;
        if (ownValue == null) {
            TemplateContext.$$$reportNull$$$0(24);
        }
        if (type == null) {
            TemplateContext.$$$reportNull$$$0(25);
        }
        Boolean bl = defaultValue = defaultContext == null ? null : defaultContext.getOwnValue(type.getContextId());
        if (defaultValue == null) {
            TemplateContextType base = type.getBaseContextType();
            boolean baseEnabled = base != null && this.isEnabled(base);
            return ownValue != baseEnabled;
        }
        return !ownValue.equals(defaultValue);
    }

    public String toString() {
        return this.myContextStates.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 24, 25 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateContext";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allContexts";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisTemplate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultTemplate";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisContext";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultContext";
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextTypeId";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defContext";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ltContextService";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownValue";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateContext";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "makeInheritanceExplicit";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdToType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contextsEqual";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDifference";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDifferenceType";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledNoSync";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOwnValue";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setEnabled";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultContext";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readTemplateContext";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "writeTemplateContext";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isValueChanged";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 24, 25 -> new IllegalArgumentException(string);
        };
    }
}

