/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.AnnotationSessionImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExternalAnnotatorInspectionVisitor
extends PsiElementVisitor {
    private static final Logger LOG = Logger.getInstance(ExternalAnnotatorInspectionVisitor.class);
    private final ProblemsHolder myHolder;
    private final ExternalAnnotator<?, ?> myAnnotator;
    private final boolean myIsOnTheFly;

    public ExternalAnnotatorInspectionVisitor(ProblemsHolder holder, ExternalAnnotator<?, ?> annotator, boolean isOnTheFly) {
        this.myHolder = holder;
        this.myAnnotator = annotator;
        this.myIsOnTheFly = isOnTheFly;
    }

    @Override
    public void visitFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(0);
        }
        ProblemDescriptor[] descriptors = ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator(psiFile, this.myHolder.getManager(), this.myIsOnTheFly, this.myAnnotator);
        this.addDescriptors(descriptors);
    }

    public static <Init, Result> ProblemDescriptor @NotNull [] checkFileWithExternalAnnotator(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull ExternalAnnotator<Init, Result> annotator) {
        if (file == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(2);
        }
        if (annotator == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(3);
        }
        if (isOnTheFly) {
            if (ProblemDescriptor.EMPTY_ARRAY == null) {
                ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(4);
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Object info = ReadAction.compute(() -> annotator.collectInformation(file));
        if (info != null) {
            Object annotationResult = annotator.doAnnotate(info);
            if (annotationResult == null) {
                if (ProblemDescriptor.EMPTY_ARRAY == null) {
                    ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(5);
                }
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            ProblemDescriptor[] problemDescriptorArray = ReadAction.compute(() -> AnnotationSessionImpl.computeWithSession(file, true, annotator, annotationHolder -> {
                ((AnnotationHolderImpl)annotationHolder).applyExternalAnnotatorWithContext(file, annotationResult);
                ((AnnotationHolderImpl)annotationHolder).assertAllAnnotationsCreated();
                return ProblemDescriptorUtil.convertToProblemDescriptors((List)((Object)annotationHolder), file);
            }));
            if (problemDescriptorArray == null) {
                ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(6);
            }
            return problemDescriptorArray;
        }
        if (ProblemDescriptor.EMPTY_ARRAY == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(7);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private void addDescriptors(ProblemDescriptor @NotNull [] descriptors) {
        if (descriptors == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(8);
        }
        for (ProblemDescriptor descriptor : descriptors) {
            LOG.assertTrue(descriptor != null, this.getClass().getName());
            this.myHolder.registerProblem(descriptor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "checkFileWithExternalAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkFileWithExternalAnnotator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    @Deprecated
    public static class LocalQuickFixBackedByIntentionAction
    extends com.intellij.codeInspection.LocalQuickFixBackedByIntentionAction {
        public LocalQuickFixBackedByIntentionAction(@NotNull IntentionAction action2) {
            if (action2 == null) {
                LocalQuickFixBackedByIntentionAction.$$$reportNull$$$0(0);
            }
            super(action2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor$LocalQuickFixBackedByIntentionAction", "<init>"));
        }
    }
}

