/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionEP
extends LanguageExtensionPoint<InspectionProfileEntry>
implements InspectionProfileEntry.DefaultNameProvider {
    private static final Logger LOG = Logger.getInstance(InspectionEP.class);
    public static final ExtensionPointName<InspectionEP> GLOBAL_INSPECTION = new ExtensionPointName("com.intellij.globalInspection");
    @Attribute(value="shortName")
    public String shortName;
    @Attribute(value="projectType")
    public String projectType;
    @Attribute(value="key")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String key;
    @Attribute(value="bundle")
    public String bundle;
    @Attribute(value="displayName")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String displayName;
    @Attribute(value="groupKey")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String groupKey;
    @Attribute(value="groupBundle")
    public String groupBundle;
    @Attribute(value="groupName")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String groupDisplayName;
    @Attribute(value="groupPath")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String groupPath;
    @Attribute(value="groupPathKey")
    public String groupPathKey;
    @Attribute(value="enabledByDefault")
    public boolean enabledByDefault;
    @Attribute(value="applyToDialects")
    public boolean applyToDialects;
    @Attribute(value="cleanupTool")
    public boolean cleanupTool;
    @Attribute(value="level")
    public String level;
    @Attribute(value="hasStaticDescription")
    public boolean hasStaticDescription;
    @Attribute(value="presentation")
    public String presentation;
    @Attribute(value="isInternal")
    public boolean isInternal;
    @Attribute(value="editorAttributes")
    public String editorAttributes;

    @NonNls
    @NotNull
    public String getShortName() {
        if (this.implementationClass == null) {
            throw new IllegalArgumentException(this.toString());
        }
        String string = this.shortName != null ? this.shortName : InspectionProfileEntry.getShortName(StringUtil.getShortName(this.implementationClass));
        if (string == null) {
            InspectionEP.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.getLocalizedString(this.bundle, this.key);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public String getGroupDisplayName() {
        return this.groupDisplayName != null ? this.groupDisplayName : this.getLocalizedString(this.groupBundle, this.groupKey);
    }

    @Override
    @Nullable
    public String getGroupKey() {
        return this.groupKey;
    }

    protected InspectionEP() {
        this.applyToDialects = true;
    }

    @NonInjectable
    public InspectionEP(@NotNull String implementationClass, @NotNull PluginDescriptor pluginDescriptor) {
        if (implementationClass == null) {
            InspectionEP.$$$reportNull$$$0(1);
        }
        if (pluginDescriptor == null) {
            InspectionEP.$$$reportNull$$$0(2);
        }
        this.applyToDialects = true;
        this.implementationClass = implementationClass;
        this.setPluginDescriptor(pluginDescriptor);
    }

    public String @Nullable [] getGroupPath() {
        String name = this.getGroupDisplayName();
        if (name == null) {
            return null;
        }
        String path = null;
        if (this.groupPath != null) {
            path = this.groupPath;
        } else if (this.groupPathKey != null) {
            path = this.getLocalizedString(this.groupBundle, this.groupPathKey);
        }
        if (path == null) {
            return new String[]{name.isEmpty() ? InspectionProfileEntry.getGeneralGroupName() : name};
        }
        return ArrayUtil.append(path.split(","), name);
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        if (this.level == null) {
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
            if (highlightDisplayLevel == null) {
                InspectionEP.$$$reportNull$$$0(3);
            }
            return highlightDisplayLevel;
        }
        HighlightDisplayLevel displayLevel = HighlightDisplayLevel.find(this.level);
        if (displayLevel == null) {
            LOG.error(new PluginException("Can't find highlight display level: " + this.level + "; registered for: " + this.implementationClass + "; and short name: " + this.shortName, this.getPluginDescriptor().getPluginId()));
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
            if (highlightDisplayLevel == null) {
                InspectionEP.$$$reportNull$$$0(4);
            }
            return highlightDisplayLevel;
        }
        HighlightDisplayLevel highlightDisplayLevel = displayLevel;
        if (highlightDisplayLevel == null) {
            InspectionEP.$$$reportNull$$$0(5);
        }
        return highlightDisplayLevel;
    }

    @Nullable
    @Nls
    private String getLocalizedString(@Nullable String bundleName, String key) {
        String baseName;
        PluginDescriptor descriptor = this.getPluginDescriptor();
        String string = bundleName != null ? bundleName : (baseName = this.bundle != null ? this.bundle : descriptor.getResourceBundleBaseName());
        if (baseName == null || key == null) {
            if (bundleName != null) {
                LOG.warn("Cannot resolve message key '" + key + "' for " + this.implementationClass);
            }
            return null;
        }
        ResourceBundle resourceBundle = DynamicBundle.getResourceBundle(descriptor.getClassLoader(), baseName);
        return AbstractBundle.message(resourceBundle, key, new Object[0]);
    }

    @NotNull
    public InspectionProfileEntry instantiateTool() {
        InspectionProfileEntry entry = (InspectionProfileEntry)this.createInstance(ApplicationManager.getApplication());
        entry.setNameProvider(this);
        InspectionProfileEntry inspectionProfileEntry = entry;
        if (inspectionProfileEntry == null) {
            InspectionEP.$$$reportNull$$$0(6);
        }
        return inspectionProfileEntry;
    }

    @Override
    public String getDefaultShortName() {
        return this.getShortName();
    }

    @Override
    public String getDefaultDisplayName() {
        return this.getDisplayName();
    }

    @Override
    public String getDefaultGroupDisplayName() {
        return this.getGroupDisplayName();
    }

    public String toString() {
        return "InspectionEP{shortName='" + this.shortName + "', key='" + this.key + "', bundle='" + this.bundle + "', displayName='" + this.displayName + "', groupKey='" + this.groupKey + "', groupBundle='" + this.groupBundle + "', groupDisplayName='" + this.groupDisplayName + "', groupPath='" + this.groupPath + "', enabledByDefault=" + this.enabledByDefault + ", applyToDialects=" + this.applyToDialects + ", cleanupTool=" + this.cleanupTool + ", level='" + this.level + "', editorAttributes='" + this.editorAttributes + "', hasStaticDescription=" + this.hasStaticDescription + ", presentation='" + this.presentation + "', isInternal=" + this.isInternal + ", getImplementationClassName()='" + this.getImplementationClassName() + "', language=" + this.language + ", pluginDescriptor=" + String.valueOf(this.getPluginDescriptor()) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/InspectionEP";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementationClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/InspectionEP";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateTool";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

