/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface InspectionProfile
extends Comparable<Object> {
    public static final String DEFAULT_PROFILE_NAME = "Default";

    @NotNull
    @NlsSafe
    public String getName();

    @NotNull
    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey var1, PsiElement var2);

    @RequiresReadLock
    @Nullable
    public InspectionToolWrapper<?, ?> getInspectionTool(@NotNull String var1, @Nullable PsiElement var2);

    @Nullable
    public InspectionToolWrapper<?, ?> getInspectionTool(@NotNull String var1, Project var2);

    @Nullable
    public InspectionProfileEntry getUnwrappedTool(@NotNull String var1, @NotNull PsiElement var2);

    @Nullable
    public <T extends InspectionProfileEntry> T getUnwrappedTool(@NotNull Key<T> var1, @NotNull PsiElement var2);

    public <T extends InspectionProfileEntry> void modifyToolSettings(@NotNull Key<T> var1, @NotNull PsiElement var2, @NotNull Consumer<? super T> var3);

    @NotNull
    public @Unmodifiable List<InspectionToolWrapper<?, ?>> getInspectionTools(@Nullable PsiElement var1);

    public boolean isToolEnabled(@Nullable HighlightDisplayKey var1, @Nullable PsiElement var2);

    default public boolean isToolEnabled(@Nullable HighlightDisplayKey key) {
        return this.isToolEnabled(key, null);
    }

    @Nullable
    default public TextAttributesKey getEditorAttributes(@NotNull String shortName, @Nullable PsiElement element) {
        String key;
        InspectionToolWrapper<?, ?> tool;
        if (shortName == null) {
            InspectionProfile.$$$reportNull$$$0(0);
        }
        if ((tool = this.getInspectionTool(shortName, element)) != null && (key = tool.getDefaultEditorAttributes()) != null) {
            return TextAttributesKey.find(key);
        }
        return null;
    }

    public boolean isExecutable(@Nullable Project var1);

    @Nullable
    public String getSingleTool();

    @NotNull
    public String getDisplayName();

    @NotNull
    public @Unmodifiable List<Tools> getAllEnabledInspectionTools(Project var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/InspectionProfile", "getEditorAttributes"));
    }
}

