/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ReflectionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalQuickFixOnPsiElement
implements LocalQuickFix,
Cloneable {
    protected static final Logger LOG = Logger.getInstance(LocalQuickFixOnPsiElement.class);
    @FileModifier.SafeFieldForPreview
    protected final SmartPsiElementPointer<PsiElement> myStartElement;
    @FileModifier.SafeFieldForPreview
    protected final SmartPsiElementPointer<PsiElement> myEndElement;

    protected LocalQuickFixOnPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(0);
        }
        this(element, element);
    }

    public LocalQuickFixOnPsiElement(PsiElement startElement, PsiElement endElement) {
        PsiFile endContainingFile;
        if (startElement == null || endElement == null) {
            this.myEndElement = null;
            this.myStartElement = null;
            return;
        }
        LOG.assertTrue(startElement.isValid());
        PsiFile startContainingFile = startElement.getContainingFile();
        PsiFile psiFile = endContainingFile = startElement == endElement ? startContainingFile : endElement.getContainingFile();
        if (startElement != endElement) {
            LOG.assertTrue(endElement.isValid());
            LOG.assertTrue(startContainingFile == endContainingFile, "Both elements must be from the same file");
        }
        Project project = startContainingFile == null ? startElement.getProject() : startContainingFile.getProject();
        this.myStartElement = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(startElement, startContainingFile);
        this.myEndElement = endElement == startElement ? null : SmartPointerManager.getInstance(project).createSmartPsiElementPointer(endElement, endContainingFile);
    }

    @Override
    @NotNull
    public final String getName() {
        String string = this.getText();
        if (string == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(5);
        }
        return true;
    }

    protected boolean isAvailable() {
        if (this.myStartElement == null) {
            return false;
        }
        PsiElement startElement = this.myStartElement.getElement();
        PsiElement endElement = this.myEndElement == null ? startElement : this.myEndElement.getElement();
        PsiFile psiFile = this.myStartElement.getContainingFile();
        Project project = this.myStartElement.getProject();
        return startElement != null && endElement != null && psiFile != null && this.isAvailable(project, psiFile, startElement, endElement);
    }

    public PsiElement getStartElement() {
        return this.myStartElement == null ? null : this.myStartElement.getElement();
    }

    public PsiElement getEndElement() {
        return this.myEndElement == null ? null : this.myEndElement.getElement();
    }

    @IntentionName
    @NotNull
    public abstract String getText();

    @Override
    public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(7);
        }
        this.applyFix();
    }

    public void applyFix() {
        PsiElement endElement;
        if (this.myStartElement == null) {
            return;
        }
        PsiElement startElement = this.myStartElement.getElement();
        PsiElement psiElement = endElement = this.myEndElement == null ? startElement : this.myEndElement.getElement();
        if (startElement == null || endElement == null) {
            return;
        }
        PsiFile psiFile = startElement.getContainingFile();
        if (psiFile == null) {
            return;
        }
        this.invoke(psiFile.getProject(), psiFile, startElement, endElement);
    }

    public abstract void invoke(@NotNull Project var1, @NotNull PsiFile var2, @NotNull PsiElement var3, @NotNull PsiElement var4);

    @Override
    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        LocalQuickFixOnPsiElement clone;
        if (target == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(8);
        }
        if (LocalQuickFix.super.getFileModifierForPreview(target) != this) {
            return null;
        }
        PsiElement startElement = this.getStartElement();
        PsiElement endElement = this.getEndElement();
        if (startElement == null && this.myStartElement != null || endElement == null && this.myEndElement != null) {
            return null;
        }
        if (startElement != null && startElement.getContainingFile() != target.getOriginalFile()) {
            return null;
        }
        startElement = PsiTreeUtil.findSameElementInCopy(startElement, target);
        endElement = PsiTreeUtil.findSameElementInCopy(endElement, target);
        try {
            clone = (LocalQuickFixOnPsiElement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
        if (startElement != null) {
            ReflectionUtil.setField(LocalQuickFixOnPsiElement.class, clone, SmartPsiElementPointer.class, "myStartElement", SmartPointerManager.createPointer(startElement));
        }
        if (endElement != null) {
            ReflectionUtil.setField(LocalQuickFixOnPsiElement.class, clone, SmartPsiElementPointer.class, "myEndElement", SmartPointerManager.createPointer(endElement));
        }
        return clone;
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            LocalQuickFixOnPsiElement.$$$reportNull$$$0(9);
        }
        if (!this.startInWriteAction()) {
            return null;
        }
        if (this.myStartElement != null) {
            return this.myStartElement.getContainingFile();
        }
        return currentFile;
    }

    @Deprecated
    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/LocalQuickFixOnPsiElement";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/LocalQuickFixOnPsiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

