/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.interpreter;

import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class StateQueue {
    private static final int FORCE_MERGE_THRESHOLD = 100;
    private boolean myWasForciblyMerged;
    private final PriorityQueue<DfaInstructionState> myQueue = new PriorityQueue();
    private final Map<DfaInstructionState, DfaInstructionState> myMap = new HashMap<DfaInstructionState, DfaInstructionState>();

    public void offer(DfaInstructionState state2) {
        DfaInstructionState otherState = this.myMap.putIfAbsent(state2, state2);
        if (otherState == null) {
            this.myQueue.offer(state2);
        } else {
            otherState.getMemoryState().afterMerge(state2.getMemoryState());
        }
    }

    public boolean isEmpty() {
        return this.myQueue.isEmpty();
    }

    public boolean processAll(@NotNull Processor<? super DfaInstructionState> processor) {
        if (processor == null) {
            StateQueue.$$$reportNull$$$0(0);
        }
        for (DfaInstructionState state2 : this.myQueue) {
            if (processor.process(state2)) continue;
            return false;
        }
        return true;
    }

    public @Unmodifiable @NotNull List<DfaInstructionState> getNextInstructionStates(Set<Instruction> joinInstructions) {
        DfaInstructionState state2 = (DfaInstructionState)this.myQueue.remove();
        Instruction instruction = state2.getInstruction();
        this.myMap.remove(state2);
        DfaInstructionState next = this.myQueue.peek();
        if (next == null || next.compareTo(state2) != 0) {
            List<DfaInstructionState> list = Collections.singletonList(state2);
            if (list == null) {
                StateQueue.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<DfaMemoryState> memoryStates = new ArrayList<DfaMemoryState>();
        memoryStates.add(state2.getMemoryState());
        while (!this.myQueue.isEmpty() && this.myQueue.peek().compareTo(state2) == 0) {
            DfaInstructionState anotherInstructionState = this.myQueue.poll();
            this.myMap.remove(anotherInstructionState);
            memoryStates.add(anotherInstructionState.getMemoryState());
        }
        if ((memoryStates = this.forceMerge(memoryStates)).size() > 1 && joinInstructions.contains(instruction)) {
            StateQueue.squash(memoryStates);
        }
        List<DfaInstructionState> list = ContainerUtil.map(memoryStates, state1 -> new DfaInstructionState(instruction, (DfaMemoryState)state1));
        if (list == null) {
            StateQueue.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<DfaMemoryState> squash(List<DfaMemoryState> states) {
        block0: for (int i = 1; i < states.size(); ++i) {
            DfaMemoryState left = states.get(i);
            if (left == null) continue;
            for (int j = 0; j < i; ++j) {
                ProgressManager.checkCanceled();
                DfaMemoryState right = states.get(j);
                if (right == null) continue;
                DfaMemoryState result = left.tryJoinExactly(right);
                if (result == left) {
                    states.set(j, null);
                    continue;
                }
                if (result == right) {
                    states.set(i, null);
                    continue block0;
                }
                if (result == null) continue;
                states.set(i, null);
                states.set(j, null);
                states.add(result);
                continue block0;
            }
        }
        states.removeIf(Objects::isNull);
        List<DfaMemoryState> list = states;
        if (list == null) {
            StateQueue.$$$reportNull$$$0(3);
        }
        return list;
    }

    private List<DfaMemoryState> forceMerge(List<DfaMemoryState> states) {
        if (states.size() < 100) {
            return states;
        }
        this.myWasForciblyMerged = true;
        Collection<List<DfaMemoryState>> groups = StreamEx.of(states).groupingBy(DfaMemoryState::getMergeabilityKey).values();
        return ((StreamEx)((AbstractStreamEx)StreamEx.of(groups).flatMap(group -> StreamEx.ofSubLists(group, 2).map(pair -> {
            if (pair.size() == 2) {
                ((DfaMemoryState)pair.get(0)).merge((DfaMemoryState)pair.get(1));
            }
            return (DfaMemoryState)pair.get(0);
        }))).distinct()).toListAndThen(StateQueue::squash);
    }

    public boolean wasForciblyMerged() {
        return this.myWasForciblyMerged;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/interpreter/StateQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/interpreter/StateQueue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextInstructionStates";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "squash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

