/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.lang.ir;

import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

final class LiveVariablesAnalyzer {
    private final Instruction[] myInstructions;
    private final MultiMap<Instruction, Instruction> myForwardMap;
    private final MultiMap<Instruction, Instruction> myBackwardMap;
    private final DfaValueFactory myFactory;

    LiveVariablesAnalyzer(ControlFlow flow) {
        this.myFactory = flow.getFactory();
        this.myInstructions = flow.getInstructions();
        this.myForwardMap = this.calcForwardMap();
        this.myBackwardMap = this.calcBackwardMap();
    }

    private boolean isInterestingInstruction(Instruction instruction) {
        if (instruction == this.myInstructions[0]) {
            return true;
        }
        if (!instruction.getRequiredDescriptors(this.myFactory).isEmpty()) {
            return true;
        }
        return !instruction.isLinear() || instruction instanceof FinishElementInstruction;
    }

    @Nullable
    private Map<FinishElementInstruction, Set<VariableDescriptor>> findLiveVars() {
        HashMap<FinishElementInstruction, Set<VariableDescriptor>> result = new HashMap<FinishElementInstruction, Set<VariableDescriptor>>();
        boolean ok = this.runDfa(false, (instruction, liveVars) -> {
            if (instruction instanceof FinishElementInstruction) {
                FinishElementInstruction finishInstruction = (FinishElementInstruction)instruction;
                Set set = (Set)result.get(instruction);
                if (set != null) {
                    set.addAll(liveVars);
                    return new HashSet(set);
                }
                if (!liveVars.isEmpty()) {
                    result.put(finishInstruction, new HashSet(liveVars));
                }
            }
            var processor = new Consumer<VariableDescriptor>(){
                boolean cloned = false;
                Set<VariableDescriptor> newVars = this.val$liveVars;
                final /* synthetic */ Set val$liveVars;
                {
                    this.val$liveVars = set;
                }

                @Override
                public void accept(VariableDescriptor value) {
                    if (!this.newVars.contains(value)) {
                        if (!this.cloned) {
                            this.newVars = new HashSet<VariableDescriptor>(this.newVars);
                            this.cloned = true;
                        }
                        this.newVars.add(value);
                    }
                }
            };
            instruction.getRequiredDescriptors(this.myFactory).forEach(processor);
            return processor.newVars;
        });
        return ok ? result : null;
    }

    void flushDeadVariablesOnStatementFinish() {
        Map<FinishElementInstruction, Set<VariableDescriptor>> liveVars = this.findLiveVars();
        if (liveVars == null) {
            return;
        }
        MultiMap toFlush = MultiMap.createSet();
        boolean ok = this.runDfa(true, (instruction, prevLiveVars) -> {
            if (instruction instanceof FinishElementInstruction) {
                FinishElementInstruction finishInstruction = (FinishElementInstruction)instruction;
                HashSet currentlyLive = (HashSet)liveVars.get(instruction);
                if (currentlyLive == null) {
                    currentlyLive = new HashSet();
                }
                for (VariableDescriptor var : prevLiveVars) {
                    if (currentlyLive.contains(var)) continue;
                    toFlush.putValue(finishInstruction, var);
                }
                return currentlyLive;
            }
            return prevLiveVars;
        });
        if (ok) {
            for (FinishElementInstruction instruction2 : toFlush.keySet()) {
                Collection<VariableDescriptor> values2 = toFlush.get(instruction2);
                values2.removeIf(var -> var.isImplicitReadPossible());
                instruction2.flushVars(values2);
            }
        }
    }

    private List<Instruction> getSuccessors(Instruction ins) {
        return IntStreamEx.of(ins.getSuccessorIndexes()).elements(this.myInstructions).toList();
    }

    private MultiMap<Instruction, Instruction> calcBackwardMap() {
        MultiMap<Instruction, Instruction> result = MultiMap.create();
        for (Instruction instruction : this.myInstructions) {
            for (Instruction next : this.myForwardMap.get(instruction)) {
                result.putValue(next, instruction);
            }
        }
        return result;
    }

    private MultiMap<Instruction, Instruction> calcForwardMap() {
        MultiMap<Instruction, Instruction> result = MultiMap.create();
        for (Instruction instruction : this.myInstructions) {
            if (!this.isInterestingInstruction(instruction)) continue;
            block1: for (Instruction next : this.getSuccessors(instruction)) {
                while (true) {
                    if (this.isInterestingInstruction(next)) {
                        result.putValue(instruction, next);
                        continue block1;
                    }
                    if (next.getIndex() + 1 >= this.myInstructions.length) continue block1;
                    next = this.myInstructions[next.getIndex() + 1];
                }
            }
        }
        return result;
    }

    private boolean runDfa(boolean forward, BiFunction<? super Instruction, ? super Set<VariableDescriptor>, ? extends Set<VariableDescriptor>> handleState) {
        List<Instruction> entryPoints = forward ? List.of(this.myInstructions[0]) : ((StreamEx)StreamEx.of(this.myInstructions).select(ControlTransferInstruction.class).filter(cti -> cti.getTransfer().getTarget().getPossibleTargets().length == 0)).collect(Collectors.toList());
        ArrayDeque<InstructionState> queue = new ArrayDeque<InstructionState>(10);
        for (Instruction i : entryPoints) {
            queue.addLast(new InstructionState(i, new HashSet<VariableDescriptor>()));
        }
        int limit = this.myForwardMap.size() * 100;
        HashMap<Set, IntSet> processed2 = new HashMap<Set, IntSet>();
        int steps = 0;
        while (!queue.isEmpty()) {
            if (steps > limit) {
                return false;
            }
            if (steps % 1024 == 0) {
                ProgressManager.checkCanceled();
            }
            InstructionState state2 = (InstructionState)queue.removeFirst();
            Instruction instruction = state2.instruction;
            Collection<Instruction> nextInstructions = forward ? this.myForwardMap.get(instruction) : this.myBackwardMap.get(instruction);
            Set<VariableDescriptor> nextVars = handleState.apply(instruction, state2.nextVars);
            for (Instruction next : nextInstructions) {
                int index;
                IntSet instructionSet = processed2.computeIfAbsent(nextVars, k -> new IntOpenHashSet());
                if (instructionSet.contains(index = next.getIndex() + 1)) continue;
                instructionSet.add(index);
                queue.addLast(new InstructionState(next, nextVars));
                ++steps;
            }
        }
        return true;
    }

    private record InstructionState(Instruction instruction, Set<VariableDescriptor> nextVars) {
    }
}

