/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.lang.ir;

import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.util.ArrayUtil;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class LoopAnalyzer {
    LoopAnalyzer() {
    }

    static int[] calcInLoop(ControlFlow controlFlow) {
        int[] loop = new int[controlFlow.getInstructionCount()];
        MyGraph graph2 = new MyGraph(controlFlow);
        DFSTBuilder<Instruction> builder = new DFSTBuilder<Instruction>(graph2);
        IntList sccs = builder.getSCCs();
        int tNumber = 0;
        int component = 0;
        IntListIterator iterator2 = sccs.iterator();
        while (iterator2.hasNext()) {
            int size = iterator2.nextInt();
            int value = size > 1 ? ++component : 0;
            for (int i = 0; i < size; ++i) {
                Instruction instruction = builder.getNodeByTNumber(tNumber + i);
                loop[instruction.getIndex()] = value;
            }
            tNumber += size;
        }
        return loop;
    }

    private static final class MyGraph
    implements Graph<Instruction> {
        @NotNull
        private final ControlFlow myFlow;
        private final Instruction[] myInstructions;
        private final Int2ObjectMap<int[]> myIns;

        private MyGraph(@NotNull ControlFlow flow) {
            if (flow == null) {
                MyGraph.$$$reportNull$$$0(0);
            }
            this.myIns = new Int2ObjectOpenHashMap<int[]>();
            this.myFlow = flow;
            for (Instruction instruction : this.myInstructions = flow.getInstructions()) {
                int[] to;
                int fromIndex = instruction.getIndex();
                for (int toIndex : to = instruction.getSuccessorIndexes()) {
                    int[] froms = (int[])this.myIns.get(toIndex);
                    froms = froms == null ? new int[]{fromIndex} : ArrayUtil.append(froms, fromIndex);
                    this.myIns.put(toIndex, froms);
                }
            }
        }

        @Override
        @NotNull
        public Collection<Instruction> getNodes() {
            List<Instruction> list = Arrays.asList(this.myFlow.getInstructions());
            if (list == null) {
                MyGraph.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public Iterator<Instruction> getIn(Instruction n) {
            int[] ins = (int[])this.myIns.get(n.getIndex());
            return this.indicesToInstructions(ins);
        }

        @Override
        @NotNull
        public Iterator<Instruction> getOut(Instruction instruction) {
            int[] next = instruction.getSuccessorIndexes();
            return this.indicesToInstructions(next);
        }

        @NotNull
        private Iterator<Instruction> indicesToInstructions(int[] next) {
            if (next == null) {
                Iterator<Instruction> iterator2 = Collections.emptyIterator();
                if (iterator2 == null) {
                    MyGraph.$$$reportNull$$$0(2);
                }
                return iterator2;
            }
            ArrayList<Instruction> out = new ArrayList<Instruction>(next.length);
            for (int i : next) {
                out.add(this.myInstructions[i]);
            }
            Iterator<Instruction> iterator3 = out.iterator();
            if (iterator3 == null) {
                MyGraph.$$$reportNull$$$0(3);
            }
            return iterator3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/lang/ir/LoopAnalyzer$MyGraph";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/lang/ir/LoopAnalyzer$MyGraph";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodes";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "indicesToInstructions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

