/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.codeInspection.ex.InspectionsMetaInformation;
import com.intellij.codeInspection.ex.MetaInformation;
import com.intellij.codeInspection.ex.MetaInformationState;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginModuleDescriptor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.lang.UrlClassLoader;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J,\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015H\u0002R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInspection/ex/InspectionMetaInformationService;", "", "serviceScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "loadJob", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlinx/coroutines/Deferred;", "Lcom/intellij/codeInspection/ex/MetaInformationState;", "invalidateState", "", "getState", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadState", "readPluginMetaInformation", "classLoader", "Lcom/intellij/util/lang/UrlClassLoader;", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "storage", "", "", "Lcom/intellij/codeInspection/ex/MetaInformation;", "intellij.platform.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nInspectionMetainformationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionMetainformationService.kt\ncom/intellij/codeInspection/ex/InspectionMetaInformationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1869#2,2:120\n*S KotlinDebug\n*F\n+ 1 InspectionMetainformationService.kt\ncom/intellij/codeInspection/ex/InspectionMetaInformationService\n*L\n113#1:120,2\n*E\n"})
public final class InspectionMetaInformationService {
    @NotNull
    private final AtomicReference<Deferred<MetaInformationState>> loadJob;

    public InspectionMetaInformationService(@NotNull CoroutineScope serviceScope) {
        Intrinsics.checkNotNullParameter((Object)serviceScope, (String)"serviceScope");
        this.loadJob = new AtomicReference();
        Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect(serviceScope).subscribe(DynamicPluginListener.TOPIC, new DynamicPluginListener(){

            @Override
            public void pluginLoaded(IdeaPluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.invalidateState();
            }

            @Override
            public void pluginUnloaded(IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.invalidateState();
            }
        });
    }

    public final void invalidateState() {
        this.loadJob.set(null);
    }

    @Nullable
    public final Object getState(@NotNull Continuation<? super MetaInformationState> $completion) {
        Deferred<MetaInformationState> deferred2 = this.loadJob.get();
        if (deferred2 == null) {
            deferred2 = this.loadState();
        }
        Deferred<MetaInformationState> job2 = deferred2;
        return job2.await($completion);
    }

    private final Deferred<MetaInformationState> loadState() {
        CompletableDeferred deferred2 = CompletableDeferredKt.CompletableDeferred$default(null, 1, null);
        while (!this.loadJob.compareAndSet(null, deferred2)) {
            Deferred<MetaInformationState> deferred3 = this.loadJob.get();
            if (deferred3 == null) continue;
            Deferred<MetaInformationState> it = deferred3;
            boolean bl = false;
            return it;
        }
        Throwable error = null;
        Set visited = new LinkedHashSet();
        Map result = new LinkedHashMap();
        for (PluginModuleDescriptor plugin : PluginManagerCore.getPluginSet().getEnabledModules()) {
            ClassLoader classLoader;
            if (plugin.getPluginClassLoader() == null || !visited.add(classLoader) || !(classLoader instanceof UrlClassLoader)) continue;
            try {
                this.readPluginMetaInformation((UrlClassLoader)classLoader, plugin, result);
            }
            catch (Throwable e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                ExceptionsKt.addSuppressed((Throwable)error, (Throwable)e);
            }
        }
        if (error != null) {
            this.loadJob.set(null);
            v0 = deferred2.completeExceptionally(error);
        } else {
            v0 = deferred2.complete(new MetaInformationState(result));
        }
        return deferred2;
    }

    private final void readPluginMetaInformation(UrlClassLoader classLoader, IdeaPluginDescriptorImpl plugin, Map<String, MetaInformation> storage) {
        classLoader.processResources("inspectionDescriptions", arg_0 -> InspectionMetaInformationService.readPluginMetaInformation$lambda$2(InspectionMetaInformationService::readPluginMetaInformation$lambda$1, arg_0), (arg_0, arg_1) -> InspectionMetaInformationService.readPluginMetaInformation$lambda$5((arg_0, arg_1) -> InspectionMetaInformationService.readPluginMetaInformation$lambda$4(plugin, storage, arg_0, arg_1), arg_0, arg_1));
    }

    private static final boolean readPluginMetaInformation$lambda$1(String it) {
        return Intrinsics.areEqual((Object)"inspectionDescriptions/metaInformation.json", (Object)it);
    }

    private static final boolean readPluginMetaInformation$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit readPluginMetaInformation$lambda$4(IdeaPluginDescriptorImpl $plugin, Map $storage, String string, InputStream inputStream) {
        if (inputStream.available() <= 0) {
            return Unit.INSTANCE;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        InspectionsMetaInformation value = (InspectionsMetaInformation)objectMapper.readValue(inputStream, InspectionsMetaInformation.class);
        Iterable $this$forEach$iv = value.getInspections();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MetaInformation it = (MetaInformation)element$iv;
            boolean bl = false;
            if (((CharSequence)it.getId()).length() == 0) {
                throw new IllegalStateException("Empty id in inspection metaInformation.json. " + $plugin);
            }
            $storage.put(it.getId(), it);
        }
        return Unit.INSTANCE;
    }

    private static final void readPluginMetaInformation$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

