/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionToolsRegistrarCore;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.ToolLanguageUtil;
import com.intellij.diagnostic.PluginException;
import com.intellij.l10n.LocalizationUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.serviceContainer.BaseKeyedLazyInstance;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionToolWrapper<T extends InspectionProfileEntry, E extends InspectionEP> {
    public static final InspectionToolWrapper[] EMPTY_ARRAY = new InspectionToolWrapper[0];
    private static final String INSPECTION_DESCRIPTIONS_FOLDER = "inspectionDescriptions";
    private static final Logger LOG = Logger.getInstance(InspectionToolWrapper.class);
    private static final Pattern ADDENDUM_PLACE = Pattern.compile("<p><small>New in [\\d.]+</small></p>|(</body>)?\\s*</html>", 2);
    protected T myTool;
    @ApiStatus.Internal
    public final E myEP;
    @Nullable
    private HighlightDisplayKey myDisplayKey;
    private volatile Set<String> applicableToLanguages;

    protected InspectionToolWrapper(@NotNull E ep) {
        if (ep == null) {
            InspectionToolWrapper.$$$reportNull$$$0(0);
        }
        this(null, ep);
    }

    protected InspectionToolWrapper(@NotNull T tool) {
        if (tool == null) {
            InspectionToolWrapper.$$$reportNull$$$0(1);
        }
        this(tool, null);
    }

    protected InspectionToolWrapper(@Nullable T tool, @Nullable E ep) {
        assert (tool != null || ep != null) : "must not be both null";
        this.myEP = ep;
        this.myTool = tool;
    }

    protected InspectionToolWrapper(@NotNull InspectionToolWrapper<T, ? extends E> other) {
        if (other == null) {
            InspectionToolWrapper.$$$reportNull$$$0(2);
        }
        this.myEP = other.myEP;
        this.myTool = other.myTool == null ? null : (this.myEP == null ? (InspectionProfileEntry)InspectionToolsRegistrarCore.instantiateTool(other.myTool.getClass()) : ((InspectionEP)this.myEP).instantiateTool());
    }

    public void initialize(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            InspectionToolWrapper.$$$reportNull$$$0(3);
        }
        ((InspectionProfileEntry)this.getTool()).initialize(context);
    }

    @NotNull
    public abstract InspectionToolWrapper<T, E> createCopy();

    @NotNull
    public T getTool() {
        Object tool = this.myTool;
        if (tool == null) {
            tool = ((InspectionEP)this.myEP).instantiateTool();
            this.myTool = tool;
            if (!((InspectionProfileEntry)tool).getShortName().equals(((InspectionEP)this.myEP).getShortName())) {
                LOG.error(new PluginException("Short name not matched for " + String.valueOf(tool.getClass()) + ": getShortName() = #" + ((InspectionProfileEntry)tool).getShortName() + "; ep.shortName = #" + ((InspectionEP)this.myEP).getShortName(), ((BaseKeyedLazyInstance)this.myEP).getPluginDescriptor().getPluginId()));
            }
        }
        T t = tool;
        if (t == null) {
            InspectionToolWrapper.$$$reportNull$$$0(4);
        }
        return t;
    }

    public boolean isInitialized() {
        return this.myTool != null;
    }

    @Nullable
    public String getLanguage() {
        return this.myEP == null ? ((InspectionProfileEntry)this.myTool).getLanguage() : ((InspectionEP)this.myEP).language;
    }

    public boolean applyToDialects() {
        return this.myEP != null && ((InspectionEP)this.myEP).applyToDialects;
    }

    public boolean isApplicable(@NotNull Language language) {
        String myLangId;
        if (language == null) {
            InspectionToolWrapper.$$$reportNull$$$0(5);
        }
        if ((myLangId = this.getLanguage()) == null || myLangId.isBlank() || "any".equals(myLangId)) {
            return true;
        }
        Set<String> languages = this.applicableToLanguages;
        if (languages == null) {
            this.applicableToLanguages = languages = ToolLanguageUtil.getAllMatchingLanguages(myLangId, this.applyToDialects());
        }
        return languages.contains(language.getID());
    }

    public boolean isCleanupTool() {
        return this.myEP != null ? ((InspectionEP)this.myEP).cleanupTool : this.getTool() instanceof CleanupLocalInspectionTool;
    }

    @NotNull
    public String getShortName() {
        String string = this.myEP != null ? ((InspectionEP)this.myEP).getShortName() : ((InspectionProfileEntry)this.getTool()).getShortName();
        if (string == null) {
            InspectionToolWrapper.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public String getDefaultEditorAttributes() {
        return this.myEP == null ? ((InspectionProfileEntry)this.getTool()).getEditorAttributesKey() : ((InspectionEP)this.myEP).editorAttributes;
    }

    @NotNull
    public String getID() {
        String string = this.getShortName();
        if (string == null) {
            InspectionToolWrapper.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getDisplayName() {
        if (this.myEP == null) {
            String string = ((InspectionProfileEntry)this.getTool()).getDisplayName();
            if (string == null) {
                InspectionToolWrapper.$$$reportNull$$$0(8);
            }
            return string;
        }
        String name = ((InspectionEP)this.myEP).getDisplayName();
        String string = name == null ? ((InspectionProfileEntry)this.getTool()).getDisplayName() : name;
        if (string == null) {
            InspectionToolWrapper.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getGroupDisplayName() {
        if (this.myEP == null) {
            String string = ((InspectionProfileEntry)this.getTool()).getGroupDisplayName();
            if (string == null) {
                InspectionToolWrapper.$$$reportNull$$$0(10);
            }
            return string;
        }
        String groupDisplayName = ((InspectionEP)this.myEP).getGroupDisplayName();
        String string = groupDisplayName == null ? ((InspectionProfileEntry)this.getTool()).getGroupDisplayName() : groupDisplayName;
        if (string == null) {
            InspectionToolWrapper.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return this.myEP == null ? ((InspectionProfileEntry)this.getTool()).isEnabledByDefault() : ((InspectionEP)this.myEP).enabledByDefault;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = this.myEP == null ? ((InspectionProfileEntry)this.getTool()).getDefaultLevel() : ((InspectionEP)this.myEP).getDefaultLevel();
        if (highlightDisplayLevel == null) {
            InspectionToolWrapper.$$$reportNull$$$0(12);
        }
        return highlightDisplayLevel;
    }

    public @Nls String @NotNull [] getGroupPath() {
        if (this.myEP == null) {
            String[] stringArray = ((InspectionProfileEntry)this.getTool()).getGroupPath();
            if (stringArray == null) {
                InspectionToolWrapper.$$$reportNull$$$0(13);
            }
            return stringArray;
        }
        String[] path = ((InspectionEP)this.myEP).getGroupPath();
        String[] stringArray = path == null ? ((InspectionProfileEntry)this.getTool()).getGroupPath() : path;
        if (stringArray == null) {
            InspectionToolWrapper.$$$reportNull$$$0(14);
        }
        return stringArray;
    }

    @Nls
    public String getStaticDescription() {
        return this.myEP == null || ((InspectionEP)this.myEP).hasStaticDescription ? ((InspectionProfileEntry)this.getTool()).getStaticDescription() : null;
    }

    @Nls
    public String loadDescription() {
        String description = this.getStaticDescription();
        if (description != null) {
            return description;
        }
        try {
            InputStream descriptionStream = this.getDescriptionStream();
            if (descriptionStream != null) {
                return InspectionToolWrapper.insertAddendum(ResourceUtil.loadText((InputStream)descriptionStream), new HtmlBuilder().append(((InspectionProfileEntry)this.getTool()).getDescriptionAddendum()).append(HtmlChunk.p().child(HtmlChunk.tag("small").addText("Inspection ID: " + this.getShortName()))).toFragment());
            }
            return null;
        }
        catch (IOException iOException) {
            return ((InspectionProfileEntry)this.getTool()).loadDescription();
        }
    }

    private static String insertAddendum(String description, HtmlChunk addendum) {
        Matcher matcher;
        Object addendumString = addendum.toString();
        if (!description.contains("<!-- tooltip end -->")) {
            addendumString = "<!-- tooltip end -->" + (String)addendumString;
        }
        if ((matcher = ADDENDUM_PLACE.matcher(description)).find()) {
            return description.substring(0, matcher.start()) + (String)addendumString + description.substring(matcher.start());
        }
        return description + (String)addendumString;
    }

    @Nullable
    private InputStream getDescriptionStream() {
        String path = "inspectionDescriptions/" + this.getDescriptionFileName();
        ClassLoader classLoader = this.myEP == null ? this.getTool().getClass().getClassLoader() : ((BaseKeyedLazyInstance)this.myEP).getPluginDescriptor().getPluginClassLoader();
        return LocalizationUtil.INSTANCE.getResourceAsStream(classLoader, path, null);
    }

    @NotNull
    private String getDescriptionFileName() {
        String string = this.getShortName() + ".html";
        if (string == null) {
            InspectionToolWrapper.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public final String getFolderName() {
        String string = this.getShortName();
        if (string == null) {
            InspectionToolWrapper.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public final Class<? extends InspectionProfileEntry> getDescriptionContextClass() {
        Class<?> clazz = this.getTool().getClass();
        if (clazz == null) {
            InspectionToolWrapper.$$$reportNull$$$0(17);
        }
        return clazz;
    }

    public String getMainToolId() {
        return ((InspectionProfileEntry)this.getTool()).getMainToolId();
    }

    public final E getExtension() {
        return this.myEP;
    }

    public String toString() {
        return this.getShortName();
    }

    public void cleanup(@NotNull Project project) {
        T tool;
        if (project == null) {
            InspectionToolWrapper.$$$reportNull$$$0(18);
        }
        if ((tool = this.myTool) != null) {
            ((InspectionProfileEntry)tool).cleanup(project);
        }
    }

    public abstract JobDescriptor @NotNull [] getJobDescriptors(@NotNull GlobalInspectionContext var1);

    @Nullable
    public HighlightDisplayKey getDisplayKey() {
        HighlightDisplayKey key = this.myDisplayKey;
        if (key == null) {
            this.myDisplayKey = key = HighlightDisplayKey.find(this.getShortName());
        }
        return key;
    }

    public boolean isApplicable(Set<String> projectTypes) {
        if (this.myEP == null) {
            return true;
        }
        String projectType = ((InspectionEP)this.myEP).projectType;
        if (projectType == null) {
            return true;
        }
        return projectTypes.contains(projectType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ep";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionToolWrapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionToolWrapper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTool";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionFileName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolderName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionContextClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

