/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PlainTextFormatter
implements InspectionsReportConverter {
    public static final String NAME = "plain";
    private static final String FILE_ELEMENT = "file";
    private static final String LINE_ELEMENT = "line";
    private static final String PROBLEM_ELEMENT = "problem";
    private static final String DESCRIPTION_ELEMENT = "description";
    private static final String PROBLEM_CLASS_ELEMENT = "problem_class";
    private static final String SEVERITY_ATTRIBUTE = "severity";

    @Override
    public String getFormatName() {
        return NAME;
    }

    @Override
    public boolean useTmpDirForRawData() {
        return true;
    }

    @Override
    public void convert(@NotNull String rawDataDirectoryPath, @Nullable String outputPath, @NotNull Map<String, Tools> tools, @NotNull List<? extends File> inspectionsResults) throws InspectionsReportConverter.ConversionException {
        Writer w;
        Transformer transformer;
        if (rawDataDirectoryPath == null) {
            PlainTextFormatter.$$$reportNull$$$0(0);
        }
        if (tools == null) {
            PlainTextFormatter.$$$reportNull$$$0(1);
        }
        if (inspectionsResults == null) {
            PlainTextFormatter.$$$reportNull$$$0(2);
        }
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newDefaultInstance();
        try (InputStream descrExtractorXsltStream = this.getClass().getResourceAsStream("description-text.xsl");){
            StreamSource xslSource = new StreamSource(descrExtractorXsltStream);
            transformer = transformerFactory.newTransformer(xslSource);
        }
        catch (IOException e) {
            throw new InspectionsReportConverter.ConversionException("Cannot find inspection descriptions converter.");
        }
        catch (TransformerConfigurationException e) {
            throw new InspectionsReportConverter.ConversionException("Fail to load inspection descriptions converter.");
        }
        if (outputPath != null) {
            File outputFile = new File(outputPath);
            try {
                w = new FileWriter(outputFile);
            }
            catch (IOException iOException) {
                throw new InspectionsReportConverter.ConversionException("Cannot edit file: " + outputFile.getPath());
            }
        } else {
            w = new PrintWriter(System.out);
        }
        try {
            for (File file : inspectionsResults) {
                if (file.isDirectory()) {
                    this.warn("Folder isn't expected here: " + file.getName());
                    continue;
                }
                String fileNameWithoutExt = FileUtilRt.getNameWithoutExtension(file.getName());
                if (".descriptions".equals(fileNameWithoutExt) || fileNameWithoutExt.endsWith("_aggregate")) continue;
                InspectionToolWrapper<?, ?> toolWrapper = tools.get(fileNameWithoutExt).getTool();
                w.append(this.getToolPresentableName(toolWrapper)).append("\n");
                this.writeInspectionDescription(w, toolWrapper, transformer);
                w.append("\n");
                SAXBuilder builder = new SAXBuilder();
                try {
                    Document doc = builder.build(file);
                    Element root = doc.getRootElement();
                    List<Element> problems = root.getChildren(PROBLEM_ELEMENT);
                    int maxFileColonLineLength = this.getMaxFileColonLineNumLength(file, toolWrapper, problems);
                    for (Element problem : problems) {
                        Element fileElement = problem.getChild(FILE_ELEMENT);
                        String filePath = this.getPath(fileElement);
                        if (this.resultsIgnored(file, toolWrapper)) continue;
                        Element lineElement = problem.getChild(LINE_ELEMENT);
                        Element problemDescrElement = problem.getChild(DESCRIPTION_ELEMENT);
                        String severity = problem.getChild(PROBLEM_CLASS_ELEMENT).getAttributeValue(SEVERITY_ATTRIBUTE);
                        String fileLineNum = lineElement.getText();
                        w.append("  ").append(filePath).append(':').append(fileLineNum);
                        for (int i = maxFileColonLineLength - 1 - filePath.length() - fileLineNum.length() + 4; i >= 0; --i) {
                            w.append(' ');
                        }
                        w.append("[").append(severity).append("] ");
                        w.append(problemDescrElement.getText()).append('\n');
                    }
                }
                catch (JDOMException e) {
                    throw new InspectionsReportConverter.ConversionException("Unknown results format, file = " + file.getPath() + ". Error: " + e.getMessage());
                }
                w.append("\n");
            }
        }
        catch (IOException e) {
            throw new InspectionsReportConverter.ConversionException("Cannot write inspection results: " + e.getMessage());
        }
        finally {
            try {
                w.close();
            }
            catch (IOException e) {
                this.warn("Cannot save inspection results: " + e.getMessage());
            }
        }
    }

    private int getMaxFileColonLineNumLength(@NotNull File inspectionResultData, @NotNull InspectionToolWrapper toolWrapper, @NotNull List problems) {
        if (inspectionResultData == null) {
            PlainTextFormatter.$$$reportNull$$$0(3);
        }
        if (toolWrapper == null) {
            PlainTextFormatter.$$$reportNull$$$0(4);
        }
        if (problems == null) {
            PlainTextFormatter.$$$reportNull$$$0(5);
        }
        int maxFileColonLineLength = 0;
        for (Object problem : problems) {
            Element fileElement = ((Element)problem).getChild(FILE_ELEMENT);
            Element lineElement = ((Element)problem).getChild(LINE_ELEMENT);
            String filePath = this.getPath(fileElement);
            if (this.resultsIgnored(inspectionResultData, toolWrapper)) continue;
            maxFileColonLineLength = Math.max(maxFileColonLineLength, filePath.length() + 1 + lineElement.getText().length());
        }
        return maxFileColonLineLength;
    }

    private void warn(String msg) {
        System.err.println(msg);
    }

    private boolean resultsIgnored(@NotNull File file, @NotNull InspectionToolWrapper toolWrapper) {
        if (file == null) {
            PlainTextFormatter.$$$reportNull$$$0(6);
        }
        if (toolWrapper == null) {
            PlainTextFormatter.$$$reportNull$$$0(7);
        }
        return false;
    }

    @NotNull
    private String getPath(@NotNull Element fileElement) {
        if (fileElement == null) {
            PlainTextFormatter.$$$reportNull$$$0(8);
        }
        String string = fileElement.getText().replace("file://$PROJECT_DIR$", ".");
        if (string == null) {
            PlainTextFormatter.$$$reportNull$$$0(9);
        }
        return string;
    }

    private void writeInspectionDescription(@NotNull Writer w, @NotNull InspectionToolWrapper toolWrapper, @NotNull Transformer transformer) throws IOException, InspectionsReportConverter.ConversionException {
        String[] descLines;
        if (w == null) {
            PlainTextFormatter.$$$reportNull$$$0(10);
        }
        if (toolWrapper == null) {
            PlainTextFormatter.$$$reportNull$$$0(11);
        }
        if (transformer == null) {
            PlainTextFormatter.$$$reportNull$$$0(12);
        }
        StringWriter descrWriter = new StringWriter();
        String descr = toolWrapper.loadDescription();
        if (descr == null) {
            return;
        }
        descr = descr.replace("<br>", "<br/>");
        try {
            transformer.transform(new StreamSource(new StringReader(descr)), new StreamResult(descrWriter));
        }
        catch (TransformerException e) {
            this.warn("ERROR:  Cannot load description for inspection: " + this.getToolPresentableName(toolWrapper) + ".\n        Error message: " + e.getMessage());
            return;
        }
        String trimmedDesc = descrWriter.toString().trim();
        for (String descLine : descLines = StringUtil.splitByLines(trimmedDesc)) {
            w.append("  ").append(descLine.trim()).append("\n");
        }
    }

    @NotNull
    private String getToolPresentableName(@NotNull InspectionToolWrapper toolWrapper) throws IOException {
        if (toolWrapper == null) {
            PlainTextFormatter.$$$reportNull$$$0(13);
        }
        StringBuilder buff = new StringBuilder();
        buff.append(toolWrapper.getDisplayName()).append(" (");
        String[] groupPath = toolWrapper.getGroupPath();
        int groupPathLength = groupPath.length;
        for (int i = 0; i < groupPathLength; ++i) {
            if (i != 0) {
                buff.append(" | ");
            }
            buff.append(groupPath[i]);
        }
        buff.append(")");
        String string = buff.toString();
        if (string == null) {
            PlainTextFormatter.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawDataDirectoryPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsResults";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionResultData";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = FILE_ELEMENT;
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileElement";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/PlainTextFormatter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/PlainTextFormatter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMaxFileColonLineNumLength";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resultsIgnored";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 9: 
            case 14: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeInspectionDescription";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getToolPresentableName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 14 -> new IllegalStateException(string);
        };
    }
}

