/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class ToolLanguageUtil {
    private ToolLanguageUtil() {
    }

    @NotNull
    public static @Unmodifiable Set<String> getAllMatchingLanguages(@NotNull String languageId, boolean applyToDialects) {
        Set<String> result;
        Language language;
        if (languageId == null) {
            ToolLanguageUtil.$$$reportNull$$$0(0);
        }
        if ((language = Language.findLanguageByID(languageId)) == null) {
            Set<String> set = Set.of(languageId);
            if (set == null) {
                ToolLanguageUtil.$$$reportNull$$$0(1);
            }
            return set;
        }
        if (language instanceof MetaLanguage) {
            MetaLanguage metaLanguage = (MetaLanguage)language;
            Collection<Language> matchingLanguages = metaLanguage.getMatchingLanguages();
            result = new HashSet<String>();
            for (Language matchingLanguage : matchingLanguages) {
                result.addAll(ToolLanguageUtil.getLanguageWithDialects(matchingLanguage, applyToDialects));
            }
        } else {
            result = ToolLanguageUtil.getLanguageWithDialects(language, applyToDialects);
        }
        Set<String> set = Set.copyOf(result);
        if (set == null) {
            ToolLanguageUtil.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    private static Set<String> getLanguageWithDialects(@NotNull Language language, boolean applyToDialects) {
        if (language == null) {
            ToolLanguageUtil.$$$reportNull$$$0(3);
        }
        List<Language> dialects = language.getDialects();
        if (!applyToDialects || dialects.isEmpty()) {
            Set<String> set = Set.of(language.getID());
            if (set == null) {
                ToolLanguageUtil.$$$reportNull$$$0(4);
            }
            return set;
        }
        Collection<@NotNull Language> transitiveDialects = language.getTransitiveDialects();
        HashSet<String> result = new HashSet<String>(1 + transitiveDialects.size());
        result.add(language.getID());
        for (Language dialect : transitiveDialects) {
            result.add(dialect.getID());
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            ToolLanguageUtil.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static boolean existsDialectOneOf(@NotNull Set<String> elementDialectIds, @NotNull Language language, boolean applyToDialects) {
        if (elementDialectIds == null) {
            ToolLanguageUtil.$$$reportNull$$$0(6);
        }
        if (language == null) {
            ToolLanguageUtil.$$$reportNull$$$0(7);
        }
        if (elementDialectIds.contains(language.getID())) {
            return true;
        }
        if (applyToDialects) {
            for (Language dialect : language.getTransitiveDialects()) {
                if (!elementDialectIds.contains(dialect.getID())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isToolLanguageOneOf(@NotNull Set<String> elementDialectIds, @NotNull String toolLanguageId, boolean applyToDialects) {
        if (elementDialectIds == null) {
            ToolLanguageUtil.$$$reportNull$$$0(8);
        }
        if (toolLanguageId == null) {
            ToolLanguageUtil.$$$reportNull$$$0(9);
        }
        if (elementDialectIds.contains(toolLanguageId)) {
            return true;
        }
        Language language = Language.findLanguageByID(toolLanguageId);
        if (language == null) {
            return false;
        }
        if (language instanceof MetaLanguage) {
            MetaLanguage metaLanguage = (MetaLanguage)language;
            return ContainerUtil.exists(metaLanguage.getMatchingLanguages(), registeredLanguage -> ToolLanguageUtil.existsDialectOneOf(elementDialectIds, registeredLanguage, applyToDialects));
        }
        return ToolLanguageUtil.existsDialectOneOf(elementDialectIds, language, applyToDialects);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageId";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/ToolLanguageUtil";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDialectIds";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolLanguageId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/ToolLanguageUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMatchingLanguages";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageWithDialects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllMatchingLanguages";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageWithDialects";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "existsDialectOneOf";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isToolLanguageOneOf";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

