/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CollectionQuery;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CorePackageIndex
extends PackageIndex {
    private static final Logger LOG = Logger.getInstance(CorePackageIndex.class);
    private final List<VirtualFile> myClasspath = new ArrayList<VirtualFile>();

    private List<VirtualFile> roots() {
        return this.myClasspath;
    }

    private List<VirtualFile> findDirectoriesByPackageName(String packageName) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        String dirName = packageName.replace(".", "/");
        for (VirtualFile root : this.roots()) {
            VirtualFile classDir = root.findFileByRelativePath(dirName);
            if (classDir == null) continue;
            result.add(classDir);
        }
        return result;
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirsByPackageName(@NotNull @NlsSafe String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            CorePackageIndex.$$$reportNull$$$0(0);
        }
        return new CollectionQuery<VirtualFile>(this.findDirectoriesByPackageName(packageName));
    }

    public void addToClasspath(VirtualFile root) {
        this.myClasspath.add(root);
    }

    @Override
    @Nullable
    public String getPackageNameByDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            CorePackageIndex.$$$reportNull$$$0(1);
        }
        for (VirtualFile root : this.roots()) {
            if (!VfsUtilCore.isAncestor(root, dir, false)) continue;
            return VfsUtilCore.getRelativePath(dir, root, '.');
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        objectArray2[1] = "com/intellij/core/CorePackageIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDirsByPackageName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageNameByDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

