/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class LoadingState
extends Enum<LoadingState> {
    public static final /* enum */ LoadingState BOOTSTRAP = new LoadingState("bootstrap");
    public static final /* enum */ LoadingState COMPONENTS_REGISTERED = new LoadingState("app component registered");
    public static final /* enum */ LoadingState CONFIGURATION_STORE_INITIALIZED = new LoadingState("app store initialized");
    public static final /* enum */ LoadingState COMPONENTS_LOADED = new LoadingState("app component loaded");
    public static final /* enum */ LoadingState APP_READY = new LoadingState("app ready");
    public static final /* enum */ LoadingState APP_STARTED = new LoadingState("app started");
    public static final /* enum */ LoadingState PROJECT_OPENED = new LoadingState("project opened");
    private static final AtomicReference<LoadingState> currentState;
    final String displayName;
    public static BiConsumer<String, Throwable> errorHandler;
    private static boolean CHECK_LOADING_PHASE;
    private static Set<ThrowableWrapper> stackTraces;
    private static final /* synthetic */ LoadingState[] $VALUES;

    public static LoadingState[] values() {
        return (LoadingState[])$VALUES.clone();
    }

    public static LoadingState valueOf(String name) {
        return Enum.valueOf(LoadingState.class, name);
    }

    private LoadingState(String displayName) {
        if (displayName == null) {
            LoadingState.$$$reportNull$$$0(0);
        }
        this.displayName = displayName;
    }

    @ApiStatus.Internal
    public static void setStrictMode() {
        CHECK_LOADING_PHASE = true;
    }

    public void checkOccurred() {
        if (!CHECK_LOADING_PHASE) {
            return;
        }
        LoadingState currentState = LoadingState.currentState.get();
        if (currentState.compareTo(this) >= 0 || LoadingState.isKnownViolator()) {
            return;
        }
        this.logStateError(currentState);
    }

    private synchronized void logStateError(@NotNull LoadingState currentState) {
        if (currentState == null) {
            LoadingState.$$$reportNull$$$0(1);
        }
        Throwable t = new Throwable();
        if (stackTraces == null) {
            stackTraces = new HashSet<ThrowableWrapper>();
        }
        if (!stackTraces.add(new ThrowableWrapper(t))) {
            return;
        }
        BiConsumer<String, Throwable> errorHandler = LoadingState.errorHandler;
        if (errorHandler != null) {
            errorHandler.accept("Should be called at least in the state " + (Object)((Object)this) + ", the current state is: " + (Object)((Object)currentState) + "\nCurrent violators count: " + stackTraces.size() + "\n\n", t);
        }
    }

    private static boolean isKnownViolator() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            String className = element.getClassName();
            if (!className.contains("com.intellij.util.indexing.IndexInfrastructure") && !className.contains("com.intellij.psi.impl.search.IndexPatternSearcher") && !className.contains("com.jetbrains.performancePlugin.ProjectLoaded")) continue;
            return true;
        }
        return false;
    }

    public boolean isOccurred() {
        return currentState.get().compareTo(this) >= 0;
    }

    @ApiStatus.Internal
    public static void setCurrentState(@NotNull LoadingState state2) {
        BiConsumer<String, Throwable> errorHandler;
        LoadingState old;
        if (state2 == null) {
            LoadingState.$$$reportNull$$$0(2);
        }
        if ((old = currentState.getAndSet(state2)).compareTo(state2) > 0 && (errorHandler = LoadingState.errorHandler) != null) {
            errorHandler.accept("New state " + (Object)((Object)state2) + " cannot precede old " + (Object)((Object)old), new Throwable());
        }
    }

    @ApiStatus.Internal
    public static void compareAndSetCurrentState(@NotNull LoadingState expectedState, @NotNull LoadingState newState) {
        if (expectedState == null) {
            LoadingState.$$$reportNull$$$0(3);
        }
        if (newState == null) {
            LoadingState.$$$reportNull$$$0(4);
        }
        currentState.compareAndSet(expectedState, newState);
    }

    @ApiStatus.Internal
    public static void setCurrentStateIfAtLeast(@NotNull LoadingState expectedState, @NotNull LoadingState newState) {
        LoadingState current;
        if (expectedState == null) {
            LoadingState.$$$reportNull$$$0(5);
        }
        if (newState == null) {
            LoadingState.$$$reportNull$$$0(6);
        }
        assert (newState.compareTo(expectedState) > 0);
        do {
            if ((current = currentState.get()).compareTo(expectedState) < 0) {
                return;
            }
            if (current.compareTo(newState) < 0) continue;
            return;
        } while (!currentState.compareAndSet(current, newState));
    }

    private static /* synthetic */ LoadingState[] $values() {
        return new LoadingState[]{BOOTSTRAP, COMPONENTS_REGISTERED, CONFIGURATION_STORE_INITIALIZED, COMPONENTS_LOADED, APP_READY, APP_STARTED, PROJECT_OPENED};
    }

    static {
        $VALUES = LoadingState.$values();
        currentState = new AtomicReference<LoadingState>(BOOTSTRAP);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedState";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newState";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/LoadingState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "logStateError";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setCurrentState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "compareAndSetCurrentState";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setCurrentStateIfAtLeast";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ThrowableWrapper {
        final Throwable throwable;

        private ThrowableWrapper(Throwable throwable) {
            this.throwable = throwable;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ThrowableWrapper) {
                Throwable throwable = ((ThrowableWrapper)obj).throwable;
                return this.throwable == throwable || ThrowableWrapper.fingerprint(this.throwable).equals(ThrowableWrapper.fingerprint(throwable));
            }
            return false;
        }

        public int hashCode() {
            return ThrowableWrapper.fingerprint(this.throwable).hashCode();
        }

        private static String fingerprint(Throwable throwable) {
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement traceElement : throwable.getStackTrace()) {
                sb.append(traceElement.getClassName()).append(traceElement.getMethodName());
            }
            return sb.toString();
        }
    }
}

