/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByCharRt;
import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.CharacterUtilsKt;
import com.intellij.diff.comparison.ChunkOptimizer;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.LineFragmentSplitter;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.comparison.iterables.SubiterableDiffIterable;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.DiffFragmentImpl;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.fragments.MergeWordFragmentImpl;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.DiffRangeUtil;
import com.intellij.diff.util.LinesRange;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.util.IntPair;
import com.intellij.util.text.MergingCharSequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0018\b\u00c6\u0002\u0018\u00002\u00020\u0001:\rABCDEFGHIJKLMB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007JJ\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u0010\t\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J6\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00110\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0005H\u0002J>\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J4\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\u0006\u0010 \u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002JD\u0010#\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0002JD\u0010$\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u0010%\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0002JT\u0010$\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010\f\u001a\u00020\rH\u0002J0\u0010)\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002JD\u0010)\u001a\b\u0012\u0004\u0012\u00020+0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020+0\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020+0\u0005H\u0007J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010%\u001a\u00020*H\u0007J4\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0016002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J0\u00103\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u0005002\u0006\u0010%\u001a\u00020\u00162\u0006\u00104\u001a\u00020'H\u0002J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u000fH\u0007J\u0018\u00108\u001a\u0002062\u0006\u00109\u001a\u00020\b2\u0006\u0010:\u001a\u00020'H\u0002J\u0018\u0010;\u001a\u0002062\u0006\u00109\u001a\u00020\b2\u0006\u0010:\u001a\u00020'H\u0002J\u0018\u0010<\u001a\u0002062\u0006\u00109\u001a\u00020\b2\u0006\u0010=\u001a\u00020'H\u0002J\u0016\u0010>\u001a\u00020'2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005H\u0002J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u00109\u001a\u00020\bH\u0007\u00a8\u0006N"}, d2={"Lcom/intellij/diff/comparison/ByWordRt;", "", "<init>", "()V", "compare", "", "Lcom/intellij/diff/fragments/DiffFragment;", "text1", "", "text2", "policy", "Lcom/intellij/diff/comparison/ComparisonPolicy;", "indicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "words1", "Lcom/intellij/diff/comparison/ByWordRt$InlineChunk;", "words2", "Lcom/intellij/diff/fragments/MergeWordFragment;", "text3", "compareAndSplit", "Lcom/intellij/diff/comparison/ByWordRt$LineBlock;", "collectWordBlockSubIterables", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "wordChanges", "wordBlocks", "Lcom/intellij/diff/comparison/LineFragmentSplitter$WordBlock;", "compareWordsFirst", "Lcom/intellij/diff/comparison/ByWordRt$WordLineBlock;", "lineOffsets1", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "lineOffsets2", "collectLineBlockSubIterables", "iterable", "lineBlocks", "Lcom/intellij/diff/util/Range;", "optimizeWordChunks", "matchAdjustmentDelimiters", "changes", "startShift1", "", "startShift2", "matchAdjustmentWhitespaces", "Lcom/intellij/diff/comparison/iterables/DiffIterable;", "Lcom/intellij/diff/util/MergeRange;", "conflicts", "convertIntoMergeWordFragments", "convertIntoDiffFragments", "comparePunctuation2Side", "Lkotlin/Pair;", "text21", "text22", "splitIterable2Side", "offset", "isWordChunk", "", "chunk", "isLeadingTrailingSpace", "text", "start", "isLeadingSpace", "isTrailingSpace", "end", "countNewlines", "words", "getInlineChunks", "LineUplifter", "AdjustmentPunctuationMatcher", "DefaultCorrector", "MergeDefaultCorrector", "IgnoreSpacesCorrector", "MergeIgnoreSpacesCorrector", "TrimSpacesCorrector", "MergeTrimSpacesCorrector", "InlineChunk", "WordChunk", "NewlineChunk", "LineBlock", "WordLineBlock", "intellij.platform.util.diff"})
@SourceDebugExtension(value={"SMAP\nByWordRt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByWordRt.kt\ncom/intellij/diff/comparison/ByWordRt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1105:1\n808#2,11:1106\n808#2,11:1117\n1563#2:1128\n1634#2,3:1129\n*S KotlinDebug\n*F\n+ 1 ByWordRt.kt\ncom/intellij/diff/comparison/ByWordRt\n*L\n183#1:1106,11\n184#1:1117,11\n489#1:1128\n489#1:1129,3\n*E\n"})
public final class ByWordRt {
    @NotNull
    public static final ByWordRt INSTANCE = new ByWordRt();

    private ByWordRt() {
    }

    @JvmStatic
    @NotNull
    public static final List<DiffFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        List<InlineChunk> words1 = ByWordRt.getInlineChunks(text1);
        List<InlineChunk> words2 = ByWordRt.getInlineChunks(text2);
        return ByWordRt.compare(text1, words1, text2, words2, policy, indicator);
    }

    @JvmStatic
    @NotNull
    public static final List<DiffFragment> compare(@NotNull CharSequence text1, @NotNull List<? extends InlineChunk> words1, @NotNull CharSequence text2, @NotNull List<? extends InlineChunk> words2, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter(words1, (String)"words1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter(words2, (String)"words2");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        FairDiffIterable wordChanges = DiffIterableUtil.diff(words1, words2, indicator);
        wordChanges = INSTANCE.optimizeWordChunks(text1, text2, words1, words2, wordChanges, indicator);
        FairDiffIterable delimitersIterable = INSTANCE.matchAdjustmentDelimiters(text1, text2, words1, words2, wordChanges, indicator);
        DiffIterable iterable = INSTANCE.matchAdjustmentWhitespaces(text1, text2, delimitersIterable, policy, indicator);
        return ByWordRt.convertIntoDiffFragments(iterable);
    }

    @JvmStatic
    @NotNull
    public static final List<MergeWordFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)text3, (String)"text3");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        List<InlineChunk> words1 = ByWordRt.getInlineChunks(text1);
        List<InlineChunk> words2 = ByWordRt.getInlineChunks(text2);
        List<InlineChunk> words3 = ByWordRt.getInlineChunks(text3);
        FairDiffIterable wordChanges1 = DiffIterableUtil.diff(words2, words1, indicator);
        wordChanges1 = INSTANCE.optimizeWordChunks(text2, text1, words2, words1, wordChanges1, indicator);
        FairDiffIterable iterable1 = INSTANCE.matchAdjustmentDelimiters(text2, text1, words2, words1, wordChanges1, indicator);
        FairDiffIterable wordChanges2 = DiffIterableUtil.diff(words2, words3, indicator);
        wordChanges2 = INSTANCE.optimizeWordChunks(text2, text3, words2, words3, wordChanges2, indicator);
        FairDiffIterable iterable2 = INSTANCE.matchAdjustmentDelimiters(text2, text3, words2, words3, wordChanges2, indicator);
        List<MergeRange> wordConflicts = ComparisonMergeUtil.buildSimple(iterable1, iterable2, indicator);
        List<MergeRange> result = INSTANCE.matchAdjustmentWhitespaces(text1, text2, text3, wordConflicts, policy, indicator);
        return ByWordRt.convertIntoMergeWordFragments(result);
    }

    @JvmStatic
    @NotNull
    public static final List<LineBlock> compareAndSplit(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        List<InlineChunk> words1 = ByWordRt.getInlineChunks(text1);
        List<InlineChunk> words2 = ByWordRt.getInlineChunks(text2);
        FairDiffIterable wordChanges = DiffIterableUtil.diff(words1, words2, indicator);
        wordChanges = INSTANCE.optimizeWordChunks(text1, text2, words1, words2, wordChanges, indicator);
        List<LineFragmentSplitter.WordBlock> wordBlocks = new LineFragmentSplitter(text1, text2, words1, words2, wordChanges, indicator).run();
        List<FairDiffIterable> subIterables = INSTANCE.collectWordBlockSubIterables(wordChanges, wordBlocks);
        ArrayList<LineBlock> lineBlocks = new ArrayList<LineBlock>(wordBlocks.size());
        int n = ((Collection)wordBlocks).size();
        for (int i = 0; i < n; ++i) {
            LineFragmentSplitter.WordBlock block = wordBlocks.get(i);
            Range offsets = block.getOffsets();
            Range words = block.getWords();
            CharSequence subtext1 = text1.subSequence(offsets.start1, offsets.end1);
            CharSequence subtext2 = text2.subSequence(offsets.start2, offsets.end2);
            List<InlineChunk> subwords1 = words1.subList(words.start1, words.end1);
            List<InlineChunk> subwords2 = words2.subList(words.start2, words.end2);
            FairDiffIterable subiterable = subIterables.get(i);
            FairDiffIterable delimitersIterable = INSTANCE.matchAdjustmentDelimiters(subtext1, subtext2, subwords1, subwords2, subiterable, offsets.start1, offsets.start2, indicator);
            DiffIterable iterable = INSTANCE.matchAdjustmentWhitespaces(subtext1, subtext2, delimitersIterable, policy, indicator);
            List<DiffFragment> fragments = ByWordRt.convertIntoDiffFragments(iterable);
            int newlines1 = INSTANCE.countNewlines(subwords1);
            int newlines2 = INSTANCE.countNewlines(subwords2);
            lineBlocks.add(new LineBlock(fragments, offsets, newlines1, newlines2));
        }
        return lineBlocks;
    }

    private final List<FairDiffIterable> collectWordBlockSubIterables(FairDiffIterable wordChanges, List<LineFragmentSplitter.WordBlock> wordBlocks) {
        ArrayList<Range> changed = new ArrayList<Range>();
        for (Range range : wordChanges.iterateChanges()) {
            changed.add(range);
        }
        int index = 0;
        ArrayList<FairDiffIterable> subIterables = new ArrayList<FairDiffIterable>(wordBlocks.size());
        for (LineFragmentSplitter.WordBlock block : wordBlocks) {
            Range words = block.getWords();
            while (index < changed.size()) {
                Object e = changed.get(index);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                Range range = (Range)e;
                if (range.end1 >= words.start1 && range.end2 >= words.start2) break;
                ++index;
            }
            subIterables.add(DiffIterableUtil.fair(new SubiterableDiffIterable((List<Range>)changed, words.start1, words.end1, words.start2, words.end2, index)));
        }
        return subIterables;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final List<WordLineBlock> compareWordsFirst(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull ComparisonPolicy policy, @NotNull CancellationChecker indicator) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)lineOffsets1, (String)"lineOffsets1");
        Intrinsics.checkNotNullParameter((Object)lineOffsets2, (String)"lineOffsets2");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Iterable $this$filterIsInstance$iv = ByWordRt.getInlineChunks(text1);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof WordChunk)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List words1 = (List)destination$iv$iv;
        Iterable $this$filterIsInstance$iv2 = ByWordRt.getInlineChunks(text2);
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof WordChunk)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List words2 = (List)destination$iv$iv2;
        FairDiffIterable wordChanges = DiffIterableUtil.diff(words1, words2, indicator);
        wordChanges = INSTANCE.optimizeWordChunks(text1, text2, words1, words2, wordChanges, indicator);
        FairDiffIterable delimitersIterable = INSTANCE.matchAdjustmentDelimiters(text1, text2, words1, words2, wordChanges, indicator);
        List<Range> lineBlocks = new LineUplifter(text1, text2, lineOffsets1, lineOffsets2, delimitersIterable, indicator).build();
        List<FairDiffIterable> subIterables = INSTANCE.collectLineBlockSubIterables(delimitersIterable, lineBlocks, lineOffsets1, lineOffsets2);
        List result = new ArrayList();
        int n = ((Collection)lineBlocks).size();
        for (int i = 0; i < n; ++i) {
            Range lineBlock = lineBlocks.get(i);
            FairDiffIterable subIterable = subIterables.get(i);
            LinesRange subRange1 = DiffRangeUtil.getLinesRange(lineOffsets1, lineBlock.start1, lineBlock.end1, true);
            LinesRange subRange2 = DiffRangeUtil.getLinesRange(lineOffsets2, lineBlock.start2, lineBlock.end2, true);
            CharSequence subtext1 = text1.subSequence(subRange1.getStartOffset(), subRange1.getEndOffset());
            CharSequence subtext2 = text2.subSequence(subRange2.getStartOffset(), subRange2.getEndOffset());
            DiffIterable iterable2 = INSTANCE.matchAdjustmentWhitespaces(subtext1, subtext2, subIterable, policy, indicator);
            List<DiffFragment> innerFragments = ByWordRt.convertIntoDiffFragments(iterable2);
            if (innerFragments.isEmpty()) continue;
            Range shiftedLineBlock = new Range(lineBlock.start1, lineBlock.end1, lineBlock.start2, lineBlock.end2);
            ((Collection)result).add(new WordLineBlock(shiftedLineBlock, innerFragments));
        }
        return result;
    }

    private final List<FairDiffIterable> collectLineBlockSubIterables(FairDiffIterable iterable, List<Range> lineBlocks, LineOffsets lineOffsets1, LineOffsets lineOffsets2) {
        ArrayList<Range> changed = new ArrayList<Range>();
        for (Range range : iterable.iterateChanges()) {
            changed.add(range);
        }
        int index = 0;
        ArrayList<FairDiffIterable> subIterables = new ArrayList<FairDiffIterable>(lineBlocks.size());
        for (Range lineBlock : lineBlocks) {
            LinesRange subRange1 = DiffRangeUtil.getLinesRange(lineOffsets1, lineBlock.start1, lineBlock.end1, true);
            LinesRange subRange2 = DiffRangeUtil.getLinesRange(lineOffsets2, lineBlock.start2, lineBlock.end2, true);
            while (index < changed.size()) {
                Object e = changed.get(index);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                Range range = (Range)e;
                if (range.end1 >= subRange1.getStartOffset() && range.end2 >= subRange2.getStartOffset()) break;
                ++index;
            }
            subIterables.add(DiffIterableUtil.fair(new SubiterableDiffIterable((List<Range>)changed, subRange1.getStartOffset(), subRange1.getEndOffset(), subRange2.getStartOffset(), subRange2.getEndOffset(), index)));
        }
        return subIterables;
    }

    private final FairDiffIterable optimizeWordChunks(CharSequence text1, CharSequence text2, List<? extends InlineChunk> words1, List<? extends InlineChunk> words2, FairDiffIterable iterable, CancellationChecker indicator) {
        return new ChunkOptimizer.WordChunkOptimizer(words1, words2, text1, text2, iterable, indicator).build();
    }

    private final FairDiffIterable matchAdjustmentDelimiters(CharSequence text1, CharSequence text2, List<? extends InlineChunk> words1, List<? extends InlineChunk> words2, FairDiffIterable changes, CancellationChecker indicator) {
        return this.matchAdjustmentDelimiters(text1, text2, words1, words2, changes, 0, 0, indicator);
    }

    private final FairDiffIterable matchAdjustmentDelimiters(CharSequence text1, CharSequence text2, List<? extends InlineChunk> words1, List<? extends InlineChunk> words2, FairDiffIterable changes, int startShift1, int startShift2, CancellationChecker indicator) {
        return new AdjustmentPunctuationMatcher(text1, text2, words1, words2, startShift1, startShift2, changes, indicator).build();
    }

    private final DiffIterable matchAdjustmentWhitespaces(CharSequence text1, CharSequence text2, FairDiffIterable iterable, ComparisonPolicy policy, CancellationChecker indicator) {
        switch (WhenMappings.$EnumSwitchMapping$0[policy.ordinal()]) {
            case 1: {
                return new DefaultCorrector(iterable, text1, text2, indicator).build();
            }
            case 2: {
                DiffIterable defaultIterable = new DefaultCorrector(iterable, text1, text2, indicator).build();
                return new TrimSpacesCorrector(defaultIterable, text1, text2, indicator).build();
            }
            case 3: {
                return new IgnoreSpacesCorrector(iterable, text1, text2, indicator).build();
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final List<MergeRange> matchAdjustmentWhitespaces(CharSequence text1, CharSequence text2, CharSequence text3, List<? extends MergeRange> conflicts, ComparisonPolicy policy, CancellationChecker indicator) {
        switch (WhenMappings.$EnumSwitchMapping$0[policy.ordinal()]) {
            case 1: {
                return new MergeDefaultCorrector(conflicts, text1, text2, text3, indicator).build();
            }
            case 2: {
                List<MergeRange> defaultConflicts = new MergeDefaultCorrector(conflicts, text1, text2, text3, indicator).build();
                return new MergeTrimSpacesCorrector(defaultConflicts, text1, text2, text3, indicator).build();
            }
            case 3: {
                return new MergeIgnoreSpacesCorrector(conflicts, text1, text2, text3, indicator).build();
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<MergeWordFragment> convertIntoMergeWordFragments(@NotNull List<? extends MergeRange> conflicts) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        Iterable $this$map$iv = conflicts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MergeRange mergeRange = (MergeRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new MergeWordFragmentImpl((MergeRange)it));
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final List<DiffFragment> convertIntoDiffFragments(@NotNull DiffIterable changes) {
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        ArrayList<DiffFragmentImpl> fragments = new ArrayList<DiffFragmentImpl>();
        for (Range ch : changes.iterateChanges()) {
            fragments.add(new DiffFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2));
        }
        return fragments;
    }

    private final Pair<FairDiffIterable, FairDiffIterable> comparePunctuation2Side(CharSequence text1, CharSequence text21, CharSequence text22, CancellationChecker indicator) {
        CharSequence text2 = new MergingCharSequence(text21, text22);
        FairDiffIterable changes = ByCharRt.comparePunctuation(text1, text2, indicator);
        Pair<List<Range>, List<Range>> ranges = this.splitIterable2Side(changes, text21.length());
        FairDiffIterable iterable1 = DiffIterableUtil.fair(DiffIterableUtil.createUnchanged((List)ranges.getFirst(), text1.length(), text21.length()));
        FairDiffIterable iterable2 = DiffIterableUtil.fair(DiffIterableUtil.createUnchanged((List)ranges.getSecond(), text1.length(), text22.length()));
        return new Pair((Object)iterable1, (Object)iterable2);
    }

    private final Pair<List<Range>, List<Range>> splitIterable2Side(FairDiffIterable changes, int offset) {
        ArrayList<Range> ranges1 = new ArrayList<Range>();
        ArrayList<Range> ranges2 = new ArrayList<Range>();
        for (Range ch : changes.iterateUnchanged()) {
            boolean bl;
            if (ch.end2 <= offset) {
                bl = ranges1.add(new Range(ch.start1, ch.end1, ch.start2, ch.end2));
                continue;
            }
            if (ch.start2 >= offset) {
                bl = ranges2.add(new Range(ch.start1, ch.end1, ch.start2 - offset, ch.end2 - offset));
                continue;
            }
            int len2 = offset - ch.start2;
            ranges1.add(new Range(ch.start1, ch.start1 + len2, ch.start2, offset));
            bl = ranges2.add(new Range(ch.start1 + len2, ch.end1, 0, ch.end2 - offset));
        }
        return new Pair(ranges1, ranges2);
    }

    @JvmStatic
    public static final boolean isWordChunk(@NotNull InlineChunk chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        return chunk instanceof WordChunk;
    }

    private final boolean isLeadingTrailingSpace(CharSequence text, int start) {
        return this.isLeadingSpace(text, start) || this.isTrailingSpace(text, start);
    }

    private final boolean isLeadingSpace(CharSequence text, int start) {
        int start2 = start;
        if (start2 < 0) {
            return false;
        }
        if (start2 == text.length()) {
            return false;
        }
        if (!TrimUtil.isSpaceEnterOrTab(text.charAt(start2))) {
            return false;
        }
        --start2;
        while (start2 >= 0) {
            char c = text.charAt(start2);
            if (c == '\n') {
                return true;
            }
            if (!TrimUtil.isSpaceEnterOrTab(c)) {
                return false;
            }
            --start2;
        }
        return true;
    }

    private final boolean isTrailingSpace(CharSequence text, int end) {
        int end2 = end;
        if (end2 < 0) {
            return false;
        }
        if (end2 == text.length()) {
            return false;
        }
        if (!TrimUtil.isSpaceEnterOrTab(text.charAt(end2))) {
            return false;
        }
        while (end2 < text.length()) {
            char c = text.charAt(end2);
            if (c == '\n') {
                return true;
            }
            if (!TrimUtil.isSpaceEnterOrTab(c)) {
                return false;
            }
            ++end2;
        }
        return true;
    }

    private final int countNewlines(List<? extends InlineChunk> words) {
        int count2 = 0;
        for (InlineChunk inlineChunk : words) {
            if (!(inlineChunk instanceof NewlineChunk)) continue;
            ++count2;
        }
        return count2;
    }

    @JvmStatic
    @NotNull
    public static final List<InlineChunk> getInlineChunks(@NotNull CharSequence text) {
        int charCount;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ArrayList<InlineChunk> chunks = new ArrayList<InlineChunk>();
        int len = text.length();
        int wordStart = -1;
        int wordHash = 0;
        for (int offset = 0; offset < len; offset += charCount) {
            boolean isWordPart;
            int ch = CharacterUtilsKt.codePointAt(text, offset);
            charCount = CharacterUtilsKt.charCount(ch);
            boolean isAlpha = TrimUtil.isAlpha(ch);
            boolean bl = isWordPart = isAlpha && !TrimUtil.isContinuousScript(ch);
            if (isWordPart) {
                if (wordStart == -1) {
                    wordStart = offset;
                    wordHash = 0;
                }
                wordHash = wordHash * 31 + ch;
                continue;
            }
            if (wordStart != -1) {
                chunks.add(new WordChunk(text, wordStart, offset, wordHash));
                wordStart = -1;
            }
            if (isAlpha) {
                chunks.add(new WordChunk(text, offset, offset + charCount, ch));
                continue;
            }
            if (ch != 10) continue;
            chunks.add(new NewlineChunk(offset));
        }
        if (wordStart != -1) {
            chunks.add(new WordChunk(text, wordStart, len, wordHash));
        }
        return chunks;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u001b\b\u0002\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010\u0016\u001a\u00020\rJ\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020&J\u0016\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\nJ\u0016\u0010+\u001a\u00020&2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\nJ&\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\nJ&\u0010(\u001a\u00020&2\u0006\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\nJ&\u00100\u001a\u00020&2\u0006\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\nJF\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\n2\u0006\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\n2\u0006\u00108\u001a\u00020\n2\u0006\u00109\u001a\u00020\nJ6\u0010:\u001a\u00020&2\u0006\u0010,\u001a\u00020\n2\u0006\u0010.\u001a\u00020\n2\u0006\u00103\u001a\u00020\n2\u0006\u00105\u001a\u00020\n2\u0006\u00107\u001a\u00020\n2\u0006\u00109\u001a\u00020\nJ6\u0010;\u001a\u00020&2\u0006\u0010-\u001a\u00020\n2\u0006\u0010/\u001a\u00020\n2\u0006\u00102\u001a\u00020\n2\u0006\u00104\u001a\u00020\n2\u0006\u00106\u001a\u00020\n2\u0006\u00108\u001a\u00020\nJ\u000e\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020\nJ\u000e\u0010>\u001a\u00020\n2\u0006\u0010=\u001a\u00020\nJ\u000e\u0010?\u001a\u00020\n2\u0006\u0010=\u001a\u00020\nJ\u000e\u0010@\u001a\u00020\n2\u0006\u0010=\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001bR\u001a\u0010\"\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0019\"\u0004\b$\u0010\u001b\u00a8\u0006A"}, d2={"Lcom/intellij/diff/comparison/ByWordRt$AdjustmentPunctuationMatcher;", "", "text1", "", "text2", "words1", "", "Lcom/intellij/diff/comparison/ByWordRt$InlineChunk;", "words2", "startShift1", "", "startShift2", "changes", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "indicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "<init>", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;Ljava/util/List;Ljava/util/List;IILcom/intellij/diff/comparison/iterables/FairDiffIterable;Lcom/intellij/diff/comparison/CancellationChecker;)V", "len1", "len2", "builder", "Lcom/intellij/diff/comparison/iterables/DiffIterableUtil$ChangeBuilder;", "build", "lastStart1", "getLastStart1", "()I", "setLastStart1", "(I)V", "lastStart2", "getLastStart2", "setLastStart2", "lastEnd1", "getLastEnd1", "setLastEnd1", "lastEnd2", "getLastEnd2", "setLastEnd2", "execute", "", "clearLastRange", "matchBackward", "index1", "index2", "matchForward", "start1", "start2", "end1", "end2", "matchRange", "matchComplexRange", "start11", "start12", "end11", "end12", "start21", "start22", "end21", "end22", "matchComplexRangeLeft", "matchComplexRangeRight", "getStartOffset1", "index", "getStartOffset2", "getEndOffset1", "getEndOffset2", "intellij.platform.util.diff"})
    private static final class AdjustmentPunctuationMatcher {
        @NotNull
        private final CharSequence text1;
        @NotNull
        private final CharSequence text2;
        @NotNull
        private final List<InlineChunk> words1;
        @NotNull
        private final List<InlineChunk> words2;
        private final int startShift1;
        private final int startShift2;
        @NotNull
        private final FairDiffIterable changes;
        @NotNull
        private final CancellationChecker indicator;
        private final int len1;
        private final int len2;
        @NotNull
        private final DiffIterableUtil.ChangeBuilder builder;
        private int lastStart1;
        private int lastStart2;
        private int lastEnd1;
        private int lastEnd2;

        public AdjustmentPunctuationMatcher(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<? extends InlineChunk> words1, @NotNull List<? extends InlineChunk> words2, int startShift1, int startShift2, @NotNull FairDiffIterable changes, @NotNull CancellationChecker indicator) {
            Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
            Intrinsics.checkNotNullParameter(words1, (String)"words1");
            Intrinsics.checkNotNullParameter(words2, (String)"words2");
            Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            this.text1 = text1;
            this.text2 = text2;
            this.words1 = words1;
            this.words2 = words2;
            this.startShift1 = startShift1;
            this.startShift2 = startShift2;
            this.changes = changes;
            this.indicator = indicator;
            this.len1 = this.text1.length();
            this.len2 = this.text2.length();
            this.builder = new DiffIterableUtil.ChangeBuilder(this.len1, this.len2);
        }

        @NotNull
        public final FairDiffIterable build() {
            this.execute();
            return DiffIterableUtil.fair(this.builder.finish());
        }

        public final int getLastStart1() {
            return this.lastStart1;
        }

        public final void setLastStart1(int n) {
            this.lastStart1 = n;
        }

        public final int getLastStart2() {
            return this.lastStart2;
        }

        public final void setLastStart2(int n) {
            this.lastStart2 = n;
        }

        public final int getLastEnd1() {
            return this.lastEnd1;
        }

        public final void setLastEnd1(int n) {
            this.lastEnd1 = n;
        }

        public final int getLastEnd2() {
            return this.lastEnd2;
        }

        public final void setLastEnd2(int n) {
            this.lastEnd2 = n;
        }

        public final void execute() {
            this.clearLastRange();
            this.matchForward(-1, -1);
            for (Range ch : this.changes.iterateUnchanged()) {
                int count2 = ch.end1 - ch.start1;
                for (int i = 0; i < count2; ++i) {
                    int index1 = ch.start1 + i;
                    int index2 = ch.start2 + i;
                    int start1 = this.getStartOffset1(index1);
                    int start2 = this.getStartOffset2(index2);
                    int end1 = this.getEndOffset1(index1);
                    int end2 = this.getEndOffset2(index2);
                    this.matchBackward(index1, index2);
                    this.builder.markEqual(start1, start2, end1, end2);
                    this.matchForward(index1, index2);
                }
            }
            this.matchBackward(this.words1.size(), this.words2.size());
        }

        public final void clearLastRange() {
            this.lastStart1 = -1;
            this.lastStart2 = -1;
            this.lastEnd1 = -1;
            this.lastEnd2 = -1;
        }

        public final void matchBackward(int index1, int index2) {
            int start1 = index1 == 0 ? 0 : this.getEndOffset1(index1 - 1);
            int start2 = index2 == 0 ? 0 : this.getEndOffset2(index2 - 1);
            int end1 = index1 == this.words1.size() ? this.len1 : this.getStartOffset1(index1);
            int end2 = index2 == this.words2.size() ? this.len2 : this.getStartOffset2(index2);
            this.matchBackward(start1, start2, end1, end2);
            this.clearLastRange();
        }

        public final void matchForward(int index1, int index2) {
            int start1 = index1 == -1 ? 0 : this.getEndOffset1(index1);
            int start2 = index2 == -1 ? 0 : this.getEndOffset2(index2);
            int end1 = index1 + 1 == this.words1.size() ? this.len1 : this.getStartOffset1(index1 + 1);
            int end2 = index2 + 1 == this.words2.size() ? this.len2 : this.getStartOffset2(index2 + 1);
            this.matchForward(start1, start2, end1, end2);
        }

        public final void matchForward(int start1, int start2, int end1, int end2) {
            if (!(this.lastStart1 == -1 && this.lastStart2 == -1 && this.lastEnd1 == -1 && this.lastEnd2 == -1)) {
                throw new IllegalStateException("Check failed.");
            }
            this.lastStart1 = start1;
            this.lastStart2 = start2;
            this.lastEnd1 = end1;
            this.lastEnd2 = end2;
        }

        public final void matchBackward(int start1, int start2, int end1, int end2) {
            if (!(this.lastStart1 != -1 && this.lastStart2 != -1 && this.lastEnd1 != -1 && this.lastEnd2 != -1)) {
                throw new IllegalStateException("Check failed.");
            }
            if (this.lastStart1 == start1 && this.lastStart2 == start2) {
                if (!(this.lastEnd1 == end1 && this.lastEnd2 == end2)) {
                    throw new IllegalStateException("Check failed.");
                }
                this.matchRange(start1, start2, end1, end2);
                return;
            }
            if (this.lastStart1 < start1 && this.lastStart2 < start2) {
                if (!(this.lastEnd1 <= start1 && this.lastEnd2 <= start2)) {
                    throw new IllegalStateException("Check failed.");
                }
                this.matchRange(this.lastStart1, this.lastStart2, this.lastEnd1, this.lastEnd2);
                this.matchRange(start1, start2, end1, end2);
                return;
            }
            this.matchComplexRange(this.lastStart1, this.lastStart2, this.lastEnd1, this.lastEnd2, start1, start2, end1, end2);
        }

        public final void matchRange(int start1, int start2, int end1, int end2) {
            if (start1 == end1 && start2 == end2) {
                return;
            }
            CharSequence sequence1 = this.text1.subSequence(start1, end1);
            CharSequence sequence2 = this.text2.subSequence(start2, end2);
            DiffIterable changes = ByCharRt.comparePunctuation(sequence1, sequence2, this.indicator);
            for (Range ch : changes.iterateUnchanged()) {
                this.builder.markEqual(start1 + ch.start1, start2 + ch.start2, start1 + ch.end1, start2 + ch.end2);
            }
        }

        public final void matchComplexRange(int start11, int start12, int end11, int end12, int start21, int start22, int end21, int end22) {
            if (start11 == start21 && end11 == end21) {
                this.matchComplexRangeLeft(start11, end11, start12, end12, start22, end22);
            } else if (start12 == start22 && end12 == end22) {
                this.matchComplexRangeRight(start12, end12, start11, end11, start21, end21);
            } else {
                throw new IllegalStateException();
            }
        }

        public final void matchComplexRangeLeft(int start1, int end1, int start12, int end12, int start22, int end22) {
            CharSequence sequence1 = this.text1.subSequence(start1, end1);
            CharSequence sequence21 = this.text2.subSequence(start12, end12);
            CharSequence sequence22 = this.text2.subSequence(start22, end22);
            Pair changes = INSTANCE.comparePunctuation2Side(sequence1, sequence21, sequence22, this.indicator);
            for (Range ch : ((FairDiffIterable)changes.getFirst()).iterateUnchanged()) {
                this.builder.markEqual(start1 + ch.start1, start12 + ch.start2, start1 + ch.end1, start12 + ch.end2);
            }
            for (Range ch : ((FairDiffIterable)changes.getSecond()).iterateUnchanged()) {
                this.builder.markEqual(start1 + ch.start1, start22 + ch.start2, start1 + ch.end1, start22 + ch.end2);
            }
        }

        public final void matchComplexRangeRight(int start2, int end2, int start11, int end11, int start21, int end21) {
            CharSequence sequence11 = this.text1.subSequence(start11, end11);
            CharSequence sequence12 = this.text1.subSequence(start21, end21);
            CharSequence sequence2 = this.text2.subSequence(start2, end2);
            Pair changes = INSTANCE.comparePunctuation2Side(sequence2, sequence11, sequence12, this.indicator);
            for (Range ch : ((FairDiffIterable)changes.getFirst()).iterateUnchanged()) {
                this.builder.markEqual(start11 + ch.start2, start2 + ch.start1, start11 + ch.end2, start2 + ch.end1);
            }
            for (Range ch : ((FairDiffIterable)changes.getSecond()).iterateUnchanged()) {
                this.builder.markEqual(start21 + ch.start2, start2 + ch.start1, start21 + ch.end2, start2 + ch.end1);
            }
        }

        public final int getStartOffset1(int index) {
            return this.words1.get(index).getOffset1() - this.startShift1;
        }

        public final int getStartOffset2(int index) {
            return this.words2.get(index).getOffset1() - this.startShift2;
        }

        public final int getEndOffset1(int index) {
            return this.words1.get(index).getOffset2() - this.startShift1;
        }

        public final int getEndOffset2(int index) {
            return this.words2.get(index).getOffset2() - this.startShift2;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/diff/comparison/ByWordRt$DefaultCorrector;", "", "iterable", "Lcom/intellij/diff/comparison/iterables/DiffIterable;", "text1", "", "text2", "indicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "<init>", "(Lcom/intellij/diff/comparison/iterables/DiffIterable;Ljava/lang/CharSequence;Ljava/lang/CharSequence;Lcom/intellij/diff/comparison/CancellationChecker;)V", "changes", "Ljava/util/ArrayList;", "Lcom/intellij/diff/util/Range;", "Lkotlin/collections/ArrayList;", "build", "intellij.platform.util.diff"})
    private static final class DefaultCorrector {
        @NotNull
        private final DiffIterable iterable;
        @NotNull
        private final CharSequence text1;
        @NotNull
        private final CharSequence text2;
        @NotNull
        private final CancellationChecker indicator;
        @NotNull
        private final ArrayList<Range> changes;

        public DefaultCorrector(@NotNull DiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CancellationChecker indicator) {
            Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
            Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            this.iterable = iterable;
            this.text1 = text1;
            this.text2 = text2;
            this.indicator = indicator;
            this.changes = new ArrayList();
        }

        @NotNull
        public final DiffIterable build() {
            for (Range range : this.iterable.iterateChanges()) {
                int endCut = TrimUtil.expandWhitespacesBackward(this.text1, this.text2, range.start1, range.start2, range.end1, range.end2);
                int startCut = TrimUtil.expandWhitespacesForward(this.text1, this.text2, range.start1, range.start2, range.end1 - endCut, range.end2 - endCut);
                Range expand = new Range(range.start1 + startCut, range.end1 - endCut, range.start2 + startCut, range.end2 - endCut);
                if (expand.isEmpty()) continue;
                this.changes.add(expand);
            }
            return DiffIterableUtil.create((List<? extends Range>)this.changes, this.text1.length(), this.text2.length());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/diff/comparison/ByWordRt$IgnoreSpacesCorrector;", "", "iterable", "Lcom/intellij/diff/comparison/iterables/DiffIterable;", "text1", "", "text2", "indicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "<init>", "(Lcom/intellij/diff/comparison/iterables/DiffIterable;Ljava/lang/CharSequence;Ljava/lang/CharSequence;Lcom/intellij/diff/comparison/CancellationChecker;)V", "changes", "Ljava/util/ArrayList;", "Lcom/intellij/diff/util/Range;", "Lkotlin/collections/ArrayList;", "build", "intellij.platform.util.diff"})
    private static final class IgnoreSpacesCorrector {
        @NotNull
        private final DiffIterable iterable;
        @NotNull
        private final CharSequence text1;
        @NotNull
        private final CharSequence text2;
        @NotNull
        private final CancellationChecker indicator;
        @NotNull
        private final ArrayList<Range> changes;

        public IgnoreSpacesCorrector(@NotNull DiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CancellationChecker indicator) {
            Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
            Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            this.iterable = iterable;
            this.text1 = text1;
            this.text2 = text2;
            this.indicator = indicator;
            this.changes = new ArrayList();
        }

        @NotNull
        public final DiffIterable build() {
            for (Range range : this.iterable.iterateChanges()) {
                Range expanded = TrimUtil.expandWhitespaces(this.text1, this.text2, range);
                Range trimmed = TrimUtil.trim(this.text1, this.text2, expanded);
                if (trimmed.isEmpty() || TrimUtil.isEqualsIgnoreWhitespaces(this.text1, this.text2, trimmed)) continue;
                this.changes.add(trimmed);
            }
            return DiffIterableUtil.create((List<? extends Range>)this.changes, this.text1.length(), this.text2.length());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/diff/comparison/ByWordRt$InlineChunk;", "", "offset1", "", "getOffset1", "()I", "offset2", "getOffset2", "intellij.platform.util.diff"})
    public static interface InlineChunk {
        public int getOffset1();

        public int getOffset2();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/diff/comparison/ByWordRt$LineBlock;", "", "fragments", "", "Lcom/intellij/diff/fragments/DiffFragment;", "offsets", "Lcom/intellij/diff/util/Range;", "newlines1", "", "newlines2", "<init>", "(Ljava/util/List;Lcom/intellij/diff/util/Range;II)V", "intellij.platform.util.diff"})
    public static final class LineBlock {
        @JvmField
        @NotNull
        public final List<DiffFragment> fragments;
        @JvmField
        @NotNull
        public final Range offsets;
        @JvmField
        public final int newlines1;
        @JvmField
        public final int newlines2;

        public LineBlock(@NotNull List<? extends DiffFragment> fragments, @NotNull Range offsets, int newlines1, int newlines2) {
            Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
            Intrinsics.checkNotNullParameter((Object)offsets, (String)"offsets");
            this.fragments = fragments;
            this.offsets = offsets;
            this.newlines1 = newlines1;
            this.newlines2 = newlines2;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ*\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0014H\u0002J(\u0010&\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0014H\u0002J\u0018\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0014H\u0002J\u0018\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018\u00a8\u0006."}, d2={"Lcom/intellij/diff/comparison/ByWordRt$LineUplifter;", "", "text1", "", "text2", "lineOffsets1", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "lineOffsets2", "changes", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "indicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "<init>", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;Lcom/intellij/diff/tools/util/text/LineOffsets;Lcom/intellij/diff/tools/util/text/LineOffsets;Lcom/intellij/diff/comparison/iterables/FairDiffIterable;Lcom/intellij/diff/comparison/CancellationChecker;)V", "lineBlocks", "", "Lcom/intellij/diff/util/Range;", "getLineBlocks", "()Ljava/util/List;", "blockStart1", "", "getBlockStart1", "()I", "setBlockStart1", "(I)V", "blockStart2", "getBlockStart2", "setBlockStart2", "build", "", "execute", "", "walkForward", "Lcom/intellij/util/IntPair;", "start1", "start2", "end1", "end2", "walkBackward", "markNextBlockOffset", "blockEndOffset1", "blockEndOffset2", "markNextBlock", "blockEnd1", "blockEnd2", "Companion", "intellij.platform.util.diff"})
    private static final class LineUplifter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final CharSequence text1;
        @NotNull
        private final CharSequence text2;
        @NotNull
        private final LineOffsets lineOffsets1;
        @NotNull
        private final LineOffsets lineOffsets2;
        @NotNull
        private final FairDiffIterable changes;
        @NotNull
        private final CancellationChecker indicator;
        @NotNull
        private final List<Range> lineBlocks;
        private int blockStart1;
        private int blockStart2;

        public LineUplifter(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull FairDiffIterable changes, @NotNull CancellationChecker indicator) {
            Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
            Intrinsics.checkNotNullParameter((Object)lineOffsets1, (String)"lineOffsets1");
            Intrinsics.checkNotNullParameter((Object)lineOffsets2, (String)"lineOffsets2");
            Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            this.text1 = text1;
            this.text2 = text2;
            this.lineOffsets1 = lineOffsets1;
            this.lineOffsets2 = lineOffsets2;
            this.changes = changes;
            this.indicator = indicator;
            this.lineBlocks = new ArrayList();
        }

        @NotNull
        public final List<Range> getLineBlocks() {
            return this.lineBlocks;
        }

        public final int getBlockStart1() {
            return this.blockStart1;
        }

        public final void setBlockStart1(int n) {
            this.blockStart1 = n;
        }

        public final int getBlockStart2() {
            return this.blockStart2;
        }

        public final void setBlockStart2(int n) {
            this.blockStart2 = n;
        }

        @NotNull
        public final List<Range> build() {
            this.execute();
            return this.lineBlocks;
        }

        public final void execute() {
            int lastIndex1 = 0;
            int lastIndex2 = 0;
            for (Range range : this.changes.iterateUnchanged()) {
                IntPair pair = this.walkForward(lastIndex1, lastIndex2, range.start1, range.start2);
                if (pair != null) {
                    this.walkBackward(pair.first, pair.second, range.start1, range.start2);
                } else {
                    this.walkBackward(lastIndex1, lastIndex2, range.start1, range.start2);
                }
                lastIndex1 = range.end1;
                lastIndex2 = range.end2;
            }
            IntPair pair = this.walkForward(lastIndex1, lastIndex2, this.text1.length(), this.text2.length());
            if (pair != null) {
                this.walkBackward(pair.first, pair.second, this.text1.length(), this.text2.length());
            } else {
                this.walkBackward(lastIndex1, lastIndex2, this.text1.length(), this.text2.length());
            }
            this.markNextBlock(this.lineOffsets1.getLineCount(), this.lineOffsets2.getLineCount());
        }

        private final IntPair walkForward(int start1, int start2, int end1, int end2) {
            IntPair intPair = LineUplifter.Companion.walkSideForward(this.text1, start1, end1);
            if (intPair == null) {
                return null;
            }
            IntPair found1 = intPair;
            IntPair intPair2 = LineUplifter.Companion.walkSideForward(this.text2, start2, end2);
            if (intPair2 == null) {
                return null;
            }
            IntPair found2 = intPair2;
            this.markNextBlockOffset(found1.first, found2.first);
            this.markNextBlockOffset(found1.second, found2.second);
            return new IntPair(found1.second, found2.second);
        }

        private final void walkBackward(int start1, int start2, int end1, int end2) {
            IntPair intPair = LineUplifter.Companion.walkSideBackward(this.text1, start1, end1);
            if (intPair == null) {
                return;
            }
            IntPair found1 = intPair;
            IntPair intPair2 = LineUplifter.Companion.walkSideBackward(this.text2, start2, end2);
            if (intPair2 == null) {
                return;
            }
            IntPair found2 = intPair2;
            this.markNextBlockOffset(found1.second, found2.second);
            this.markNextBlockOffset(found1.first, found2.first);
        }

        private final void markNextBlockOffset(int blockEndOffset1, int blockEndOffset2) {
            int blockEnd1 = this.lineOffsets1.getLineNumber(blockEndOffset1) + 1;
            int blockEnd2 = this.lineOffsets2.getLineNumber(blockEndOffset2) + 1;
            this.markNextBlock(blockEnd1, blockEnd2);
        }

        private final void markNextBlock(int blockEnd1, int blockEnd2) {
            if (this.blockStart1 == blockEnd1 && this.blockStart2 == blockEnd2) {
                return;
            }
            ((Collection)this.lineBlocks).add(new Range(this.blockStart1, blockEnd1, this.blockStart2, blockEnd2));
            this.blockStart1 = blockEnd1;
            this.blockStart2 = blockEnd2;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\"\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/diff/comparison/ByWordRt$LineUplifter$Companion;", "", "<init>", "()V", "walkSideForward", "Lcom/intellij/util/IntPair;", "text", "", "start", "", "end", "walkSideBackward", "intellij.platform.util.diff"})
        public static final class Companion {
            private Companion() {
            }

            private final IntPair walkSideForward(CharSequence text, int start, int end) {
                Integer foundFirst = null;
                Integer foundLast = null;
                int index = start;
                while (true) {
                    char ch;
                    if (index < end && (ch = text.charAt(index)) != '\n') {
                        if (!TrimUtil.isSpaceEnterOrTab(ch)) break;
                        ++index;
                        continue;
                    }
                    if (index == end) break;
                    if (foundFirst == null) {
                        foundFirst = index;
                    }
                    foundLast = index;
                    ++index;
                }
                if (foundFirst == null || foundLast == null) {
                    return null;
                }
                return new IntPair(foundFirst, foundLast);
            }

            private final IntPair walkSideBackward(CharSequence text, int start, int end) {
                Integer foundFirst = null;
                Integer foundLast = null;
                int index = end - 1;
                while (true) {
                    char ch;
                    if (start <= index && (ch = text.charAt(index)) != '\n') {
                        if (!TrimUtil.isSpaceEnterOrTab(ch)) break;
                        --index;
                        continue;
                    }
                    if (index < start) break;
                    if (foundFirst == null) {
                        foundFirst = index;
                    }
                    foundLast = index;
                    --index;
                }
                if (foundFirst == null || foundLast == null) {
                    return null;
                }
                return new IntPair(foundFirst, foundLast);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u000ej\b\u0012\u0004\u0012\u00020\u0004`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/diff/comparison/ByWordRt$MergeDefaultCorrector;", "", "iterable", "", "Lcom/intellij/diff/util/MergeRange;", "text1", "", "text2", "text3", "indicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "<init>", "(Ljava/util/List;Ljava/lang/CharSequence;Ljava/lang/CharSequence;Ljava/lang/CharSequence;Lcom/intellij/diff/comparison/CancellationChecker;)V", "changes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "build", "intellij.platform.util.diff"})
    private static final class MergeDefaultCorrector {
        @NotNull
        private final List<MergeRange> iterable;
        @NotNull
        private final CharSequence text1;
        @NotNull
        private final CharSequence text2;
        @NotNull
        private final CharSequence text3;
        @NotNull
        private final CancellationChecker indicator;
        @NotNull
        private final ArrayList<MergeRange> changes;

        public MergeDefaultCorrector(@NotNull List<? extends MergeRange> iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull CancellationChecker indicator) {
            Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
            Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
            Intrinsics.checkNotNullParameter((Object)text3, (String)"text3");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            this.iterable = iterable;
            this.text1 = text1;
            this.text2 = text2;
            this.text3 = text3;
            this.indicator = indicator;
            this.changes = new ArrayList();
        }

        @NotNull
        public final List<MergeRange> build() {
            for (MergeRange range : this.iterable) {
                int endCut = TrimUtil.expandWhitespacesBackward(this.text1, this.text2, this.text3, range.start1, range.start2, range.start3, range.end1, range.end2, range.end3);
                int startCut = TrimUtil.expandWhitespacesForward(this.text1, this.text2, this.text3, range.start1, range.start2, range.start3, range.end1 - endCut, range.end2 - endCut, range.end3 - endCut);
                MergeRange expand = new MergeRange(range.start1 + startCut, range.end1 - endCut, range.start2 + startCut, range.end2 - endCut, range.start3 + startCut, range.end3 - endCut);
                if (expand.isEmpty()) continue;
                this.changes.add(expand);
            }
            return this.changes;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u000ej\b\u0012\u0004\u0012\u00020\u0004`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/diff/comparison/ByWordRt$MergeIgnoreSpacesCorrector;", "", "iterable", "", "Lcom/intellij/diff/util/MergeRange;", "text1", "", "text2", "text3", "indicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "<init>", "(Ljava/util/List;Ljava/lang/CharSequence;Ljava/lang/CharSequence;Ljava/lang/CharSequence;Lcom/intellij/diff/comparison/CancellationChecker;)V", "changes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "build", "intellij.platform.util.diff"})
    private static final class MergeIgnoreSpacesCorrector {
        @NotNull
        private final List<MergeRange> iterable;
        @NotNull
        private final CharSequence text1;
        @NotNull
        private final CharSequence text2;
        @NotNull
        private final CharSequence text3;
        @NotNull
        private final CancellationChecker indicator;
        @NotNull
        private final ArrayList<MergeRange> changes;

        public MergeIgnoreSpacesCorrector(@NotNull List<? extends MergeRange> iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull CancellationChecker indicator) {
            Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
            Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
            Intrinsics.checkNotNullParameter((Object)text3, (String)"text3");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            this.iterable = iterable;
            this.text1 = text1;
            this.text2 = text2;
            this.text3 = text3;
            this.indicator = indicator;
            this.changes = new ArrayList();
        }

        @NotNull
        public final List<MergeRange> build() {
            for (MergeRange range : this.iterable) {
                MergeRange expanded = TrimUtil.expandWhitespaces(this.text1, this.text2, this.text3, range);
                MergeRange trimmed = TrimUtil.trim(this.text1, this.text2, this.text3, expanded);
                if (trimmed.isEmpty() || TrimUtil.isEqualsIgnoreWhitespaces(this.text1, this.text2, this.text3, trimmed)) continue;
                this.changes.add(trimmed);
            }
            return this.changes;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u000ej\b\u0012\u0004\u0012\u00020\u0004`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/diff/comparison/ByWordRt$MergeTrimSpacesCorrector;", "", "iterable", "", "Lcom/intellij/diff/util/MergeRange;", "text1", "", "text2", "text3", "indicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "<init>", "(Ljava/util/List;Ljava/lang/CharSequence;Ljava/lang/CharSequence;Ljava/lang/CharSequence;Lcom/intellij/diff/comparison/CancellationChecker;)V", "changes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "build", "intellij.platform.util.diff"})
    private static final class MergeTrimSpacesCorrector {
        @NotNull
        private final List<MergeRange> iterable;
        @NotNull
        private final CharSequence text1;
        @NotNull
        private final CharSequence text2;
        @NotNull
        private final CharSequence text3;
        @NotNull
        private final CancellationChecker indicator;
        @NotNull
        private final ArrayList<MergeRange> changes;

        public MergeTrimSpacesCorrector(@NotNull List<? extends MergeRange> iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull CancellationChecker indicator) {
            Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
            Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
            Intrinsics.checkNotNullParameter((Object)text3, (String)"text3");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            this.iterable = iterable;
            this.text1 = text1;
            this.text2 = text2;
            this.text3 = text3;
            this.indicator = indicator;
            this.changes = new ArrayList();
        }

        @NotNull
        public final List<MergeRange> build() {
            for (MergeRange range : this.iterable) {
                MergeRange trimmed;
                int start1 = range.start1;
                int start2 = range.start2;
                int start3 = range.start3;
                int end1 = range.end1;
                int end2 = range.end2;
                int end3 = range.end3;
                if (INSTANCE.isLeadingTrailingSpace(this.text1, start1)) {
                    start1 = TrimUtil.trimStart(this.text1, start1, end1);
                }
                if (INSTANCE.isLeadingTrailingSpace(this.text1, end1 - 1)) {
                    end1 = TrimUtil.trimEnd(this.text1, start1, end1);
                }
                if (INSTANCE.isLeadingTrailingSpace(this.text2, start2)) {
                    start2 = TrimUtil.trimStart(this.text2, start2, end2);
                }
                if (INSTANCE.isLeadingTrailingSpace(this.text2, end2 - 1)) {
                    end2 = TrimUtil.trimEnd(this.text2, start2, end2);
                }
                if (INSTANCE.isLeadingTrailingSpace(this.text3, start3)) {
                    start3 = TrimUtil.trimStart(this.text3, start3, end3);
                }
                if (INSTANCE.isLeadingTrailingSpace(this.text3, end3 - 1)) {
                    end3 = TrimUtil.trimEnd(this.text3, start3, end3);
                }
                if ((trimmed = new MergeRange(start1, end1, start2, end2, start3, end3)).isEmpty() || TrimUtil.isEquals(this.text1, this.text2, this.text3, trimmed)) continue;
                this.changes.add(trimmed);
            }
            return this.changes;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/diff/comparison/ByWordRt$NewlineChunk;", "Lcom/intellij/diff/comparison/ByWordRt$InlineChunk;", "offset1", "", "<init>", "(I)V", "getOffset1", "()I", "offset2", "getOffset2", "equals", "", "other", "", "hashCode", "intellij.platform.util.diff"})
    public static final class NewlineChunk
    implements InlineChunk {
        private final int offset1;

        public NewlineChunk(int offset1) {
            this.offset1 = offset1;
        }

        @Override
        public int getOffset1() {
            return this.offset1;
        }

        @Override
        public int getOffset2() {
            return this.getOffset1() + 1;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other != null && this.getClass() == other.getClass();
        }

        public int hashCode() {
            return Reflection.getOrCreateKotlinClass(this.getClass()).hashCode();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/diff/comparison/ByWordRt$TrimSpacesCorrector;", "", "iterable", "Lcom/intellij/diff/comparison/iterables/DiffIterable;", "text1", "", "text2", "indicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "<init>", "(Lcom/intellij/diff/comparison/iterables/DiffIterable;Ljava/lang/CharSequence;Ljava/lang/CharSequence;Lcom/intellij/diff/comparison/CancellationChecker;)V", "changes", "Ljava/util/ArrayList;", "Lcom/intellij/diff/util/Range;", "Lkotlin/collections/ArrayList;", "build", "intellij.platform.util.diff"})
    public static final class TrimSpacesCorrector {
        @NotNull
        private final DiffIterable iterable;
        @NotNull
        private final CharSequence text1;
        @NotNull
        private final CharSequence text2;
        @NotNull
        private final CancellationChecker indicator;
        @NotNull
        private final ArrayList<Range> changes;

        public TrimSpacesCorrector(@NotNull DiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CancellationChecker indicator) {
            Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
            Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            this.iterable = iterable;
            this.text1 = text1;
            this.text2 = text2;
            this.indicator = indicator;
            this.changes = new ArrayList();
        }

        @NotNull
        public final DiffIterable build() {
            for (Range range : this.iterable.iterateChanges()) {
                Range trimmed;
                int start1 = range.start1;
                int start2 = range.start2;
                int end1 = range.end1;
                int end2 = range.end2;
                if (INSTANCE.isLeadingTrailingSpace(this.text1, start1)) {
                    start1 = TrimUtil.trimStart(this.text1, start1, end1);
                }
                if (INSTANCE.isLeadingTrailingSpace(this.text1, end1 - 1)) {
                    end1 = TrimUtil.trimEnd(this.text1, start1, end1);
                }
                if (INSTANCE.isLeadingTrailingSpace(this.text2, start2)) {
                    start2 = TrimUtil.trimStart(this.text2, start2, end2);
                }
                if (INSTANCE.isLeadingTrailingSpace(this.text2, end2 - 1)) {
                    end2 = TrimUtil.trimEnd(this.text2, start2, end2);
                }
                if ((trimmed = new Range(start1, end1, start2, end2)).isEmpty() || TrimUtil.isEquals(this.text1, this.text2, trimmed)) continue;
                this.changes.add(trimmed);
            }
            return DiffIterableUtil.create((List<? extends Range>)this.changes, this.text1.length(), this.text2.length());
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComparisonPolicy.values().length];
            try {
                nArray[ComparisonPolicy.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparisonPolicy.TRIM_WHITESPACES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparisonPolicy.IGNORE_WHITESPACES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/intellij/diff/comparison/ByWordRt$WordChunk;", "Lcom/intellij/diff/comparison/ByWordRt$InlineChunk;", "text", "", "offset1", "", "offset2", "hash", "<init>", "(Ljava/lang/CharSequence;III)V", "getOffset1", "()I", "getOffset2", "content", "getContent", "()Ljava/lang/CharSequence;", "equals", "", "other", "", "hashCode", "intellij.platform.util.diff"})
    public static final class WordChunk
    implements InlineChunk {
        @NotNull
        private final CharSequence text;
        private final int offset1;
        private final int offset2;
        private final int hash;

        public WordChunk(@NotNull CharSequence text, int offset1, int offset2, int hash) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = text;
            this.offset1 = offset1;
            this.offset2 = offset2;
            this.hash = hash;
        }

        @Override
        public int getOffset1() {
            return this.offset1;
        }

        @Override
        public int getOffset2() {
            return this.offset2;
        }

        @NotNull
        public final CharSequence getContent() {
            return this.text.subSequence(this.getOffset1(), this.getOffset2());
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            WordChunk word = (WordChunk)other;
            if (this.hash != word.hash) {
                return false;
            }
            return ComparisonUtil.isEquals(this.getContent(), word.getContent(), ComparisonPolicy.DEFAULT);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/diff/comparison/ByWordRt$WordLineBlock;", "", "lineRange", "Lcom/intellij/diff/util/Range;", "fragments", "", "Lcom/intellij/diff/fragments/DiffFragment;", "<init>", "(Lcom/intellij/diff/util/Range;Ljava/util/List;)V", "intellij.platform.util.diff"})
    @ApiStatus.Experimental
    public static final class WordLineBlock {
        @JvmField
        @NotNull
        public final Range lineRange;
        @JvmField
        @NotNull
        public final List<DiffFragment> fragments;

        public WordLineBlock(@NotNull Range lineRange, @NotNull List<? extends DiffFragment> fragments) {
            Intrinsics.checkNotNullParameter((Object)lineRange, (String)"lineRange");
            Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
            this.lineRange = lineRange;
            this.fragments = fragments;
        }
    }
}

