/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.iterables.ChangeDiffIterableBase;
import com.intellij.diff.util.Range;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\fB%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/diff/comparison/iterables/RangesDiffIterable;", "Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase;", "myRanges", "", "Lcom/intellij/diff/util/Range;", "length1", "", "length2", "<init>", "(Ljava/util/Collection;II)V", "createChangeIterable", "Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase$ChangeIterable;", "RangesChangeIterable", "intellij.platform.util.diff"})
public final class RangesDiffIterable
extends ChangeDiffIterableBase {
    @NotNull
    private final Collection<Range> myRanges;

    public RangesDiffIterable(@NotNull Collection<Range> myRanges, int length1, int length2) {
        Intrinsics.checkNotNullParameter(myRanges, (String)"myRanges");
        super(length1, length2);
        this.myRanges = myRanges;
    }

    @Override
    @NotNull
    protected ChangeDiffIterableBase.ChangeIterable createChangeIterable() {
        return new RangesChangeIterable(this.myRanges);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/intellij/diff/comparison/iterables/RangesDiffIterable$RangesChangeIterable;", "Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase$ChangeIterable;", "ranges", "", "Lcom/intellij/diff/util/Range;", "<init>", "(Ljava/util/Collection;)V", "myIterator", "", "myLast", "valid", "", "next", "", "start1", "", "getStart1", "()I", "start2", "getStart2", "end1", "getEnd1", "end2", "getEnd2", "intellij.platform.util.diff"})
    private static final class RangesChangeIterable
    implements ChangeDiffIterableBase.ChangeIterable {
        @NotNull
        private final Iterator<Range> myIterator;
        @Nullable
        private Range myLast;

        public RangesChangeIterable(@NotNull Collection<Range> ranges) {
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            this.myIterator = ranges.iterator();
            this.next();
        }

        @Override
        public boolean valid() {
            return this.myLast != null;
        }

        @Override
        public void next() {
            this.myLast = this.myIterator.hasNext() ? this.myIterator.next() : null;
        }

        @Override
        public int getStart1() {
            Range range = this.myLast;
            Intrinsics.checkNotNull((Object)range);
            return range.start1;
        }

        @Override
        public int getStart2() {
            Range range = this.myLast;
            Intrinsics.checkNotNull((Object)range);
            return range.start2;
        }

        @Override
        public int getEnd1() {
            Range range = this.myLast;
            Intrinsics.checkNotNull((Object)range);
            return range.end1;
        }

        @Override
        public int getEnd2() {
            Range range = this.myLast;
            Intrinsics.checkNotNull((Object)range);
            return range.end2;
        }
    }
}

