/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u001a\u0014\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eH\u0007\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u001a\u001a\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bH\u0000\u001a\"\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bH\u0007\u001a.\u0010\u0019\u001a\u00020\u00172\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0007\u001a\b\u0010\u001a\u001a\u00020\u0017H\u0007\u001a\u001a\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bH\u0002\u001a$\u0010\u001c\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0018\u00010\u000b2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002\"\u001a\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\"(\u0010\t\u001a\u001c\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$annotations", "()V", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getUpdatedBrokenPluginFile", "Ljava/nio/file/Path;", "configDir", "brokenPluginVersions", "Ljava/lang/ref/Reference;", "", "Lcom/intellij/openapi/extensions/PluginId;", "", "", "isBrokenPlugin", "", "pluginId", "version", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getBrokenPluginVersions", "updateBrokenPlugins", "", "brokenPlugins", "writeBrokenPlugins", "dropInMemoryBrokenPluginsCache", "readBrokenPluginFile", "tryReadBrokenPluginsFile", "brokenPluginsStorage", "intellij.platform.core.impl"})
@SourceDebugExtension(value={"SMAP\nbrokenPluginFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 brokenPluginFile.kt\ncom/intellij/ide/plugins/BrokenPluginFileKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,158:1\n61#2,5:159\n61#2,5:164\n61#2,5:169\n61#2,5:174\n62#2,4:179\n61#2,5:183\n61#2,5:188\n61#2,5:193\n62#2,4:198\n*S KotlinDebug\n*F\n+ 1 brokenPluginFile.kt\ncom/intellij/ide/plugins/BrokenPluginFileKt\n*L\n44#1:159,5\n52#1:164,5\n60#1:169,5\n66#1:174,5\n84#1:179,4\n108#1:183,5\n122#1:188,5\n147#1:193,5\n152#1:198,4\n*E\n"})
public final class BrokenPluginFileKt {
    @Nullable
    private static Reference<Map<PluginId, Set<String>>> brokenPluginVersions;

    private static final Logger getLOG() {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static /* synthetic */ void getLOG$annotations() {
    }

    @NotNull
    public static final Path getUpdatedBrokenPluginFile(@Nullable Path configDir) {
        Path path = configDir;
        if (path == null) {
            path = PathManager.getConfigDir();
        }
        Path path2 = path.resolve("updatedBrokenPlugins.db");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    public static /* synthetic */ Path getUpdatedBrokenPluginFile$default(Path path, int n, Object object) {
        if ((n & 1) != 0) {
            path = null;
        }
        return BrokenPluginFileKt.getUpdatedBrokenPluginFile(path);
    }

    @ApiStatus.Internal
    public static final boolean isBrokenPlugin(@NotNull PluginId pluginId, @Nullable String version) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Set<String> set = BrokenPluginFileKt.getBrokenPluginVersions().get(pluginId);
        return set != null && CollectionsKt.contains((Iterable)set, (Object)version);
    }

    @ApiStatus.Internal
    public static final boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PluginId pluginId = descriptor.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
        return BrokenPluginFileKt.isBrokenPlugin(pluginId, descriptor.getVersion());
    }

    @NotNull
    public static final Map<PluginId, Set<String>> getBrokenPluginVersions() {
        if (PluginEnabler.HEADLESS.isIgnoredDisabledPlugins()) {
            Logger $this$debug_u24default$iv = BrokenPluginFileKt.getLOG();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Broken plugins will not be loaded because 'Ignore disabled plugins' flag is set", e$iv);
            }
            return MapsKt.emptyMap();
        }
        Map<PluginId, Set<String>> result = null;
        Reference<Map<PluginId, Set<String>>> reference = brokenPluginVersions;
        Map<PluginId, Set<String>> map2 = result = reference != null ? reference.get() : null;
        if (result == null) {
            result = BrokenPluginFileKt.readBrokenPluginFile();
            brokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(result);
            Logger $this$debug_u24default$iv = BrokenPluginFileKt.getLOG();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Broken plugins is loaded, state size=" + result.size(), e$iv);
            }
        }
        return result;
    }

    @ApiStatus.Internal
    public static final void updateBrokenPlugins(@NotNull Map<PluginId, ? extends Set<String>> brokenPlugins) {
        Intrinsics.checkNotNullParameter(brokenPlugins, (String)"brokenPlugins");
        brokenPluginVersions = new SoftReference<Map<PluginId, ? extends Set<String>>>(brokenPlugins);
        Logger $this$debug_u24default$iv = BrokenPluginFileKt.getLOG();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Broken plugins state is updated, state size=" + brokenPlugins.size(), e$iv);
        }
        BrokenPluginFileKt.writeBrokenPlugins$default(brokenPlugins, null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static final void writeBrokenPlugins(@NotNull Map<PluginId, ? extends Set<String>> brokenPlugins, @Nullable Path configDir) {
        Logger logger;
        Intrinsics.checkNotNullParameter(brokenPlugins, (String)"brokenPlugins");
        Logger $this$debug_u24default$iv = BrokenPluginFileKt.getLOG();
        Closeable e$iv = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Rewriting cached broken plugins, new state size=" + brokenPlugins.size(), (Throwable)((Object)e$iv));
        }
        Path updatedBrokenPluginFile = BrokenPluginFileKt.getUpdatedBrokenPluginFile(configDir);
        try {
            e$iv = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(updatedBrokenPluginFile, new OpenOption[0]), 32000));
            Throwable $i$f$debug2 = null;
            try {
                DataOutputStream out = (DataOutputStream)e$iv;
                boolean bl = false;
                out.write(2);
                out.writeUTF(PluginManagerCore.getBuildNumber().asString());
                out.writeInt(brokenPlugins.size());
                for (Map.Entry<PluginId, ? extends Set<String>> entry : brokenPlugins.entrySet()) {
                    PluginId key = entry.getKey();
                    Set<String> value = entry.getValue();
                    out.writeUTF(key.getIdString());
                    out.writeShort(value.size());
                    for (String s : value) {
                        out.writeUTF(s);
                    }
                }
                out = Unit.INSTANCE;
            }
            catch (Throwable bl) {
                $i$f$debug2 = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)e$iv, (Throwable)$i$f$debug2);
            }
            BrokenPluginFileKt.getLOG().debug("Cached broken plugins file is rewritten successfully");
        }
        catch (NoSuchFileException e) {
            void $this$debug$iv;
            Logger $i$f$debug2 = BrokenPluginFileKt.getLOG();
            Exception e$iv2 = e;
            boolean $i$f$debug3 = false;
            if ($this$debug$iv.isDebugEnabled()) {
                logger = $this$debug$iv;
                boolean bl = false;
                logger.debug("Failed to update broken plugins file, because it doesn't exist: " + updatedBrokenPluginFile, e$iv2);
            }
        }
        catch (Exception e) {
            BrokenPluginFileKt.getLOG().error("Failed to write " + updatedBrokenPluginFile, e);
        }
    }

    public static /* synthetic */ void writeBrokenPlugins$default(Map map2, Path path, int n, Object object) {
        if ((n & 2) != 0) {
            path = null;
        }
        BrokenPluginFileKt.writeBrokenPlugins(map2, path);
    }

    @ApiStatus.Internal
    public static final void dropInMemoryBrokenPluginsCache() {
        if (brokenPluginVersions != null) {
            BrokenPluginFileKt.getLOG().info("Broken plugins will be reloaded from disk");
        }
        brokenPluginVersions = null;
    }

    private static final Map<PluginId, Set<String>> readBrokenPluginFile() {
        Map<PluginId, Set<String>> map2;
        Map<PluginId, Set<String>> result = null;
        Path updatedBrokenPluginFile = BrokenPluginFileKt.getUpdatedBrokenPluginFile$default(null, 1, null);
        if (Files.exists(updatedBrokenPluginFile, new LinkOption[0])) {
            result = BrokenPluginFileKt.tryReadBrokenPluginsFile(updatedBrokenPluginFile);
            if (result != null) {
                BrokenPluginFileKt.getLOG().info("Using cached broken plugins file");
            }
        } else {
            Logger $this$debug_u24default$iv = BrokenPluginFileKt.getLOG();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Cached broken plugins file doesn't exist: " + updatedBrokenPluginFile, e$iv);
            }
        }
        if (result == null) {
            String[] stringArray = new String[]{"brokenPlugins.db"};
            Path path = Paths.get(PathManager.getBinPath(), stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            result = BrokenPluginFileKt.tryReadBrokenPluginsFile(path);
            if (result != null) {
                BrokenPluginFileKt.getLOG().info("Using broken plugins file from IDE distribution");
            } else {
                BrokenPluginFileKt.getLOG().debug("Broken plugins file from the IDE distribution was not loaded");
            }
        }
        if ((map2 = result) == null) {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Map<PluginId, Set<String>> tryReadBrokenPluginsFile(Path brokenPluginsStorage) {
        Logger logger;
        Object $this$debug_u24default$iv = BrokenPluginFileKt.getLOG();
        Object e$iv = null;
        boolean $i$f$debug = false;
        if (((Logger)$this$debug_u24default$iv).isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Reading broken plugins file: " + brokenPluginsStorage, (Throwable)e$iv);
        }
        try {
            $this$debug_u24default$iv = new DataInputStream(new BufferedInputStream(Files.newInputStream(brokenPluginsStorage, new OpenOption[0]), 32000));
            e$iv = null;
            try {
                Object object;
                DataInputStream stream = (DataInputStream)$this$debug_u24default$iv;
                boolean bl = false;
                int version = stream.readUnsignedByte();
                if (version != 2) {
                    BrokenPluginFileKt.getLOG().info("Unsupported version of " + brokenPluginsStorage + "(fileVersion=" + version + ", supportedVersion=2)");
                    Map<PluginId, Set<String>> map2 = null;
                    return map2;
                }
                String buildNumber = stream.readUTF();
                if (!Intrinsics.areEqual((Object)buildNumber, (Object)PluginManagerCore.getBuildNumber().toString())) {
                    BrokenPluginFileKt.getLOG().info("Ignoring cached broken plugins file from an earlier IDE build (" + buildNumber + ')');
                    Map<PluginId, Set<String>> map3 = null;
                    return map3;
                }
                int count2 = stream.readInt();
                HashMap result = new HashMap(count2);
                for (int i = 0; i < count2; ++i) {
                    HashSet hashSet;
                    String string = stream.readUTF();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUTF(...)");
                    PluginId pluginId = PluginId.Companion.getId(string);
                    HashSet hashSet2 = hashSet = new HashSet();
                    PluginId pluginId2 = pluginId;
                    object = result;
                    boolean bl2 = false;
                    int n = stream.readUnsignedShort();
                    int n2 = 0;
                    while (n2 < n) {
                        void r;
                        int it = n2++;
                        boolean bl3 = false;
                        r.add(stream.readUTF());
                    }
                    Unit unit = Unit.INSTANCE;
                    ((HashMap)object).put(pluginId2, hashSet);
                }
                Logger $this$debug_u24default$iv2 = BrokenPluginFileKt.getLOG();
                Throwable e$iv2 = null;
                boolean $i$f$debug2 = false;
                if ($this$debug_u24default$iv2.isDebugEnabled()) {
                    object = $this$debug_u24default$iv2;
                    boolean bl4 = false;
                    ((Logger)object).debug("Broken plugins file at " + brokenPluginsStorage + " was read, state size=" + result.size() + ", buildNumber=" + buildNumber, e$iv2);
                }
                Map map4 = result;
                return map4;
            }
            catch (Throwable throwable) {
                e$iv = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$this$debug_u24default$iv, (Throwable)e$iv);
            }
        }
        catch (NoSuchFileException e) {
            void $this$debug$iv;
            e$iv = BrokenPluginFileKt.getLOG();
            Exception e$iv3 = e;
            boolean $i$f$debug3 = false;
            if ($this$debug$iv.isDebugEnabled()) {
                logger = $this$debug$iv;
                boolean bl = false;
                logger.debug("Broken plugins file doesn't exist: " + brokenPluginsStorage, e$iv3);
            }
        }
        catch (Exception e) {
            BrokenPluginFileKt.getLOG().warn("Failed to read " + brokenPluginsStorage, e);
        }
        return null;
    }
}

