/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginStringSetFile;
import com.intellij.ide.plugins.PluginUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0016J\u0016\u0010\u000b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0016J\u0016\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0016\u0010\u0010\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/plugins/ExpiredPluginsState;", "Lcom/intellij/ide/plugins/PluginEnabler;", "<init>", "()V", "isDisabled", "", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "enableById", "pluginIds", "", "disableById", "enable", "descriptors", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "disable", "Companion", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class ExpiredPluginsState
implements PluginEnabler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String EXPIRED_PLUGINS_FILENAME = "expired_plugins.txt";
    @Nullable
    private static Set<PluginId> expiredPluginIds_;

    public ExpiredPluginsState() {
        ExpiredPluginsState.Companion.getLogger().info(PluginUtils.joinedPluginIds((Iterable<PluginId>)Companion.getExpiredPluginIds(), "skip"));
    }

    @Override
    public boolean isDisabled(@NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        return Companion.isExpired(pluginId);
    }

    @Override
    public boolean enableById(@NotNull Set<PluginId> pluginIds) {
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        return Companion.setExpiredState(pluginIds, true);
    }

    @Override
    public boolean disableById(@NotNull Set<PluginId> pluginIds) {
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        return Companion.setExpiredState(pluginIds, false);
    }

    @Override
    public boolean enable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        return this.enableById(PluginUtils.toPluginIdSet((Iterable<? extends IdeaPluginDescriptor>)descriptors));
    }

    @Override
    public boolean disable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        return this.disableById(PluginUtils.toPluginIdSet((Iterable<? extends IdeaPluginDescriptor>)descriptors));
    }

    @JvmStatic
    @NotNull
    public static final ExpiredPluginsState getInstance() {
        return Companion.getInstance();
    }

    @NotNull
    public static final Set<PluginId> getExpiredPluginIds() {
        return Companion.getExpiredPluginIds();
    }

    @JvmStatic
    public static final boolean isExpired(@NotNull PluginId pluginId) {
        return Companion.isExpired(pluginId);
    }

    @JvmStatic
    public static final boolean setExpiredState(@NotNull Set<PluginId> pluginIds, boolean expired) {
        return Companion.setExpiredState(pluginIds, expired);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\tH\u0007J\u001e\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u00162\u0006\u0010\u001f\u001a\u00020\u001bH\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00168FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0017\u0010\u0003\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lcom/intellij/ide/plugins/ExpiredPluginsState$Companion;", "", "<init>", "()V", "EXPIRED_PLUGINS_FILENAME", "", "Lorg/jetbrains/annotations/NonNls;", "expiredPluginIds_", "", "Lcom/intellij/openapi/extensions/PluginId;", "defaultFilePath", "Ljava/nio/file/Path;", "getDefaultFilePath", "()Ljava/nio/file/Path;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/ide/plugins/ExpiredPluginsState;", "expiredPluginIds", "", "getExpiredPluginIds$annotations", "getExpiredPluginIds", "()Ljava/util/Set;", "isExpired", "", "pluginId", "setExpiredState", "pluginIds", "expired", "intellij.platform.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getDefaultFilePath() {
            Path path = PathManager.getConfigDir().resolve(ExpiredPluginsState.EXPIRED_PLUGINS_FILENAME);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        private final Logger getLogger() {
            Logger logger = Logger.getInstance(ExpiredPluginsState.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            return logger;
        }

        @JvmStatic
        @NotNull
        public final ExpiredPluginsState getInstance() {
            ExpiredPluginsState expiredPluginsState = ApplicationManager.getApplication().getService(ExpiredPluginsState.class);
            Intrinsics.checkNotNullExpressionValue((Object)expiredPluginsState, (String)"getService(...)");
            return expiredPluginsState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final Set<PluginId> getExpiredPluginIds() {
            Set set = expiredPluginIds_;
            if (set != null) {
                Set it = set;
                boolean bl = false;
                return it;
            }
            Class<ExpiredPluginsState> clazz = ExpiredPluginsState.class;
            synchronized (clazz) {
                void var3_4;
                boolean bl = false;
                Set result = expiredPluginIds_;
                if (result == null) {
                    result = new LinkedHashSet(PluginStringSetFile.INSTANCE.readIdsSafe(Companion.getDefaultFilePath(), Companion.getLogger()));
                    expiredPluginIds_ = result;
                }
                void var4_7 = var3_4;
                return var4_7;
            }
        }

        @JvmStatic
        public static /* synthetic */ void getExpiredPluginIds$annotations() {
        }

        @JvmStatic
        public final boolean isExpired(@NotNull PluginId pluginId) {
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            return this.getExpiredPluginIds().contains(pluginId);
        }

        @JvmStatic
        public final boolean setExpiredState(@NotNull Set<PluginId> pluginIds, boolean expired) {
            Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
            this.getLogger().info(PluginUtils.joinedPluginIds((Iterable<PluginId>)pluginIds, "expire"));
            Set<PluginId> set = this.getExpiredPluginIds();
            Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<com.intellij.openapi.extensions.PluginId>");
            Set expiredPluginIds = TypeIntrinsics.asMutableSet(set);
            return (expired ? expiredPluginIds.addAll((Collection)pluginIds) : expiredPluginIds.removeAll((Collection)pluginIds)) && PluginStringSetFile.INSTANCE.writeIdsSafe(this.getDefaultFilePath(), expiredPluginIds, this.getLogger());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

