/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DataLoader;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/plugins/LocalFsDataLoader;", "Lcom/intellij/ide/plugins/DataLoader;", "basePath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "emptyDescriptorIfCannotResolve", "", "getEmptyDescriptorIfCannotResolve", "()Z", "load", "Ljava/io/InputStream;", "path", "", "pluginDescriptorSourceOnly", "toString", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class LocalFsDataLoader
implements DataLoader {
    @JvmField
    @NotNull
    public final Path basePath;

    public LocalFsDataLoader(@NotNull Path basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.basePath = basePath;
    }

    @Override
    public boolean getEmptyDescriptorIfCannotResolve() {
        return true;
    }

    @Override
    @Nullable
    public InputStream load(@NotNull String path, boolean pluginDescriptorSourceOnly) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            inputStream = Files.newInputStream(this.basePath.resolve(path), new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            inputStream = null;
        }
        return inputStream;
    }

    @Override
    @NotNull
    public String toString() {
        return ((Object)this.basePath).toString();
    }
}

