/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DiscoveredPluginsList;
import com.intellij.ide.plugins.PluginCompatibilityUtils;
import com.intellij.ide.plugins.PluginDescriptorLoadingResult;
import com.intellij.ide.plugins.PluginInitializationContext;
import com.intellij.ide.plugins.PluginIsCompatibleOnlyWithIntelliJIDEA;
import com.intellij.ide.plugins.PluginIsMarkedDisabled;
import com.intellij.ide.plugins.PluginMainDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNonLoadReason;
import com.intellij.ide.plugins.PluginsPerProjectConfig;
import com.intellij.ide.plugins.PluginsSourceContext;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\fH\u0000\u00a2\u0006\u0002\b\u001dJ\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u001fJ\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u001fJ\u001a\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\b\u0010$\u001a\u0004\u0018\u00010\u0010H\u0002J\u0016\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J \u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010-\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0006H\u0002R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\r\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u000fj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00138\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00198G\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006/"}, d2={"Lcom/intellij/ide/plugins/PluginLoadingResult;", "", "<init>", "()V", "incompletePlugins", "Ljava/util/HashMap;", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/ide/plugins/PluginMainDescriptor;", "Lkotlin/collections/HashMap;", "enabledPluginsById", "idMap", "duplicateModuleMap", "", "", "pluginErrors", "Ljava/util/LinkedHashMap;", "Lcom/intellij/ide/plugins/PluginNonLoadReason;", "Lkotlin/collections/LinkedHashMap;", "shadowedBundledIds", "", "hasPluginErrors", "", "getHasPluginErrors", "()Z", "enabledPlugins", "", "getEnabledPlugins", "()Ljava/util/List;", "copyPluginErrors", "copyPluginErrors$intellij_platform_core_impl", "getIncompleteIdMap", "", "getIdMap", "addIncompletePlugin", "", "plugin", "error", "initAndAddAll", "descriptorLoadingResult", "Lcom/intellij/ide/plugins/PluginDescriptorLoadingResult;", "initContext", "Lcom/intellij/ide/plugins/PluginInitializationContext;", "initAndAdd", "descriptor", "overrideUseIfCompatible", "checkAndAdd", "id", "intellij.platform.core.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPluginLoadingResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginLoadingResult.kt\ncom/intellij/ide/plugins/PluginLoadingResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1056#2:137\n1563#2:138\n1634#2,3:139\n1#3:142\n*S KotlinDebug\n*F\n+ 1 PluginLoadingResult.kt\ncom/intellij/ide/plugins/PluginLoadingResult\n*L\n33#1:137\n33#1:138\n33#1:139,3\n*E\n"})
public final class PluginLoadingResult {
    @NotNull
    private final HashMap<PluginId, PluginMainDescriptor> incompletePlugins = new HashMap();
    @JvmField
    @ApiStatus.Internal
    @NotNull
    public final HashMap<PluginId, PluginMainDescriptor> enabledPluginsById = new HashMap();
    @NotNull
    private final HashMap<PluginId, PluginMainDescriptor> idMap = new HashMap();
    @JvmField
    @Nullable
    public Map<PluginId, List<PluginMainDescriptor>> duplicateModuleMap;
    @NotNull
    private final LinkedHashMap<PluginId, PluginNonLoadReason> pluginErrors = new LinkedHashMap();
    @VisibleForTesting
    @JvmField
    @NotNull
    public final Set<PluginId> shadowedBundledIds = new HashSet();

    @TestOnly
    public final boolean getHasPluginErrors() {
        return !this.pluginErrors.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    @NotNull
    public final List<PluginMainDescriptor> getEnabledPlugins() {
        void $this$mapTo$iv$iv;
        Set<Map.Entry<PluginId, PluginMainDescriptor>> set = this.enabledPluginsById.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (PluginId)it.getKey();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((PluginId)it.getKey()));
            }
        });
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((PluginMainDescriptor)it.getValue());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Map<PluginId, PluginNonLoadReason> copyPluginErrors$intellij_platform_core_impl() {
        return new LinkedHashMap(this.pluginErrors);
    }

    @NotNull
    public final Map<PluginId, PluginMainDescriptor> getIncompleteIdMap() {
        return this.incompletePlugins;
    }

    @NotNull
    public final Map<PluginId, PluginMainDescriptor> getIdMap() {
        return this.idMap;
    }

    private final void addIncompletePlugin(PluginMainDescriptor plugin, PluginNonLoadReason error) {
        if (this.idMap.containsKey(plugin.getPluginId())) {
            return;
        }
        PluginMainDescriptor existingIncompletePlugin = this.incompletePlugins.putIfAbsent(plugin.getPluginId(), plugin);
        if (existingIncompletePlugin != null && VersionComparatorUtil.compare(plugin.getVersion(), existingIncompletePlugin.getVersion()) > 0) {
            this.incompletePlugins.put(plugin.getPluginId(), plugin);
            if (error != null) {
                this.pluginErrors.put(plugin.getPluginId(), error);
            }
        } else if (error != null) {
            this.pluginErrors.putIfAbsent(plugin.getPluginId(), error);
        }
    }

    public final void initAndAddAll(@NotNull PluginDescriptorLoadingResult descriptorLoadingResult, @NotNull PluginInitializationContext initContext) {
        Intrinsics.checkNotNullParameter((Object)descriptorLoadingResult, (String)"descriptorLoadingResult");
        Intrinsics.checkNotNullParameter((Object)initContext, (String)"initContext");
        for (DiscoveredPluginsList pluginList : descriptorLoadingResult.getDiscoveredPlugins()) {
            for (PluginMainDescriptor descriptor : pluginList.getPlugins()) {
                this.initAndAdd(descriptor, pluginList.getSource() instanceof PluginsSourceContext.SystemPropertyProvided, initContext);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initAndAdd(PluginMainDescriptor descriptor, boolean overrideUseIfCompatible, PluginInitializationContext initContext) {
        PluginNonLoadReason pluginNonLoadReason;
        PluginsPerProjectConfig pluginsPerProjectConfig = initContext.getPluginsPerProjectConfig();
        if (pluginsPerProjectConfig != null) {
            PluginsPerProjectConfig conf = pluginsPerProjectConfig;
            boolean bl = false;
            if (conf.isMainProcess() && !initContext.getEssentialPlugins().contains(descriptor.getPluginId())) {
                return;
            }
        }
        if ((pluginNonLoadReason = descriptor.initialize(initContext)) != null) {
            void it;
            PluginNonLoadReason pluginNonLoadReason2;
            PluginNonLoadReason error = pluginNonLoadReason;
            boolean bl = false;
            PluginNonLoadReason pluginNonLoadReason3 = pluginNonLoadReason2 = error;
            PluginMainDescriptor pluginMainDescriptor = descriptor;
            PluginLoadingResult pluginLoadingResult = this;
            boolean bl2 = false;
            boolean bl3 = !(it instanceof PluginIsMarkedDisabled);
            pluginLoadingResult.addIncompletePlugin(pluginMainDescriptor, bl3 ? pluginNonLoadReason2 : null);
            return;
        }
        if (initContext.getRequirePlatformAliasDependencyForLegacyPlugins() && PluginCompatibilityUtils.INSTANCE.isLegacyPluginWithoutPlatformAliasDependencies(descriptor)) {
            this.addIncompletePlugin(descriptor, new PluginIsCompatibleOnlyWithIntelliJIDEA(descriptor));
            return;
        }
        PluginId pluginId = descriptor.getPluginId();
        this.pluginErrors.remove(pluginId);
        this.incompletePlugins.remove(pluginId);
        PluginMainDescriptor prevDescriptor = this.enabledPluginsById.put(pluginId, descriptor);
        if (prevDescriptor == null) {
            this.idMap.put(pluginId, descriptor);
            for (PluginId pluginAlias : descriptor.getPluginAliases()) {
                this.checkAndAdd(descriptor, pluginAlias);
            }
            return;
        }
        if (prevDescriptor.isBundled() || descriptor.isBundled()) {
            this.shadowedBundledIds.add(pluginId);
        }
        if (PluginManagerCore.checkBuildNumberCompatibility(descriptor, initContext.getProductBuildNumber()) == null && (overrideUseIfCompatible || VersionComparatorUtil.compare(descriptor.getVersion(), prevDescriptor.getVersion()) > 0)) {
            PluginManagerCore.getLogger().info(descriptor + " overrides " + prevDescriptor);
            this.idMap.put(pluginId, descriptor);
            return;
        }
        this.enabledPluginsById.put(pluginId, prevDescriptor);
    }

    private final void checkAndAdd(PluginMainDescriptor descriptor, PluginId id) {
        Map<PluginId, List<PluginMainDescriptor>> map2 = this.duplicateModuleMap;
        if (map2 != null && (map2 = map2.get(id)) != null) {
            Map<PluginId, List<PluginMainDescriptor>> duplicates = map2;
            boolean bl = false;
            duplicates.add(descriptor);
            return;
        }
        PluginMainDescriptor pluginMainDescriptor = this.idMap.put(id, descriptor);
        if (pluginMainDescriptor == null) {
            return;
        }
        PluginMainDescriptor existingDescriptor = pluginMainDescriptor;
        this.idMap.remove(id);
        if (this.duplicateModuleMap == null) {
            this.duplicateModuleMap = new LinkedHashMap();
        }
        ArrayList<PluginMainDescriptor> list = new ArrayList<PluginMainDescriptor>(2);
        list.add(existingDescriptor);
        list.add(descriptor);
        Map<PluginId, List<PluginMainDescriptor>> map3 = this.duplicateModuleMap;
        Intrinsics.checkNotNull(map3);
        map3.put(id, list);
    }
}

