/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DataLoader;
import com.intellij.ide.plugins.PathResolver;
import com.intellij.ide.plugins.PathResolverKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.plugins.parser.impl.LoadPathUtil;
import com.intellij.platform.plugins.parser.impl.PluginDescriptorBuilder;
import com.intellij.platform.plugins.parser.impl.PluginDescriptorFromXmlStreamConsumer;
import com.intellij.platform.plugins.parser.impl.PluginDescriptorReaderContext;
import com.intellij.platform.plugins.parser.impl.PluginXmlStreamConsumer;
import com.intellij.platform.plugins.parser.impl.PluginXmlStreamConsumerKt;
import com.intellij.platform.plugins.parser.impl.XIncludeLoader;
import com.intellij.util.lang.ZipEntryResolverPool;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J \u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000eH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/plugins/PluginXmlPathResolver;", "Lcom/intellij/ide/plugins/PathResolver;", "pluginJarFiles", "", "Ljava/nio/file/Path;", "pool", "Lcom/intellij/util/lang/ZipEntryResolverPool;", "<init>", "(Ljava/util/List;Lcom/intellij/util/lang/ZipEntryResolverPool;)V", "loadXIncludeReference", "Lcom/intellij/platform/plugins/parser/impl/XIncludeLoader$LoadedXIncludeReference;", "dataLoader", "Lcom/intellij/ide/plugins/DataLoader;", "path", "", "resolvePath", "Lcom/intellij/platform/plugins/parser/impl/PluginDescriptorBuilder;", "readContext", "Lcom/intellij/platform/plugins/parser/impl/PluginDescriptorReaderContext;", "relativePath", "resolveModuleFile", "findInJarFiles", "Lcom/intellij/ide/plugins/PluginXmlPathResolver$ResolvedFromJar;", "Companion", "ResolvedFromJar", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class PluginXmlPathResolver
implements PathResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Path> pluginJarFiles;
    @Nullable
    private final ZipEntryResolverPool pool;
    @JvmField
    @NotNull
    public static final PathResolver DEFAULT_PATH_RESOLVER;

    public PluginXmlPathResolver(@NotNull List<? extends Path> pluginJarFiles, @Nullable ZipEntryResolverPool pool) {
        Intrinsics.checkNotNullParameter(pluginJarFiles, (String)"pluginJarFiles");
        this.pluginJarFiles = pluginJarFiles;
        this.pool = pool;
    }

    @Override
    @Nullable
    public XIncludeLoader.LoadedXIncludeReference loadXIncludeReference(@NotNull DataLoader dataLoader2, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            ZipEntryResolverPool zipEntryResolverPool;
            Object fromJar;
            InputStream inputStream = dataLoader2.load(path, false);
            if (inputStream != null) {
                InputStream input = inputStream;
                boolean bl = false;
                return new XIncludeLoader.LoadedXIncludeReference(input, null);
            }
            if (this.pool != null && (fromJar = this.findInJarFiles(dataLoader2, zipEntryResolverPool = this.pool, path)) != null) {
                return new XIncludeLoader.LoadedXIncludeReference(((ResolvedFromJar)fromJar).getInputStream(), ((ResolvedFromJar)fromJar).getDiagnosticLocation());
            }
            if (StringsKt.startsWith$default((String)path, (String)"META-INF/", (boolean)false, (int)2, null) && (fromJar = PluginXmlPathResolver.class.getClassLoader().getResourceAsStream(path)) != null) {
                Object input = fromJar;
                boolean bl = false;
                return new XIncludeLoader.LoadedXIncludeReference((InputStream)input, null);
            }
        }
        catch (Throwable e) {
            throw new IOException("Exception " + e.getMessage() + " while loading " + path, e);
        }
        return null;
    }

    @Override
    @Nullable
    public PluginDescriptorBuilder resolvePath(@NotNull PluginDescriptorReaderContext readContext, @NotNull DataLoader dataLoader2, @NotNull String relativePath) {
        ZipEntryResolverPool zipEntryResolverPool;
        ResolvedFromJar fromJar;
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String path = LoadPathUtil.toLoadPath$default(LoadPathUtil.INSTANCE, relativePath, null, 2, null);
        InputStream inputStream = dataLoader2.load(path, false);
        if (inputStream != null) {
            InputStream input = inputStream;
            boolean bl = false;
            PluginDescriptorFromXmlStreamConsumer it = new PluginDescriptorFromXmlStreamConsumer(readContext, PathResolverKt.toXIncludeLoader(this, dataLoader2));
            boolean bl2 = false;
            PluginXmlStreamConsumerKt.consume((PluginXmlStreamConsumer)it, input, null);
            return it.getBuilder();
        }
        if (this.pool != null && (fromJar = this.findInJarFiles(dataLoader2, zipEntryResolverPool = this.pool, path)) != null) {
            InputStream input = fromJar.getInputStream();
            boolean bl = false;
            PluginDescriptorFromXmlStreamConsumer it = new PluginDescriptorFromXmlStreamConsumer(readContext, PathResolverKt.toXIncludeLoader(this, dataLoader2));
            boolean bl3 = false;
            PluginXmlStreamConsumerKt.consume((PluginXmlStreamConsumer)it, input, null);
            return it.getBuilder();
        }
        if (StringsKt.startsWith$default((String)relativePath, (String)"intellij.", (boolean)false, (int)2, null)) {
            throw new RuntimeException("Cannot resolve " + path + " (dataLoader=" + dataLoader2 + ')');
        }
        return null;
    }

    @Override
    @NotNull
    public PluginDescriptorBuilder resolveModuleFile(@NotNull PluginDescriptorReaderContext readContext, @NotNull DataLoader dataLoader2, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        InputStream input = dataLoader2.load(path, true);
        if (input == null) {
            if (Intrinsics.areEqual((Object)path, (Object)"intellij.profiler.clion")) {
                PluginDescriptorBuilder pluginDescriptorBuilder;
                PluginDescriptorBuilder $this$resolveModuleFile_u24lambda_u246 = pluginDescriptorBuilder = PluginDescriptorBuilder.Companion.builder();
                boolean bl = false;
                $this$resolveModuleFile_u24lambda_u246.setPackage("com.intellij.profiler.clion");
                return pluginDescriptorBuilder;
            }
            throw new RuntimeException("Cannot resolve " + path + " (dataLoader=" + dataLoader2 + ", pluginJarFiles=" + CollectionsKt.joinToString$default((Iterable)this.pluginJarFiles, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null) + ')');
        }
        PluginDescriptorFromXmlStreamConsumer it = new PluginDescriptorFromXmlStreamConsumer(readContext, PathResolverKt.toXIncludeLoader(this, dataLoader2));
        boolean bl = false;
        PluginXmlStreamConsumerKt.consume((PluginXmlStreamConsumer)it, input, null);
        PluginDescriptorBuilder builder = it.getBuilder();
        return builder;
    }

    private final ResolvedFromJar findInJarFiles(DataLoader dataLoader2, ZipEntryResolverPool pool, String relativePath) {
        for (Path jarFile : this.pluginJarFiles) {
            ZipEntryResolverPool.EntryResolver entryResolver;
            if (dataLoader2.isExcludedFromSubSearch(jarFile)) continue;
            try {
                entryResolver = pool.load(jarFile);
            }
            catch (IOException e) {
                Logger.getInstance(PluginXmlPathResolver.class).error("Corrupted jar file: " + jarFile, e);
                continue;
            }
            ZipEntryResolverPool.EntryResolver entryResolver2 = entryResolver;
            Intrinsics.checkNotNull((Object)entryResolver2);
            ZipEntryResolverPool.EntryResolver resolver = entryResolver2;
            InputStream result = resolver.loadZipEntry(relativePath);
            if (result == null) continue;
            return new ResolvedFromJar(result, ((Object)jarFile).toString());
        }
        return null;
    }

    static {
        List list = Collections.emptyList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
        DEFAULT_PATH_RESOLVER = new PluginXmlPathResolver(list, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/plugins/PluginXmlPathResolver$Companion;", "", "<init>", "()V", "DEFAULT_PATH_RESOLVER", "Lcom/intellij/ide/plugins/PathResolver;", "intellij.platform.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/plugins/PluginXmlPathResolver$ResolvedFromJar;", "", "inputStream", "Ljava/io/InputStream;", "diagnosticLocation", "", "<init>", "(Ljava/io/InputStream;Ljava/lang/String;)V", "getInputStream", "()Ljava/io/InputStream;", "getDiagnosticLocation", "()Ljava/lang/String;", "intellij.platform.core.impl"})
    private static final class ResolvedFromJar {
        @NotNull
        private final InputStream inputStream;
        @Nullable
        private final String diagnosticLocation;

        public ResolvedFromJar(@NotNull InputStream inputStream, @Nullable String diagnosticLocation) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            this.inputStream = inputStream;
            this.diagnosticLocation = diagnosticLocation;
        }

        @NotNull
        public final InputStream getInputStream() {
            return this.inputStream;
        }

        @Nullable
        public final String getDiagnosticLocation() {
            return this.diagnosticLocation;
        }
    }
}

