/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.BrokenPluginFileKt;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.ExpiredPluginsState;
import com.intellij.ide.plugins.PluginInitializationContext;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginsPerProjectConfig;
import com.intellij.ide.plugins.ProductLoadingStrategy;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.PlatformUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001BU\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u001c\b\u0002\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0005\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0006H\u0016J\u001a\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00062\b\u0010#\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010$\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0006H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0005\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\u000fR!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0011\u001a\u0004\b\u0016\u0010\u000fR-\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00050\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0011\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010%\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R#\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u0011\u001a\u0004\b+\u0010\u000fR\u0014\u0010-\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010'R\u001d\u0010/\u001a\u0004\u0018\u0001008VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010\u0011\u001a\u0004\b1\u00102R\u0014\u00104\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u00067"}, d2={"Lcom/intellij/ide/plugins/ProductPluginInitContext;", "Lcom/intellij/ide/plugins/PluginInitializationContext;", "buildNumberOverride", "Lcom/intellij/openapi/util/BuildNumber;", "disabledPluginsOverride", "", "Lcom/intellij/openapi/extensions/PluginId;", "expiredPluginsOverride", "brokenPluginVersionsOverride", "", "", "<init>", "(Lcom/intellij/openapi/util/BuildNumber;Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;)V", "essentialPlugins", "getEssentialPlugins", "()Ljava/util/Set;", "essentialPlugins$delegate", "Lkotlin/Lazy;", "disabledPlugins", "getDisabledPlugins", "disabledPlugins$delegate", "expiredPlugins", "getExpiredPlugins", "expiredPlugins$delegate", "brokenPluginVersions", "getBrokenPluginVersions", "()Ljava/util/Map;", "brokenPluginVersions$delegate", "productBuildNumber", "getProductBuildNumber", "()Lcom/intellij/openapi/util/BuildNumber;", "isPluginDisabled", "", "id", "isPluginBroken", "version", "isPluginExpired", "requirePlatformAliasDependencyForLegacyPlugins", "getRequirePlatformAliasDependencyForLegacyPlugins", "()Z", "checkEssentialPlugins", "getCheckEssentialPlugins", "explicitPluginSubsetToLoad", "getExplicitPluginSubsetToLoad", "explicitPluginSubsetToLoad$delegate", "disablePluginLoadingCompletely", "getDisablePluginLoadingCompletely", "pluginsPerProjectConfig", "Lcom/intellij/ide/plugins/PluginsPerProjectConfig;", "getPluginsPerProjectConfig", "()Lcom/intellij/ide/plugins/PluginsPerProjectConfig;", "pluginsPerProjectConfig$delegate", "currentProductModeId", "getCurrentProductModeId", "()Ljava/lang/String;", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class ProductPluginInitContext
implements PluginInitializationContext {
    @Nullable
    private final BuildNumber buildNumberOverride;
    @Nullable
    private final Set<PluginId> disabledPluginsOverride;
    @Nullable
    private final Set<PluginId> expiredPluginsOverride;
    @Nullable
    private final Map<PluginId, Set<String>> brokenPluginVersionsOverride;
    @NotNull
    private final Lazy essentialPlugins$delegate;
    @NotNull
    private final Lazy disabledPlugins$delegate;
    @NotNull
    private final Lazy expiredPlugins$delegate;
    @NotNull
    private final Lazy brokenPluginVersions$delegate;
    @NotNull
    private final Lazy explicitPluginSubsetToLoad$delegate;
    @NotNull
    private final Lazy pluginsPerProjectConfig$delegate;

    public ProductPluginInitContext(@Nullable BuildNumber buildNumberOverride, @Nullable Set<PluginId> disabledPluginsOverride, @Nullable Set<PluginId> expiredPluginsOverride, @Nullable Map<PluginId, ? extends Set<String>> brokenPluginVersionsOverride) {
        this.buildNumberOverride = buildNumberOverride;
        this.disabledPluginsOverride = disabledPluginsOverride;
        this.expiredPluginsOverride = expiredPluginsOverride;
        this.brokenPluginVersionsOverride = brokenPluginVersionsOverride;
        this.essentialPlugins$delegate = LazyKt.lazy(ProductPluginInitContext::essentialPlugins_delegate$lambda$0);
        this.disabledPlugins$delegate = LazyKt.lazy(() -> ProductPluginInitContext.disabledPlugins_delegate$lambda$1(this));
        this.expiredPlugins$delegate = LazyKt.lazy(() -> ProductPluginInitContext.expiredPlugins_delegate$lambda$2(this));
        this.brokenPluginVersions$delegate = LazyKt.lazy(() -> ProductPluginInitContext.brokenPluginVersions_delegate$lambda$3(this));
        this.explicitPluginSubsetToLoad$delegate = LazyKt.lazy(ProductPluginInitContext::explicitPluginSubsetToLoad_delegate$lambda$5);
        this.pluginsPerProjectConfig$delegate = LazyKt.lazy(ProductPluginInitContext::pluginsPerProjectConfig_delegate$lambda$6);
    }

    public /* synthetic */ ProductPluginInitContext(BuildNumber buildNumber, Set set, Set set2, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            buildNumber = null;
        }
        if ((n & 2) != 0) {
            set = null;
        }
        if ((n & 4) != 0) {
            set2 = null;
        }
        if ((n & 8) != 0) {
            map2 = null;
        }
        this(buildNumber, set, set2, map2);
    }

    @Override
    @NotNull
    public Set<PluginId> getEssentialPlugins() {
        Lazy lazy = this.essentialPlugins$delegate;
        return (Set)lazy.getValue();
    }

    private final Set<PluginId> getDisabledPlugins() {
        Lazy lazy = this.disabledPlugins$delegate;
        return (Set)lazy.getValue();
    }

    private final Set<PluginId> getExpiredPlugins() {
        Lazy lazy = this.expiredPlugins$delegate;
        return (Set)lazy.getValue();
    }

    private final Map<PluginId, Set<String>> getBrokenPluginVersions() {
        Lazy lazy = this.brokenPluginVersions$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    @NotNull
    public BuildNumber getProductBuildNumber() {
        BuildNumber buildNumber = this.buildNumberOverride;
        if (buildNumber == null) {
            buildNumber = PluginManagerCore.getBuildNumber();
        }
        return buildNumber;
    }

    @Override
    public boolean isPluginDisabled(@NotNull PluginId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return !Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)id) && this.getDisabledPlugins().contains(id);
    }

    @Override
    public boolean isPluginBroken(@NotNull PluginId id, @Nullable String version) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Set<String> set = this.getBrokenPluginVersions().get(id);
        if (set == null) {
            return false;
        }
        Set<String> set2 = set;
        return CollectionsKt.contains((Iterable)set2, (Object)version);
    }

    @Override
    public boolean isPluginExpired(@NotNull PluginId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getExpiredPlugins().contains(id);
    }

    @Override
    public boolean getRequirePlatformAliasDependencyForLegacyPlugins() {
        return !PlatformUtils.isIntelliJ();
    }

    @Override
    public boolean getCheckEssentialPlugins() {
        return !PluginManagerCore.isUnitTestMode;
    }

    @Override
    @Nullable
    public Set<PluginId> getExplicitPluginSubsetToLoad() {
        Lazy lazy = this.explicitPluginSubsetToLoad$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    public boolean getDisablePluginLoadingCompletely() {
        return !Boolean.parseBoolean(System.getProperty("idea.load.plugins", "true"));
    }

    @Override
    @Nullable
    public PluginsPerProjectConfig getPluginsPerProjectConfig() {
        Lazy lazy = this.pluginsPerProjectConfig$delegate;
        return (PluginsPerProjectConfig)lazy.getValue();
    }

    @Override
    @NotNull
    public String getCurrentProductModeId() {
        return ProductLoadingStrategy.Companion.getStrategy().getCurrentModeId();
    }

    private static final Set essentialPlugins_delegate$lambda$0() {
        List<PluginId> list = ApplicationInfoImpl.getShadowInstance().getEssentialPluginIds();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getEssentialPluginIds(...)");
        return CollectionsKt.toSet((Iterable)list);
    }

    private static final Set disabledPlugins_delegate$lambda$1(ProductPluginInitContext this$0) {
        Set<PluginId> set = this$0.disabledPluginsOverride;
        if (set == null) {
            set = DisabledPluginsState.Companion.getDisabledIds();
        }
        return set;
    }

    private static final Set expiredPlugins_delegate$lambda$2(ProductPluginInitContext this$0) {
        Set<PluginId> set = this$0.expiredPluginsOverride;
        if (set == null) {
            set = ExpiredPluginsState.Companion.getExpiredPluginIds();
        }
        return set;
    }

    private static final Map brokenPluginVersions_delegate$lambda$3(ProductPluginInitContext this$0) {
        Map<PluginId, Set<String>> map2 = this$0.brokenPluginVersionsOverride;
        if (map2 == null) {
            map2 = BrokenPluginFileKt.getBrokenPluginVersions();
        }
        return map2;
    }

    private static final boolean explicitPluginSubsetToLoad_delegate$lambda$5$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() > 0;
    }

    private static final HashSet explicitPluginSubsetToLoad_delegate$lambda$5() {
        Sequence sequence;
        Sequence sequence2;
        char[] cArray;
        Sequence sequence3;
        String string = System.getProperty("idea.load.plugins.id");
        return string != null && (sequence3 = StringsKt.splitToSequence$default((CharSequence)string, (char[])(cArray = new char[]{','}), (boolean)false, (int)0, (int)6, null)) != null && (sequence2 = SequencesKt.filter((Sequence)sequence3, ProductPluginInitContext::explicitPluginSubsetToLoad_delegate$lambda$5$lambda$4)) != null && (sequence = SequencesKt.map((Sequence)sequence2, (Function1)((Function1)new Function1<String, PluginId>((Object)PluginId.Companion){

            public final PluginId invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((PluginId.Companion)this.receiver).getId(p0);
            }
        }))) != null ? SequencesKt.toHashSet((Sequence)sequence) : null;
    }

    private static final PluginsPerProjectConfig pluginsPerProjectConfig_delegate$lambda$6() {
        return Boolean.getBoolean("ide.per.project.instance") ? new PluginsPerProjectConfig(!StringsKt.startsWith$default((String)((Object)PathManager.getPluginsDir().getFileName()).toString(), (String)"perProject_", (boolean)false, (int)2, null)) : null;
    }

    public ProductPluginInitContext() {
        this(null, null, null, null, 15, null);
    }
}

