/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.syntax.parser;

import com.intellij.java.syntax.JavaSyntaxBundle;
import com.intellij.java.syntax.element.JavaSyntaxElementType;
import com.intellij.java.syntax.element.JavaSyntaxTokenType;
import com.intellij.java.syntax.element.SyntaxElementTypes;
import com.intellij.java.syntax.parser.JavaParser;
import com.intellij.java.syntax.parser.JavaParserUtil;
import com.intellij.java.syntax.parser.ModuleParserKt;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.parser.SyntaxTreeBuilder;
import com.intellij.platform.syntax.util.parser.SyntaxBuilderUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u001d\u0010\u001b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u000b\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/java/syntax/parser/ModuleParser;", "", "myParser", "Lcom/intellij/java/syntax/parser/JavaParser;", "<init>", "(Lcom/intellij/java/syntax/parser/JavaParser;)V", "parse", "Lcom/intellij/platform/syntax/parser/SyntaxTreeBuilder$Marker;", "builder", "Lcom/intellij/platform/syntax/parser/SyntaxTreeBuilder;", "parseName", "parseModuleContent", "", "parseStatement", "parseRequiresStatement", "parseExportsStatement", "parseOpensStatement", "parsePackageStatement", "statement", "type", "Lcom/intellij/platform/syntax/SyntaxElementType;", "parseUsesStatement", "parseProvidesStatement", "parseNameRef", "parseClassOrPackageRef", "mapAndAdvance", "keyword", "parseExtras", "message", "", "Lcom/intellij/openapi/util/NlsContexts$ParsingError;", "intellij.java.syntax"})
@SourceDebugExtension(value={"SMAP\nModuleParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleParser.kt\ncom/intellij/java/syntax/parser/ModuleParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,305:1\n1#2:306\n*E\n"})
public final class ModuleParser {
    @NotNull
    private final JavaParser myParser;

    public ModuleParser(@NotNull JavaParser myParser) {
        this.myParser = myParser;
    }

    @Nullable
    public final SyntaxTreeBuilder.Marker parse(@NotNull SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker modifierList;
        String text;
        SyntaxTreeBuilder.Marker module = builder.mark();
        SyntaxTreeBuilder.Marker firstAnnotation = this.myParser.getDeclarationParser().parseAnnotations(builder);
        SyntaxElementType type = builder.getTokenType();
        String string = text = type == JavaSyntaxTokenType.IDENTIFIER ? builder.getTokenText() : null;
        if (!Intrinsics.areEqual((Object)"open", (Object)text) && !Intrinsics.areEqual((Object)"module", (Object)text)) {
            module.rollbackTo();
            return null;
        }
        SyntaxTreeBuilder.Marker marker = firstAnnotation;
        if (marker == null || (marker = marker.precede()) == null) {
            marker = modifierList = builder.mark();
        }
        if (Intrinsics.areEqual((Object)"open", (Object)text)) {
            this.mapAndAdvance(builder, JavaSyntaxTokenType.OPEN_KEYWORD);
            text = builder.getTokenText();
        }
        JavaParserUtil.INSTANCE.done(modifierList, JavaSyntaxElementType.MODIFIER_LIST, this.myParser.getLanguageLevel());
        if (!Intrinsics.areEqual((Object)"module", (Object)text)) {
            module.drop();
            this.parseExtras(builder, JavaSyntaxBundle.message("expected.module.declaration", new Object[0]));
            return module;
        }
        this.mapAndAdvance(builder, JavaSyntaxTokenType.MODULE_KEYWORD);
        if (this.parseName(builder) == null) {
            module.drop();
            if (builder.getTokenType() != null) {
                this.parseExtras(builder, JavaSyntaxBundle.message("expected.module.declaration", new Object[0]));
            } else {
                JavaParserUtil.error(builder, JavaSyntaxBundle.message("expected.identifier", new Object[0]));
            }
            return module;
        }
        if (!SyntaxBuilderUtil.expect(builder, JavaSyntaxTokenType.LBRACE)) {
            if (builder.getTokenType() != null) {
                this.parseExtras(builder, JavaSyntaxBundle.message("expected.module.declaration", new Object[0]));
            } else {
                JavaParserUtil.error(builder, JavaSyntaxBundle.message("expected.lbrace", new Object[0]));
            }
        } else {
            this.parseModuleContent(builder);
        }
        JavaParserUtil.INSTANCE.done(module, JavaSyntaxElementType.MODULE, this.myParser.getLanguageLevel());
        if (builder.getTokenType() != null) {
            this.parseExtras(builder, JavaSyntaxBundle.message("unexpected.tokens", new Object[0]));
        }
        return module;
    }

    @Nullable
    public final SyntaxTreeBuilder.Marker parseName(@NotNull SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker nameElement = builder.mark();
        boolean empty = true;
        boolean idExpected = true;
        while (true) {
            SyntaxElementType t;
            if ((t = builder.getTokenType()) == JavaSyntaxTokenType.IDENTIFIER) {
                if (!idExpected) {
                    JavaParserUtil.error(builder, JavaSyntaxBundle.message("expected.dot", new Object[0]));
                }
                idExpected = false;
            } else {
                if (t != JavaSyntaxTokenType.DOT) break;
                if (idExpected) {
                    JavaParserUtil.error(builder, JavaSyntaxBundle.message("expected.identifier", new Object[0]));
                }
                idExpected = true;
            }
            builder.advanceLexer();
            empty = false;
        }
        if (!empty) {
            if (idExpected) {
                JavaParserUtil.error(builder, JavaSyntaxBundle.message("expected.identifier", new Object[0]));
            }
            nameElement.done(JavaSyntaxElementType.MODULE_REFERENCE);
            return nameElement;
        }
        nameElement.drop();
        return null;
    }

    private final void parseModuleContent(SyntaxTreeBuilder builder) {
        SyntaxElementType token = null;
        SyntaxTreeBuilder.Marker invalid = null;
        while (true) {
            SyntaxElementType syntaxElementType;
            SyntaxElementType it = syntaxElementType = builder.getTokenType();
            boolean bl = false;
            token = it;
            if (syntaxElementType == null || token == JavaSyntaxTokenType.RBRACE) break;
            if (token == JavaSyntaxTokenType.SEMICOLON) {
                if (invalid != null) {
                    invalid.error(JavaSyntaxBundle.message("expected.module.statement", new Object[0]));
                    invalid = null;
                }
                builder.advanceLexer();
                continue;
            }
            SyntaxTreeBuilder.Marker statement = this.parseStatement(builder);
            if (statement == null) {
                if (invalid == null) {
                    invalid = builder.mark();
                }
                builder.advanceLexer();
                continue;
            }
            if (invalid == null) continue;
            invalid.errorBefore(JavaSyntaxBundle.message("expected.module.statement", new Object[0]), statement);
            invalid = null;
        }
        SyntaxTreeBuilder.Marker marker = invalid;
        if (marker != null) {
            marker.error(JavaSyntaxBundle.message("expected.module.statement", new Object[0]));
        }
        if (!SyntaxBuilderUtil.expect(builder, JavaSyntaxTokenType.RBRACE) && invalid == null) {
            JavaParserUtil.error(builder, JavaSyntaxBundle.message("expected.rbrace", new Object[0]));
        }
    }

    private final SyntaxTreeBuilder.Marker parseStatement(SyntaxTreeBuilder builder) {
        String kw = builder.getTokenText();
        if (Intrinsics.areEqual((Object)"requires", (Object)kw)) {
            return this.parseRequiresStatement(builder);
        }
        if (Intrinsics.areEqual((Object)"exports", (Object)kw)) {
            return this.parseExportsStatement(builder);
        }
        if (Intrinsics.areEqual((Object)"opens", (Object)kw)) {
            return this.parseOpensStatement(builder);
        }
        if (Intrinsics.areEqual((Object)"uses", (Object)kw)) {
            return this.parseUsesStatement(builder);
        }
        if (Intrinsics.areEqual((Object)"provides", (Object)kw)) {
            return this.parseProvidesStatement(builder);
        }
        return null;
    }

    private final SyntaxTreeBuilder.Marker parseRequiresStatement(SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker statement = builder.mark();
        this.mapAndAdvance(builder, JavaSyntaxTokenType.REQUIRES_KEYWORD);
        SyntaxTreeBuilder.Marker modifierList = builder.mark();
        while (true) {
            if (SyntaxBuilderUtil.expect(builder, SyntaxElementTypes.INSTANCE.getMODIFIER_BIT_SET())) {
                continue;
            }
            if (builder.getTokenType() != JavaSyntaxTokenType.IDENTIFIER || !Intrinsics.areEqual((Object)"transitive", (Object)builder.getTokenText())) break;
            this.mapAndAdvance(builder, JavaSyntaxTokenType.TRANSITIVE_KEYWORD);
        }
        JavaParserUtil.INSTANCE.done(modifierList, JavaSyntaxElementType.MODIFIER_LIST, this.myParser.getLanguageLevel());
        if (this.parseNameRef(builder) != null) {
            JavaParserUtil.INSTANCE.semicolon(builder);
        } else {
            SyntaxBuilderUtil.expect(builder, JavaSyntaxTokenType.SEMICOLON);
        }
        statement.done(JavaSyntaxElementType.REQUIRES_STATEMENT);
        return statement;
    }

    private final SyntaxTreeBuilder.Marker parseExportsStatement(SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker statement = builder.mark();
        this.mapAndAdvance(builder, JavaSyntaxTokenType.EXPORTS_KEYWORD);
        return this.parsePackageStatement(builder, statement, JavaSyntaxElementType.EXPORTS_STATEMENT);
    }

    private final SyntaxTreeBuilder.Marker parseOpensStatement(SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker statement = builder.mark();
        this.mapAndAdvance(builder, JavaSyntaxTokenType.OPENS_KEYWORD);
        return this.parsePackageStatement(builder, statement, JavaSyntaxElementType.OPENS_STATEMENT);
    }

    private final SyntaxTreeBuilder.Marker parsePackageStatement(SyntaxTreeBuilder builder, SyntaxTreeBuilder.Marker statement, SyntaxElementType type) {
        boolean hasError = false;
        if (this.parseClassOrPackageRef(builder) != null) {
            if (Intrinsics.areEqual((Object)"to", (Object)builder.getTokenText())) {
                SyntaxTreeBuilder.Marker ref;
                this.mapAndAdvance(builder, JavaSyntaxTokenType.TO_KEYWORD);
                do {
                    ref = this.parseNameRef(builder);
                } while (SyntaxBuilderUtil.expect(builder, JavaSyntaxTokenType.COMMA));
                if (ref == null) {
                    hasError = true;
                }
            }
        } else {
            JavaParserUtil.error(builder, JavaSyntaxBundle.message("expected.package.reference", new Object[0]));
            hasError = true;
        }
        if (!hasError) {
            JavaParserUtil.INSTANCE.semicolon(builder);
        } else {
            SyntaxBuilderUtil.expect(builder, JavaSyntaxTokenType.SEMICOLON);
        }
        statement.done(type);
        return statement;
    }

    private final SyntaxTreeBuilder.Marker parseUsesStatement(SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker statement = builder.mark();
        this.mapAndAdvance(builder, JavaSyntaxTokenType.USES_KEYWORD);
        if (this.parseClassOrPackageRef(builder) != null) {
            JavaParserUtil.INSTANCE.semicolon(builder);
        } else {
            JavaParserUtil.error(builder, JavaSyntaxBundle.message("expected.class.reference", new Object[0]));
            SyntaxBuilderUtil.expect(builder, JavaSyntaxTokenType.SEMICOLON);
        }
        statement.done(JavaSyntaxElementType.USES_STATEMENT);
        return statement;
    }

    private final SyntaxTreeBuilder.Marker parseProvidesStatement(SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker statement = builder.mark();
        boolean hasError = false;
        this.mapAndAdvance(builder, JavaSyntaxTokenType.PROVIDES_KEYWORD);
        if (this.parseClassOrPackageRef(builder) == null) {
            JavaParserUtil.error(builder, JavaSyntaxBundle.message("expected.class.reference", new Object[0]));
            hasError = true;
        }
        if (Intrinsics.areEqual((Object)"with", (Object)builder.getTokenText())) {
            builder.remapCurrentToken(JavaSyntaxTokenType.WITH_KEYWORD);
            hasError = this.myParser.getReferenceParser().parseReferenceList(builder, JavaSyntaxTokenType.WITH_KEYWORD, JavaSyntaxElementType.PROVIDES_WITH_LIST, JavaSyntaxTokenType.COMMA);
        } else if (!hasError) {
            SyntaxElementType next = builder.getTokenType();
            if (next == JavaSyntaxTokenType.IDENTIFIER && !CollectionsKt.contains((Iterable)ModuleParserKt.access$getSTATEMENT_KEYWORDS$p(), (Object)builder.getTokenText())) {
                SyntaxTreeBuilder.Marker marker = builder.mark();
                builder.advanceLexer();
                marker.error(JavaSyntaxBundle.message("expected.with", new Object[0]));
            } else {
                JavaParserUtil.error(builder, JavaSyntaxBundle.message("expected.with", new Object[0]));
            }
            hasError = true;
        }
        if (!hasError) {
            JavaParserUtil.INSTANCE.semicolon(builder);
        } else {
            SyntaxBuilderUtil.expect(builder, JavaSyntaxTokenType.SEMICOLON);
        }
        statement.done(JavaSyntaxElementType.PROVIDES_STATEMENT);
        return statement;
    }

    private final SyntaxTreeBuilder.Marker parseNameRef(SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker name = this.parseName(builder);
        if (name == null) {
            JavaParserUtil.error(builder, JavaSyntaxBundle.message("expected.identifier", new Object[0]));
        }
        return name;
    }

    private final SyntaxTreeBuilder.Marker parseClassOrPackageRef(SyntaxTreeBuilder builder) {
        return this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, false, false, false);
    }

    private final void mapAndAdvance(SyntaxTreeBuilder builder, SyntaxElementType keyword) {
        builder.remapCurrentToken(keyword);
        builder.advanceLexer();
    }

    private final void parseExtras(SyntaxTreeBuilder builder, String message) {
        SyntaxTreeBuilder.Marker extras = builder.mark();
        while (builder.getTokenType() != null) {
            builder.advanceLexer();
        }
        extras.error(message);
    }
}

