/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.annotation;

import com.intellij.BundleBase;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Objects;
import java.util.function.Supplier;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HighlightSeverity
implements Comparable<HighlightSeverity> {
    @NotNull
    @NonNls
    public final String myName;
    public final int myVal;
    private final @Nullable Supplier<@Nls String> myDisplayName;
    private final @Nullable Supplier<@Nls String> myCapitalizedDisplayName;
    private final @Nullable Supplier<@Nls String> myCountMessageTemplate;
    public static final HighlightSeverity INFORMATION = new HighlightSeverity("INFORMATION", 10, InspectionsBundle.messagePointer("information.severity", new Object[0]), InspectionsBundle.messagePointer("information.severity.capitalized", new Object[0]), InspectionsBundle.messagePointer("information.severity.count.message", new Object[0]));
    public static final HighlightSeverity TEXT_ATTRIBUTES = new HighlightSeverity("TEXT ATTRIBUTES", 11, InspectionsBundle.messagePointer("text.attributes.severity", new Object[0]), InspectionsBundle.messagePointer("text.attributes.severity.capitalized", new Object[0]), InspectionsBundle.messagePointer("text.attributes.severity.count.message", new Object[0]));
    public static final HighlightSeverity GENERIC_SERVER_ERROR_OR_WARNING = new HighlightSeverity("SERVER PROBLEM", 100, InspectionsBundle.messagePointer("server.problem.severity", new Object[0]), InspectionsBundle.messagePointer("server.problem.severity.capitalized", new Object[0]), InspectionsBundle.messagePointer("server.problem.severity.count.message", new Object[0]));
    @Deprecated
    public static final HighlightSeverity INFO = new HighlightSeverity("INFO", 200, InspectionsBundle.messagePointer("info.severity", new Object[0]), InspectionsBundle.messagePointer("info.severity.capitalized", new Object[0]), InspectionsBundle.messagePointer("info.severity.count.message", new Object[0]));
    public static final HighlightSeverity WEAK_WARNING = new HighlightSeverity("WEAK WARNING", 200, InspectionsBundle.messagePointer("weak.warning.severity", new Object[0]), InspectionsBundle.messagePointer("weak.warning.severity.capitalized", new Object[0]), InspectionsBundle.messagePointer("weak.warning.severity.count.message", new Object[0]));
    public static final HighlightSeverity WARNING = new HighlightSeverity("WARNING", 300, InspectionsBundle.messagePointer("warning.severity", new Object[0]), InspectionsBundle.messagePointer("warning.severity.capitalized", new Object[0]), InspectionsBundle.messagePointer("warning.severity.count.message", new Object[0]));
    public static final HighlightSeverity ERROR = new HighlightSeverity("ERROR", 400, InspectionsBundle.messagePointer("error.severity", new Object[0]), InspectionsBundle.messagePointer("error.severity.capitalized", new Object[0]), InspectionsBundle.messagePointer("error.severity.count.message", new Object[0]));
    public static final HighlightSeverity[] DEFAULT_SEVERITIES = new HighlightSeverity[]{INFORMATION, TEXT_ATTRIBUTES, GENERIC_SERVER_ERROR_OR_WARNING, INFO, WEAK_WARNING, WARNING, ERROR};

    public HighlightSeverity(@NotNull String name, int val, @Nullable Supplier<@Nls String> displayName, @Nullable Supplier<@Nls String> capitalizedDisplayName, @Nullable Supplier<@Nls String> countMessageTemplate) {
        if (name == null) {
            HighlightSeverity.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myVal = val;
        this.myDisplayName = displayName;
        this.myCapitalizedDisplayName = capitalizedDisplayName;
        this.myCountMessageTemplate = countMessageTemplate;
    }

    public HighlightSeverity(@NotNull String name, int val) {
        if (name == null) {
            HighlightSeverity.$$$reportNull$$$0(1);
        }
        this(name, val, null, null, null);
    }

    public HighlightSeverity(@NotNull Element element) {
        if (element == null) {
            HighlightSeverity.$$$reportNull$$$0(2);
        }
        this(HighlightSeverity.readField(element, "myName"), Integer.parseInt(HighlightSeverity.readField(element, "myVal")), null, null, null);
    }

    private static String readField(Element element, String name) {
        String value = JDOMExternalizerUtil.readField(element, name);
        if (value == null) {
            throw new IllegalArgumentException("Element '" + String.valueOf(element) + "' misses attribute '" + name + "'");
        }
        return value;
    }

    @NonNls
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            HighlightSeverity.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return this.getBundleMessage(this.myDisplayName);
    }

    @Nls
    @NotNull
    public String getDisplayCapitalizedName() {
        return this.getBundleMessage(this.myCapitalizedDisplayName);
    }

    @Nls
    @NotNull
    public String getCountMessage(int count2) {
        if (this.myCountMessageTemplate != null) {
            String string = BundleBase.format(this.myCountMessageTemplate.get(), count2);
            if (string == null) {
                HighlightSeverity.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = InspectionsBundle.message("custom.severity.count.message", count2, this.myName);
        if (string == null) {
            HighlightSeverity.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    @Nls
    private String getBundleMessage(@Nullable Supplier<@Nls String> messageSupplier) {
        String name;
        if (messageSupplier != null) {
            String string = messageSupplier.get();
            if (string == null) {
                HighlightSeverity.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = name = this.myName;
        if (string == null) {
            HighlightSeverity.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public int compareTo(@NotNull HighlightSeverity highlightSeverity) {
        if (highlightSeverity == null) {
            HighlightSeverity.$$$reportNull$$$0(8);
        }
        return Integer.compare(this.myVal, highlightSeverity.myVal);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal(this, element);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HighlightSeverity that = (HighlightSeverity)o;
        return this.myVal == that.myVal && this.myName.equals(that.myName);
    }

    public int hashCode() {
        return 31 * Objects.hashCode(this.myName) + this.myVal;
    }

    public String toString() {
        return this.myName + "(" + this.myVal + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/annotation/HighlightSeverity";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightSeverity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/annotation/HighlightSeverity";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCountMessage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

