/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.lang.documentation.ClientDocumentationSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.MathUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public final class DocumentationSettings {
    private DocumentationSettings() {
    }

    public static boolean isHighlightingOfQuickDocSignaturesEnabled() {
        return ClientDocumentationSettings.getCurrentInstance().isHighlightingOfQuickDocSignaturesEnabled();
    }

    public static boolean isHighlightingOfCodeBlocksEnabled() {
        return ClientDocumentationSettings.getCurrentInstance().isHighlightingOfCodeBlocksEnabled();
    }

    public static boolean isCodeBackgroundEnabled() {
        return ClientDocumentationSettings.getCurrentInstance().isCodeBackgroundEnabled();
    }

    public static boolean isSemanticHighlightingOfLinksEnabled() {
        return ClientDocumentationSettings.getCurrentInstance().isSemanticHighlightingOfLinksEnabled();
    }

    @NotNull
    public static InlineCodeHighlightingMode getInlineCodeHighlightingMode() {
        InlineCodeHighlightingMode inlineCodeHighlightingMode = ClientDocumentationSettings.getCurrentInstance().getInlineCodeHighlightingMode();
        if (inlineCodeHighlightingMode == null) {
            DocumentationSettings.$$$reportNull$$$0(0);
        }
        return inlineCodeHighlightingMode;
    }

    public static boolean autoShowQuickDocInModalDialogs() {
        return ClientDocumentationSettings.getCurrentInstance().autoShowQuickDocInModalDialogs();
    }

    public static float getHighlightingSaturation(boolean isForRenderedDoc) {
        int result = ApplicationManager.getApplication().isUnitTestMode() ? 100 : (isForRenderedDoc ? Registry.intValue("documentation.component.highlighting.saturation.for.rendered.docs") : Registry.intValue("documentation.component.highlighting.saturation.for.hints"));
        return (float)MathUtil.clamp(result, 0, 100) * 0.01f;
    }

    @Deprecated(forRemoval=true)
    public static int getMonospaceFontSizeCorrection(boolean isForRenderedDoc) {
        if (isForRenderedDoc) {
            return SystemInfo.isWin10OrNewer && !ApplicationManager.getApplication().isUnitTestMode() ? 90 : 96;
        }
        return 100;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/documentation/DocumentationSettings", "getInlineCodeHighlightingMode"));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @ApiStatus.Experimental
    public static enum InlineCodeHighlightingMode {
        NO_HIGHLIGHTING{

            public String toString() {
                return AnalysisBundle.message("documentation.settings.inline.code.highlighting.mode.no.highlighting", new Object[0]);
            }
        }
        ,
        AS_DEFAULT_CODE{

            public String toString() {
                return AnalysisBundle.message("documentation.settings.inline.code.highlighting.mode.as.default.code", new Object[0]);
            }
        }
        ,
        SEMANTIC_HIGHLIGHTING{

            public String toString() {
                return AnalysisBundle.message("documentation.settings.inline.code.highlighting.mode.semantic.highlighting", new Object[0]);
            }
        };

    }
}

