/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl.modcommand;

import com.intellij.codeInsight.daemon.impl.actions.IntentionActionWithFixAllOption;
import com.intellij.codeInsight.intention.CustomizableIntentionAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModCommandExecutor;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.diagnostic.ReportingClassSubstitutor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class ModCommandActionWrapper
implements IntentionAction,
PriorityAction,
Iconable,
IntentionActionWithFixAllOption,
CustomizableIntentionAction,
ReportingClassSubstitutor,
PossiblyDumbAware {
    @NotNull
    private final ModCommandAction myModAction;
    @Nullable
    private Presentation myPresentation;

    public ModCommandActionWrapper(@NotNull ModCommandAction modAction, @Nullable Presentation presentation) {
        if (modAction == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(0);
        }
        this.myModAction = modAction;
        this.myPresentation = presentation;
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Override
    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myPresentation == null) {
            String string = "(not initialized) " + String.valueOf(this.myModAction.getClass());
            if (string == null) {
                ModCommandActionWrapper.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = this.myPresentation.name();
        if (string == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.myModAction.getFamilyName();
        if (string == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(6);
        }
        if (!DumbService.getInstance(project).isUsableInCurrentContext(this.myModAction)) {
            return false;
        }
        Presentation presentation = this.myModAction.getPresentation(ActionContext.from(editor, psiFile));
        if (presentation == null) {
            return false;
        }
        this.myPresentation = presentation;
        return true;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(7);
        }
        ActionContext context = ActionContext.from(editor, psiFile);
        ModCommand command2 = this.myModAction.perform(context);
        ModCommandExecutor instance2 = ModCommandExecutor.getInstance();
        if (psiFile.isPhysical()) {
            instance2.executeInteractively(context, command2, editor);
        } else {
            instance2.executeForFileCopy(command2, psiFile);
        }
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(9);
        }
        if (psiFile == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(10);
        }
        IntentionPreviewInfo intentionPreviewInfo = this.myModAction.generatePreview(ActionContext.from(editor, psiFile));
        if (intentionPreviewInfo == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(11);
        }
        return intentionPreviewInfo;
    }

    @Override
    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = this.myPresentation == null ? PriorityAction.Priority.NORMAL : this.myPresentation.priority();
        if (priority == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(12);
        }
        return priority;
    }

    @Override
    public Icon getIcon(int flags) {
        return this.myPresentation == null ? null : this.myPresentation.icon();
    }

    @Override
    @NotNull
    public List<IntentionAction> getOptions() {
        List<IntentionAction> list = this.myPresentation != null && this.myPresentation.fixAllOption() != null ? IntentionActionWithFixAllOption.super.getOptions() : List.of();
        if (list == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    public @Unmodifiable @NotNull List<CustomizableIntentionAction.RangeToHighlight> getRangesToHighlight(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(14);
        }
        if (file == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(15);
        }
        if (this.myPresentation == null) {
            List<CustomizableIntentionAction.RangeToHighlight> list = List.of();
            if (list == null) {
                ModCommandActionWrapper.$$$reportNull$$$0(16);
            }
            return list;
        }
        List<CustomizableIntentionAction.RangeToHighlight> list = ContainerUtil.map(this.myPresentation.rangesToHighlight(), range -> new CustomizableIntentionAction.RangeToHighlight(file, range.range(), range.highlightKey()));
        if (list == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Override
    public boolean belongsToMyFamily(@NotNull IntentionActionWithFixAllOption action2) {
        ModCommandAction unwrapped;
        if (action2 == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(18);
        }
        if ((unwrapped = action2.asModCommandAction()) == null || this.myPresentation == null || this.myPresentation.fixAllOption() == null) {
            return false;
        }
        return this.myPresentation.fixAllOption().belongsToMyFamily().test(unwrapped);
    }

    @Override
    @NotNull
    public String getFixAllText() {
        return this.myPresentation != null && this.myPresentation.fixAllOption() != null ? this.myPresentation.fixAllOption().name() : "";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ModCommandActionWrapper that = (ModCommandActionWrapper)obj;
        return Objects.equals(this.myModAction, that.myModAction);
    }

    public int hashCode() {
        return Objects.hash(this.myModAction);
    }

    public String toString() {
        return "ModCommandActionWrapper[action=" + String.valueOf(this.myModAction) + "]";
    }

    @Override
    @NotNull
    public ModCommandAction asModCommandAction() {
        ModCommandAction modCommandAction = this.myModAction;
        if (modCommandAction == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(19);
        }
        return modCommandAction;
    }

    @Override
    @NotNull
    public Class<?> getSubstitutedClass() {
        Class<?> clazz = ReportingClassSubstitutor.getClassToReport(this.myModAction);
        if (clazz == null) {
            ModCommandActionWrapper.$$$reportNull$$$0(20);
        }
        return clazz;
    }

    @Override
    public boolean isDumbAware() {
        return DumbService.isDumbAware(this.myModAction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 11, 12, 13, 16, 17, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/impl/modcommand/ModCommandActionWrapper";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/impl/modcommand/ModCommandActionWrapper";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangesToHighlight";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "asModCommandAction";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutedClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRangesToHighlight";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "belongsToMyFamily";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 11, 12, 13, 16, 17, 19, 20 -> new IllegalStateException(string);
        };
    }
}

