/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.messages.MessageBus;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreCommandProcessor
extends CommandProcessorEx {
    @ApiStatus.Internal
    protected static final Logger LOG = Logger.getInstance("#com.intellij.openapi.command.impl");
    protected CommandDescriptor myCurrentCommand;
    private final Stack<CommandDescriptor> myInterruptedCommands = new Stack();
    private final List<CommandListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private int myUndoTransparentCount;
    private int myAllowMergeGlobalCommandsCount = 0;
    private final CommandListener eventPublisher;

    public CoreCommandProcessor() {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        messageBus.simpleConnect().subscribe(CommandListener.TOPIC, new CommandListener(){

            @Override
            public void commandStarted(@NotNull CommandEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.commandStarted(event);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }

            @Override
            public void beforeCommandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.beforeCommandFinished(event);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }

            @Override
            public void commandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.commandFinished(event);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }

            @Override
            public void undoTransparentActionStarted() {
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.undoTransparentActionStarted();
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }

            @Override
            public void beforeUndoTransparentActionFinished() {
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.beforeUndoTransparentActionFinished();
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }

            @Override
            public void undoTransparentActionFinished() {
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.undoTransparentActionFinished();
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/command/impl/CoreCommandProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeCommandFinished";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.eventPublisher = messageBus.syncPublisher(CommandListener.TOPIC);
    }

    @Override
    public void executeCommand(Project project, @NotNull Runnable runnable, String name, Object groupId) {
        if (runnable == null) {
            CoreCommandProcessor.$$$reportNull$$$0(0);
        }
        this.executeCommand(project, runnable, name, groupId, UndoConfirmationPolicy.DEFAULT);
    }

    @Override
    public void executeCommand(Project project, @NotNull Runnable runnable, String name, Object groupId, Document document) {
        if (runnable == null) {
            CoreCommandProcessor.$$$reportNull$$$0(1);
        }
        this.executeCommand(project, runnable, name, groupId, UndoConfirmationPolicy.DEFAULT, document);
    }

    @Override
    public void executeCommand(Project project, @NotNull Runnable command2, String name, Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy) {
        if (command2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(2);
        }
        if (undoConfirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(3);
        }
        this.executeCommand(project, command2, name, groupId, undoConfirmationPolicy, null);
    }

    @Override
    public void executeCommand(Project project, @NotNull Runnable command2, String name, Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, Document document) {
        if (command2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(4);
        }
        if (undoConfirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(5);
        }
        this.executeCommand(project, command2, name, groupId, undoConfirmationPolicy, true, document);
    }

    @Override
    public void executeCommand(@Nullable Project project, @NotNull Runnable command2, @Nullable String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean shouldRecordCommandForActiveDocument) {
        if (command2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(6);
        }
        if (undoConfirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(7);
        }
        this.executeCommand(project, command2, name, groupId, undoConfirmationPolicy, shouldRecordCommandForActiveDocument, null);
    }

    @Override
    public void executeCommand(@Nullable Project project, @NotNull Runnable command2, @NlsContexts.Command @Nullable String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean shouldRecordCommandForActiveDocument, @Nullable Document document) {
        CommandDescriptor descriptor;
        if (command2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(8);
        }
        if (undoConfirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(9);
        }
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (LOG.isDebugEnabled()) {
            String currentCommandName = this.myCurrentCommand != null ? this.myCurrentCommand.myName : "<null>";
            LOG.debug("executeCommand: " + command2 + ", name = " + name + ", groupId = " + groupId + ", in command = " + currentCommandName + ", in transparent action = " + this.isUndoTransparentActionInProgress());
        }
        if (project != null && project.isDisposed()) {
            LOG.error("Project " + project + " already disposed");
            return;
        }
        if (this.myCurrentCommand != null) {
            application.runWriteIntentReadAction(() -> {
                command2.run();
                return null;
            });
            return;
        }
        this.myCurrentCommand = descriptor = new CommandDescriptor(command2, project, name, groupId, undoConfirmationPolicy, shouldRecordCommandForActiveDocument, document);
        application.runWriteIntentReadAction(() -> {
            Throwable throwable = null;
            try {
                this.fireCommandStarted();
                command2.run();
            }
            catch (Throwable th) {
                throwable = th;
                return throwable;
            }
            finally {
                Throwable finalThrowable = throwable;
                ProgressManager.getInstance().executeNonCancelableSection(() -> this.finishCommand(descriptor, finalThrowable));
                if (finalThrowable instanceof ProcessCanceledException) {
                    throw (ProcessCanceledException)finalThrowable;
                }
            }
            return null;
        });
    }

    @Override
    @Nullable
    public CommandToken startCommand(@Nullable Project project, String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy) {
        if (undoConfirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        if (project != null && project.isDisposed()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("startCommand: name = " + name + ", groupId = " + groupId);
        }
        if (this.myCurrentCommand != null) {
            return null;
        }
        Document document = groupId instanceof Document ? (Document)groupId : (groupId instanceof Ref && ((Ref)groupId).get() instanceof Document ? (Document)((Ref)groupId).get() : null);
        this.myCurrentCommand = new CommandDescriptor(EmptyRunnable.INSTANCE, project, name, groupId, undoConfirmationPolicy, true, document);
        this.fireCommandStarted();
        return this.myCurrentCommand;
    }

    @Override
    public void finishCommand(@NotNull CommandToken command2, @Nullable Throwable throwable) {
        if (command2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        LOG.assertTrue(this.myCurrentCommand != null, "no current command in progress");
        this.fireCommandFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCommandFinished() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent(this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myShouldRecordActionForActiveDocument, currentCommand.myDocument);
        CommandListener publisher = this.eventPublisher;
        try {
            publisher.beforeCommandFinished(event);
        }
        finally {
            this.myCurrentCommand = null;
            publisher.commandFinished(event);
        }
        LOG.debug("finishCommand: name = " + event.getCommandName() + ", groupId = " + event.getCommandGroupId());
    }

    @Override
    public void enterModal() {
        ThreadingAssertions.assertEventDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        this.myInterruptedCommands.push(currentCommand);
        if (currentCommand != null) {
            this.fireCommandFinished();
        }
    }

    @Override
    public void leaveModal() {
        ThreadingAssertions.assertEventDispatchThread();
        LOG.assertTrue(this.myCurrentCommand == null, "Command must not run: " + this.myCurrentCommand);
        this.myCurrentCommand = this.myInterruptedCommands.pop();
        if (this.myCurrentCommand != null) {
            this.fireCommandStarted();
        }
    }

    @Override
    public void setCurrentCommandName(String name) {
        ThreadingAssertions.assertWriteIntentReadAccess();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        LOG.assertTrue(currentCommand != null);
        currentCommand.myName = name;
    }

    @Override
    public void setCurrentCommandGroupId(Object groupId) {
        ThreadingAssertions.assertWriteIntentReadAccess();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        LOG.assertTrue(currentCommand != null);
        currentCommand.myGroupId = groupId;
    }

    @Override
    @Nullable
    public Runnable getCurrentCommand() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        return currentCommand != null ? currentCommand.myCommand : null;
    }

    @Override
    @Nullable
    public String getCurrentCommandName() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        if (currentCommand != null) {
            return currentCommand.myName;
        }
        if (!this.myInterruptedCommands.isEmpty()) {
            CommandDescriptor command2 = this.myInterruptedCommands.peek();
            return command2 != null ? command2.myName : null;
        }
        return null;
    }

    @Override
    @Nullable
    public Object getCurrentCommandGroupId() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        if (currentCommand != null) {
            return currentCommand.myGroupId;
        }
        if (!this.myInterruptedCommands.isEmpty()) {
            CommandDescriptor command2 = this.myInterruptedCommands.peek();
            return command2 != null ? command2.myGroupId : null;
        }
        return null;
    }

    @Override
    @Nullable
    public Project getCurrentCommandProject() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        return currentCommand != null ? currentCommand.myProject : null;
    }

    @Override
    public void addCommandListener(@NotNull CommandListener listener2) {
        if (listener2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(12);
        }
        this.myListeners.add(listener2);
    }

    @Override
    public void runUndoTransparentAction(@NotNull Runnable action2) {
        if (action2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(13);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("runUndoTransparentAction: " + action2 + ", in command = " + (this.myCurrentCommand != null) + ", in transparent action = " + this.isUndoTransparentActionInProgress());
        }
        if (this.myUndoTransparentCount++ == 0) {
            this.eventPublisher.undoTransparentActionStarted();
        }
        try {
            action2.run();
        }
        finally {
            if (this.myUndoTransparentCount == 1) {
                this.eventPublisher.beforeUndoTransparentActionFinished();
            }
            if (--this.myUndoTransparentCount == 0) {
                this.eventPublisher.undoTransparentActionFinished();
            }
        }
    }

    @Override
    public final AutoCloseable withUndoTransparentAction() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("withUndoTransparentAction in command = " + (this.myCurrentCommand != null) + ", in transparent action = " + this.isUndoTransparentActionInProgress());
        }
        if (this.myUndoTransparentCount++ == 0) {
            this.eventPublisher.undoTransparentActionStarted();
        }
        return () -> {
            if (this.myUndoTransparentCount == 1) {
                this.eventPublisher.beforeUndoTransparentActionFinished();
            }
            if (--this.myUndoTransparentCount == 0) {
                this.eventPublisher.undoTransparentActionFinished();
            }
        };
    }

    @Override
    public boolean isUndoTransparentActionInProgress() {
        return this.myUndoTransparentCount > 0;
    }

    @Override
    public void markCurrentCommandAsGlobal(@Nullable Project project) {
    }

    @Override
    public void addAffectedDocuments(@Nullable Project project, Document ... docs) {
        if (docs == null) {
            CoreCommandProcessor.$$$reportNull$$$0(14);
        }
    }

    @Override
    public void addAffectedFiles(@Nullable Project project, VirtualFile ... files) {
        if (files == null) {
            CoreCommandProcessor.$$$reportNull$$$0(15);
        }
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public Boolean isMergeGlobalCommandsAllowed() {
        return this.myAllowMergeGlobalCommandsCount > 0;
    }

    @Override
    @ApiStatus.Internal
    @ApiStatus.Experimental
    public AccessToken allowMergeGlobalCommands() {
        ThreadingAssertions.assertWriteIntentReadAccess();
        ++this.myAllowMergeGlobalCommandsCount;
        return new AccessToken(){

            @Override
            public void finish() {
                ThreadingAssertions.assertWriteIntentReadAccess();
                CoreCommandProcessor.this.myAllowMergeGlobalCommandsCount--;
            }
        };
    }

    @Override
    public void allowMergeGlobalCommands(@NotNull Runnable action2) {
        if (action2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(16);
        }
        try (AccessToken ignored = this.allowMergeGlobalCommands();){
            action2.run();
        }
    }

    private void fireCommandStarted() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent(this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myShouldRecordActionForActiveDocument, currentCommand.myDocument);
        this.eventPublisher.commandStarted(event);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoConfirmationPolicy";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docs";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/impl/CoreCommandProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeCommand";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "startCommand";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "finishCommand";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addCommandListener";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "runUndoTransparentAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "addAffectedDocuments";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "addAffectedFiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "allowMergeGlobalCommands";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Internal
    public static final class CommandDescriptor
    implements CommandToken {
        @NotNull
        public final Runnable myCommand;
        public final Project myProject;
        public @NlsContexts.Command String myName;
        public Object myGroupId;
        public final Document myDocument;
        @NotNull
        final UndoConfirmationPolicy myUndoConfirmationPolicy;
        final boolean myShouldRecordActionForActiveDocument;

        CommandDescriptor(@NotNull Runnable command2, Project project, @NlsContexts.Command String name, Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean shouldRecordActionForActiveDocument, Document document) {
            if (command2 == null) {
                CommandDescriptor.$$$reportNull$$$0(0);
            }
            if (undoConfirmationPolicy == null) {
                CommandDescriptor.$$$reportNull$$$0(1);
            }
            this.myCommand = command2;
            this.myProject = project;
            this.myName = name;
            this.myGroupId = groupId;
            this.myUndoConfirmationPolicy = undoConfirmationPolicy;
            this.myShouldRecordActionForActiveDocument = shouldRecordActionForActiveDocument;
            this.myDocument = document;
        }

        @Override
        public Project getProject() {
            return this.myProject;
        }

        public String toString() {
            return "'" + this.myName + "', group: '" + this.myGroupId + "'";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "command";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "undoConfirmationPolicy";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/command/impl/CoreCommandProcessor$CommandDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

