/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.PathUtilRt;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class AttachmentFactory {
    private static final Logger LOG = Logger.getInstance(AttachmentFactory.class);
    private static final long BIG_FILE_THRESHOLD_BYTES = 51200L;

    /*
     * Loose catch block
     */
    @NotNull
    public static Attachment createAttachment(@NotNull Path file, boolean isBinary) {
        Attachment attachment;
        InputStream inputStream;
        block10: {
            if (file == null) {
                AttachmentFactory.$$$reportNull$$$0(0);
            }
            inputStream = Files.newInputStream(file, new OpenOption[0]);
            attachment = AttachmentFactory.createAttachment(file.toString(), inputStream, Files.size(file), isBinary);
            if (inputStream == null) break block10;
            inputStream.close();
        }
        Attachment attachment2 = attachment;
        if (attachment2 == null) {
            AttachmentFactory.$$$reportNull$$$0(1);
        }
        return attachment2;
        {
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("failed to create an attachment from " + file, e);
                    return new Attachment(file.toString(), e);
                }
            }
        }
    }

    public static Attachment createAttachment(String path, InputStream content, long contentLength, boolean isBinary) throws IOException {
        if (contentLength >= 51200L) {
            Path tempFile = FileUtil.createTempFile("ij-attachment-" + PathUtilRt.getFileName(path) + '.', isBinary ? ".bin" : ".txt", true).toPath();
            Files.copy(content, tempFile, StandardCopyOption.REPLACE_EXISTING);
            return new Attachment(path, tempFile, "[File is too big to display]");
        }
        byte[] bytes = StreamUtil.readBytes(content);
        String displayText = isBinary ? "[File is binary]" : new String(bytes, StandardCharsets.UTF_8);
        return new Attachment(path, bytes, displayText);
    }

    @NotNull
    public static Attachment createContext(@NotNull @NonNls String context) {
        if (context == null) {
            AttachmentFactory.$$$reportNull$$$0(2);
        }
        return new Attachment("current-context.txt", !context.isEmpty() ? context : "(unknown)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/AttachmentFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/AttachmentFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAttachment";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

