/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.ex.util.DataStorage;
import com.intellij.openapi.editor.ex.util.SegmentArray;
import com.intellij.openapi.editor.ex.util.SegmentArrayWithData;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class IntBasedStorage
implements DataStorage {
    int[] myData;

    public IntBasedStorage() {
        this.myData = new int[64];
    }

    private IntBasedStorage(int[] data) {
        this.myData = data;
    }

    @Override
    public void setData(int segmentIndex, int data) {
        this.myData = SegmentArrayWithData.reallocateArray(this.myData, segmentIndex + 1);
        this.myData[segmentIndex] = data;
    }

    @Override
    public void remove(int startIndex, int endIndex, int mySegmentCount) {
        if (endIndex < mySegmentCount) {
            System.arraycopy(this.myData, endIndex, this.myData, startIndex, mySegmentCount - endIndex);
        }
    }

    @Override
    public void replace(@NotNull DataStorage storage, int startOffset, int len) {
        if (storage == null) {
            IntBasedStorage.$$$reportNull$$$0(0);
        }
        assert (storage instanceof IntBasedStorage);
        System.arraycopy(((IntBasedStorage)storage).myData, 0, this.myData, startOffset, len);
    }

    @Override
    public void insert(@NotNull DataStorage storageToInsert, int startIndex, int segmentCountToInsert, int segmentCount) {
        if (storageToInsert == null) {
            IntBasedStorage.$$$reportNull$$$0(1);
        }
        assert (storageToInsert instanceof IntBasedStorage);
        this.myData = SegmentArray.insert(this.myData, ((IntBasedStorage)storageToInsert).myData, startIndex, segmentCountToInsert, segmentCount);
    }

    @Override
    public int getData(int index) {
        return this.myData[index];
    }

    @Override
    public int packData(@NotNull IElementType tokenType, int state2, boolean isRestartableState) {
        if (tokenType == null) {
            IntBasedStorage.$$$reportNull$$$0(2);
        }
        return (state2 & 0xFFFF) << 16 | tokenType.getIndex() & 0xFFFF;
    }

    @Override
    public int unpackStateFromData(int data) {
        return data >> 16;
    }

    @Override
    @NotNull
    public IElementType unpackTokenFromData(int data) {
        IElementType iElementType = IElementType.find((short)(data & 0xFFFF));
        if (iElementType == null) {
            IntBasedStorage.$$$reportNull$$$0(3);
        }
        return iElementType;
    }

    @Override
    @NotNull
    public DataStorage copy() {
        return new IntBasedStorage(this.myData);
    }

    @Override
    @NotNull
    public DataStorage createStorage() {
        return new IntBasedStorage();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageToInsert";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/IntBasedStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/IntBasedStorage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unpackTokenFromData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "packData";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

