/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.codeInsight.multiverse.ModuleContext;
import com.intellij.codeInsight.multiverse.ProjectModelContextBridge;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.ActualCodeInsightContextInfo;
import com.intellij.psi.search.CodeInsightContextAwareSearchScope;
import com.intellij.psi.search.CodeInsightContextAwareSearchScopes;
import com.intellij.psi.search.CodeInsightContextFileInfo;
import com.intellij.psi.search.CodeInsightContextInfo;
import com.intellij.psi.search.DoesNotContainFileInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NoContextFileInfo;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.psi.search.impl.VirtualFileEnumerationAware;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSetQueue;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class ModuleWithDependentsScope
extends GlobalSearchScope
implements VirtualFileEnumerationAware,
CodeInsightContextAwareSearchScope,
ActualCodeInsightContextInfo {
    private final Set<Module> myRootModules;
    private final ProjectFileIndex myProjectFileIndex;
    private final Set<Module> myModules;
    private final Set<Module> myProductionOnTestModules;
    private static final Key<CachedValue<VirtualFileEnumeration>> CACHED_FILE_ID_ENUMERATIONS_KEY = Key.create("CACHED_FILE_ID_ENUMERATIONS");

    @VisibleForTesting
    public ModuleWithDependentsScope(@NotNull Module module) {
        if (module == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(0);
        }
        this(module.getProject(), Collections.singleton(module));
    }

    public ModuleWithDependentsScope(@NotNull Project project, @NotNull Collection<? extends Module> modules) {
        if (project == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(1);
        }
        if (modules == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(2);
        }
        super(project);
        this.myModules = new HashSet<Module>();
        this.myProductionOnTestModules = new HashSet<Module>();
        this.myRootModules = new LinkedHashSet<Module>(modules);
        this.myProjectFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        this.myModules.addAll(this.myRootModules);
        ModuleIndex index = ModuleWithDependentsScope.getModuleIndex(project);
        HashSetQueue walkingQueue = new HashSetQueue();
        walkingQueue.addAll(this.myRootModules);
        for (Module current : walkingQueue) {
            if (current.getProject() != project) {
                throw new IllegalArgumentException("All modules must belong to " + String.valueOf(project) + "; but got " + String.valueOf(current) + " from " + String.valueOf(current.getProject()));
            }
            Collection<Module> usages = index.allUsages.get(current);
            this.myModules.addAll(usages);
            walkingQueue.addAll(index.exportingUsages.get(current));
            if (this.myProductionOnTestModules.contains(current)) {
                this.myProductionOnTestModules.addAll(usages);
            }
            this.myProductionOnTestModules.addAll(index.productionOnTestUsages.get(current));
        }
    }

    @NotNull
    private static ModuleIndex getModuleIndex(@NotNull Project project) {
        if (project == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(3);
        }
        ModuleIndex moduleIndex = (ModuleIndex)CachedValuesManager.getManager(project).getCachedValue(project, () -> {
            ModuleIndex index = new ModuleIndex();
            for (Module module : ModuleManager.getInstance(project).getModules()) {
                for (OrderEntry orderEntry : ModuleRootManager.getInstance(module).getOrderEntries()) {
                    ModuleOrderEntry moduleOrderEntry;
                    Module referenced;
                    if (!(orderEntry instanceof ModuleOrderEntry) || (referenced = (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                    index.allUsages.putValue(referenced, module);
                    if (moduleOrderEntry.isExported()) {
                        index.exportingUsages.putValue(referenced, module);
                    }
                    if (!moduleOrderEntry.isProductionOnTestDependency()) continue;
                    index.productionOnTestUsages.putValue(referenced, module);
                }
            }
            return CachedValueProvider.Result.create(index, ProjectRootManager.getInstance(project));
        });
        if (moduleIndex == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(4);
        }
        return moduleIndex;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(5);
        }
        return this.contains(file, CodeInsightContexts.anyContext(), false);
    }

    @Override
    @NotNull
    public CodeInsightContextInfo getCodeInsightContextInfo() {
        ModuleWithDependentsScope moduleWithDependentsScope = this;
        if (moduleWithDependentsScope == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(6);
        }
        return moduleWithDependentsScope;
    }

    @Override
    @NotNull
    public CodeInsightContextFileInfo getFileInfo(@NotNull VirtualFile file) {
        if (file == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(7);
        }
        CodeInsightContextFileInfo codeInsightContextFileInfo = this.getFileInfo(file, false);
        if (codeInsightContextFileInfo == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(8);
        }
        return codeInsightContextFileInfo;
    }

    @NotNull
    CodeInsightContextFileInfo getFileInfo(@NotNull VirtualFile file, boolean fromTests) {
        Set<Module> modulesOfFile;
        Collection<Module> containingModulesOfScope;
        if (file == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(9);
        }
        if ((containingModulesOfScope = ContainerUtil.intersection(this.myModules, modulesOfFile = this.myProjectFileIndex.getModulesForFile(file, true))).isEmpty()) {
            DoesNotContainFileInfo doesNotContainFileInfo = CodeInsightContextAwareSearchScopes.DoesNotContainFileInfo();
            if (doesNotContainFileInfo == null) {
                ModuleWithDependentsScope.$$$reportNull$$$0(10);
            }
            return doesNotContainFileInfo;
        }
        if (fromTests) {
            Collection<Module> testModuleIntersection = ContainerUtil.intersection(containingModulesOfScope, this.myProductionOnTestModules);
            if (testModuleIntersection.isEmpty()) {
                Project project = Objects.requireNonNull(this.getProject());
                if (TestSourcesFilter.isTestSources(file, project)) {
                    NoContextFileInfo noContextFileInfo = CodeInsightContextAwareSearchScopes.NoContextFileInfo();
                    if (noContextFileInfo == null) {
                        ModuleWithDependentsScope.$$$reportNull$$$0(11);
                    }
                    return noContextFileInfo;
                }
                DoesNotContainFileInfo doesNotContainFileInfo = CodeInsightContextAwareSearchScopes.DoesNotContainFileInfo();
                if (doesNotContainFileInfo == null) {
                    ModuleWithDependentsScope.$$$reportNull$$$0(12);
                }
                return doesNotContainFileInfo;
            }
            return this.getActualContextFileInfo(testModuleIntersection);
        }
        return this.getActualContextFileInfo(containingModulesOfScope);
    }

    @NotNull
    private CodeInsightContextFileInfo getActualContextFileInfo(Collection<Module> testModuleIntersection) {
        Project project = Objects.requireNonNull(this.getProject());
        ProjectModelContextBridge bridge = ProjectModelContextBridge.getInstance(project);
        List<ModuleContext> contexts2 = ContainerUtil.mapNotNull(testModuleIntersection, m -> bridge.getContext((Module)m));
        CodeInsightContextFileInfo codeInsightContextFileInfo = CodeInsightContextAwareSearchScopes.createContainingContextFileInfo(contexts2);
        if (codeInsightContextFileInfo == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(13);
        }
        return codeInsightContextFileInfo;
    }

    @Override
    @ApiStatus.Internal
    public boolean contains(@NotNull VirtualFile file, @NotNull CodeInsightContext context) {
        if (file == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(14);
        }
        if (context == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(15);
        }
        return this.contains(file, context, false);
    }

    boolean contains(@NotNull VirtualFile file, @NotNull CodeInsightContext context, boolean fromTests) {
        Set<Module> modules;
        if (file == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(16);
        }
        if (context == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(17);
        }
        if (CodeInsightContexts.isSharedSourceSupportEnabled(Objects.requireNonNull(this.getProject()))) {
            if (context == CodeInsightContexts.anyContext()) {
                modules = this.myProjectFileIndex.getModulesForFile(file, true);
                if (modules.isEmpty()) {
                    return false;
                }
            } else {
                if (!(context instanceof ModuleContext)) {
                    return false;
                }
                ModuleContext moduleContext = (ModuleContext)context;
                Module module = moduleContext.getModule();
                if (module == null) {
                    return false;
                }
                modules = Set.of(module);
            }
        } else {
            Module module = this.myProjectFileIndex.getModuleForFile(file);
            if (module == null) {
                return false;
            }
            modules = Set.of(module);
        }
        return ContainerUtil.intersects(modules, this.myModules) && (!fromTests || ContainerUtil.intersects(modules, this.myProductionOnTestModules) || TestSourcesFilter.isTestSources(file, Objects.requireNonNull(this.getProject())));
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module module) {
        if (module == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(18);
        }
        return this.myModules.contains(module);
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }

    @Override
    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        Project project = this.getProject();
        ModuleManager moduleManager = ModuleManager.getInstance(Objects.requireNonNull(project));
        Collection collection = this.myRootModules.stream().flatMap(module -> DirectoryIndex.getInstance((Project)project).getDependentUnloadedModules(module).stream()).map(moduleManager::getUnloadedModuleDescription).filter(Objects::nonNull).collect(Collectors.toList());
        if (collection == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NonNls
    public String toString() {
        return "Modules with dependents: (roots: [" + StringUtil.join(this.myRootModules, Module::getName, ", ") + "], including dependents: [" + StringUtil.join(this.myModules, Module::getName, ", ") + "])";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleWithDependentsScope)) return false;
        ModuleWithDependentsScope moduleWithDependentsScope = (ModuleWithDependentsScope)o;
        if (!this.myModules.equals(moduleWithDependentsScope.myModules)) return false;
        return true;
    }

    @Override
    public int calcHashCode() {
        return this.myModules.hashCode();
    }

    @Override
    @Nullable
    public VirtualFileEnumeration extractFileEnumeration() {
        if (this.myModules.size() == 1) {
            Module module = this.myModules.iterator().next();
            CachedValueProvider provider = () -> {
                VirtualFile[] roots = ModuleRootManager.getInstance(module).getContentRoots();
                VirtualFileEnumeration enumeration = ModuleWithDependenciesScope.getFileEnumerationUnderRoots(List.of(roots));
                return CachedValueProvider.Result.create(enumeration, VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
            };
            CachedValuesManager cachedValuesManager = CachedValuesManager.getManager(module.getProject());
            return (VirtualFileEnumeration)cachedValuesManager.getCachedValue(module, CACHED_FILE_ID_ENUMERATIONS_KEY, provider, false);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 8, 10, 11, 12, 13, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleIndex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeInsightContextInfo";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileInfo";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualContextFileInfo";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModuleIndex";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: {
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileInfo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 8, 10, 11, 12, 13, 19 -> new IllegalStateException(string);
        };
    }

    private static final class ModuleIndex {
        final MultiMap<Module, Module> allUsages = new MultiMap();
        final MultiMap<Module, Module> exportingUsages = new MultiMap();
        final MultiMap<Module, Module> productionOnTestUsages = new MultiMap();

        private ModuleIndex() {
        }
    }
}

