/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkBridge;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.LibraryRootDescriptor;
import com.intellij.openapi.roots.impl.ModuleRootDescriptor;
import com.intellij.openapi.roots.impl.RootDescriptor;
import com.intellij.openapi.roots.impl.SdkRootDescriptor;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\f\u0010\u0018\u001a\u00020\u0016*\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/module/impl/scopes/ScopeRootDescriptor;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "orderEntry", "Lcom/intellij/openapi/roots/OrderEntry;", "orderIndex", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/roots/OrderEntry;I)V", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getOrderEntry", "()Lcom/intellij/openapi/roots/OrderEntry;", "getOrderIndex", "()I", "correspondTo", "", "rootDescriptor", "Lcom/intellij/openapi/roots/impl/RootDescriptor;", "isEqualBackup", "sdk1", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdk2", "unwrap", "intellij.platform.analysis.impl"})
public final class ScopeRootDescriptor {
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final OrderEntry orderEntry;
    private final int orderIndex;

    public ScopeRootDescriptor(@NotNull VirtualFile root, @NotNull OrderEntry orderEntry, int orderIndex) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)orderEntry, (String)"orderEntry");
        this.root = root;
        this.orderEntry = orderEntry;
        this.orderIndex = orderIndex;
    }

    @NotNull
    public final VirtualFile getRoot() {
        return this.root;
    }

    @NotNull
    public final OrderEntry getOrderEntry() {
        return this.orderEntry;
    }

    public final int getOrderIndex() {
        return this.orderIndex;
    }

    public final boolean correspondTo(@NotNull RootDescriptor rootDescriptor) {
        Intrinsics.checkNotNullParameter((Object)rootDescriptor, (String)"rootDescriptor");
        OrderEntry orderEntry = this.orderEntry;
        RootDescriptor rootDescriptor2 = rootDescriptor;
        if (rootDescriptor2 instanceof LibraryRootDescriptor) {
            if (!(orderEntry instanceof LibraryOrderEntry)) {
                return false;
            }
            Library library = ((LibraryOrderEntry)orderEntry).getLibrary();
            if (library == null) {
                return false;
            }
            Library library2 = library;
            return Intrinsics.areEqual((Object)library2, (Object)((LibraryRootDescriptor)rootDescriptor).getLibrary());
        }
        if (rootDescriptor2 instanceof ModuleRootDescriptor) {
            if (!(orderEntry instanceof ModuleSourceOrderEntry)) {
                return false;
            }
            Module module = ((ModuleSourceOrderEntry)orderEntry).getRootModel().getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
            Module module2 = module;
            return Intrinsics.areEqual((Object)module2, (Object)((ModuleRootDescriptor)rootDescriptor).getModule());
        }
        if (rootDescriptor2 instanceof SdkRootDescriptor) {
            if (!(orderEntry instanceof JdkOrderEntry)) {
                return false;
            }
            Sdk sdk = ((JdkOrderEntry)orderEntry).getJdk();
            if (sdk == null) {
                return false;
            }
            Sdk orderEntrySdk = sdk;
            Sdk rootDescriptorSdk = ((SdkRootDescriptor)rootDescriptor).getSdk();
            return Intrinsics.areEqual((Object)orderEntrySdk, (Object)rootDescriptorSdk) || this.isEqualBackup(orderEntrySdk, rootDescriptorSdk);
        }
        throw new NoWhenBranchMatchedException();
    }

    private final boolean isEqualBackup(Sdk sdk1, Sdk sdk2) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        boolean result = Intrinsics.areEqual((Object)sdk1.getHomePath(), (Object)sdk2.getHomePath()) && Intrinsics.areEqual((Object)sdk1.getName(), (Object)sdk2.getName()) && Intrinsics.areEqual((Object)sdk1.getSdkType(), (Object)sdk2.getSdkType()) && Intrinsics.areEqual(this.unwrap(sdk1).getClass(), this.unwrap(sdk2).getClass());
        return result;
    }

    private final Sdk unwrap(Sdk $this$unwrap) {
        Sdk sdk;
        if ($this$unwrap instanceof ProjectJdkImpl) {
            SdkBridge sdkBridge = ((ProjectJdkImpl)$this$unwrap).getDelegate();
            Intrinsics.checkNotNullExpressionValue((Object)sdkBridge, (String)"getDelegate(...)");
            sdk = (Sdk)sdkBridge;
        } else {
            sdk = $this$unwrap;
        }
        return sdk;
    }
}

