/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PackageIndex {
    public static PackageIndex getInstance(@NotNull Project project) {
        if (project == null) {
            PackageIndex.$$$reportNull$$$0(0);
        }
        return project.getService(PackageIndex.class);
    }

    public VirtualFile @NotNull [] getDirectoriesByPackageName(@NotNull @NlsSafe String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            PackageIndex.$$$reportNull$$$0(1);
        }
        VirtualFile[] virtualFileArray = this.getDirsByPackageName(packageName, includeLibrarySources).toArray((VirtualFile[])VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            PackageIndex.$$$reportNull$$$0(2);
        }
        return virtualFileArray;
    }

    public Query<VirtualFile> getDirsByPackageName(@NotNull @NlsSafe String packageName, @NotNull GlobalSearchScope scope) {
        if (packageName == null) {
            PackageIndex.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            PackageIndex.$$$reportNull$$$0(4);
        }
        return this.getDirsByPackageName(packageName, true).filtering(scope::contains);
    }

    @ApiStatus.Experimental
    public Query<VirtualFile> getFilesByPackageName(@NotNull @NlsSafe String packageName) {
        if (packageName == null) {
            PackageIndex.$$$reportNull$$$0(5);
        }
        return EmptyQuery.getEmptyQuery();
    }

    @NotNull
    public abstract Query<VirtualFile> getDirsByPackageName(@NotNull @NlsSafe String var1, boolean var2);

    @Nullable
    public String getPackageName(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            PackageIndex.$$$reportNull$$$0(6);
        }
        if (fileOrDir.isDirectory()) {
            return this.getPackageNameByDirectory(fileOrDir);
        }
        VirtualFile parent = fileOrDir.getParent();
        return parent == null || !parent.isDirectory() ? null : this.getPackageNameByDirectory(parent);
    }

    @Nullable
    public abstract String getPackageNameByDirectory(@NotNull VirtualFile var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/PackageIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/PackageIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesByPackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDirsByPackageName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByPackageName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

