/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.PackageDirectoryCache;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PackageDirectoryCacheImpl
implements PackageDirectoryCache {
    @NotNull
    private final @NotNull BiConsumer<? super @NotNull String, ? super @NotNull List<? super VirtualFile>> myFillDirectoriesByPackage;
    @NotNull
    private final @NotNull BiPredicate<? super @NotNull VirtualFile, ? super @NotNull String> myPackageDirectoryFilter;
    private final Map<String, PackageInfo> myDirectoriesByPackageNameCache;
    private final Set<String> myNonExistentPackages;

    public PackageDirectoryCacheImpl(@NotNull @NotNull BiConsumer<? super @NotNull String, ? super @NotNull List<? super VirtualFile>> fillFilesAndDirectoriesByPackage, @NotNull @NotNull BiPredicate<? super @NotNull VirtualFile, ? super @NotNull String> packageDirectoryFilter) {
        if (fillFilesAndDirectoriesByPackage == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(0);
        }
        if (packageDirectoryFilter == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(1);
        }
        this.myDirectoriesByPackageNameCache = new ConcurrentHashMap<String, PackageInfo>();
        this.myNonExistentPackages = ConcurrentHashMap.newKeySet();
        this.myFillDirectoriesByPackage = fillFilesAndDirectoriesByPackage;
        this.myPackageDirectoryFilter = packageDirectoryFilter;
    }

    public void clear() {
        this.myNonExistentPackages.clear();
        this.myDirectoriesByPackageNameCache.clear();
    }

    public static void addValidDirectories(@NotNull Collection<? extends VirtualFile> source, @NotNull List<? super VirtualFile> target) {
        if (source == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(2);
        }
        if (target == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(3);
        }
        for (VirtualFile virtualFile : source) {
            if (!virtualFile.isDirectory() || !virtualFile.isValid()) continue;
            target.add(virtualFile);
        }
    }

    public void onLowMemory() {
        this.myNonExistentPackages.clear();
    }

    @Override
    @NotNull
    public List<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName) {
        PackageInfo info;
        if (packageName == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(4);
        }
        List<VirtualFile> list = (info = this.getPackageInfo(packageName)) == null ? Collections.emptyList() : Collections.unmodifiableList(info.myPackageDirectories);
        if (list == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public List<VirtualFile> getFilesByPackageName(@NotNull String packageName) {
        PackageInfo info;
        if (packageName == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(6);
        }
        List<VirtualFile> list = (info = this.getPackageInfo(packageName)) == null ? Collections.emptyList() : Collections.unmodifiableList(info.myPackageFiles);
        if (list == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    private PackageInfo getPackageInfo(@NotNull String packageName) {
        PackageInfo info;
        if (packageName == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(8);
        }
        if ((info = this.myDirectoriesByPackageNameCache.get(packageName)) == null && !this.myNonExistentPackages.contains(packageName)) {
            if (packageName.length() > Registry.intValue("java.max.package.name.length", 100) || Strings.containsAnyChar(packageName, ";[/")) {
                return null;
            }
            SmartList<VirtualFile> result = new SmartList<VirtualFile>();
            if (Strings.isNotEmpty(packageName) && !StringUtil.startsWithChar(packageName, '.')) {
                int i = packageName.lastIndexOf(46);
                while (true) {
                    PackageInfo parentInfo;
                    if ((parentInfo = this.getPackageInfo(i > 0 ? packageName.substring(0, i) : "")) != null) {
                        result.addAll(parentInfo.getSubPackageDirectories(packageName.substring(i + 1)));
                    }
                    if (i < 0) break;
                    i = packageName.lastIndexOf(46, i - 1);
                    ProgressManager.checkCanceled();
                }
            }
            this.myFillDirectoriesByPackage.accept(packageName, result);
            if (!result.isEmpty()) {
                Map<Boolean, List<VirtualFile>> map2 = result.stream().collect(Collectors.partitioningBy(VirtualFile::isDirectory));
                info = new PackageInfo(packageName, map2.get(true), map2.get(false));
                this.myDirectoriesByPackageNameCache.put(packageName, info);
            } else {
                this.myNonExistentPackages.add(packageName);
            }
        }
        return info;
    }

    @Override
    @NotNull
    public Set<String> getSubpackageNames(@NotNull String packageName, @NotNull GlobalSearchScope scope) {
        PackageInfo info;
        if (packageName == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(10);
        }
        if ((info = this.getPackageInfo(packageName)) == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PackageDirectoryCacheImpl.$$$reportNull$$$0(11);
            }
            return set;
        }
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, Collection<VirtualFile>> entry : info.mySubPackages.getValue().entrySet()) {
            String shortName = entry.getKey();
            Collection<VirtualFile> directories = entry.getValue();
            if (!ContainerUtil.exists(directories, scope::contains)) continue;
            result.add(shortName);
        }
        Set<String> set = Collections.unmodifiableSet(result);
        if (set == null) {
            PackageDirectoryCacheImpl.$$$reportNull$$$0(12);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fillFilesAndDirectoriesByPackage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDirectoryFilter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/PackageDirectoryCacheImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/PackageDirectoryCacheImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesByPackageName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByPackageName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubpackageNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addValidDirectories";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByPackageName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPackageInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSubpackageNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class PackageInfo {
        @NotNull
        final String myQname;
        @NotNull
        final List<? extends VirtualFile> myPackageDirectories;
        @NotNull
        final List<? extends VirtualFile> myPackageFiles;
        final NotNullLazyValue<MultiMap<String, VirtualFile>> mySubPackages;

        PackageInfo(@NotNull String qname, @NotNull List<? extends VirtualFile> packageDirectories, List<? extends VirtualFile> packageFiles) {
            if (qname == null) {
                PackageInfo.$$$reportNull$$$0(0);
            }
            if (packageDirectories == null) {
                PackageInfo.$$$reportNull$$$0(1);
            }
            if (packageFiles == null) {
                PackageInfo.$$$reportNull$$$0(2);
            }
            this.myQname = qname;
            this.myPackageDirectories = packageDirectories;
            this.myPackageFiles = packageFiles;
            this.mySubPackages = NotNullLazyValue.volatileLazy(() -> {
                MultiMap<String, VirtualFile> result = MultiMap.createLinked();
                for (VirtualFile virtualFile : this.myPackageDirectories) {
                    ProgressManager.checkCanceled();
                    for (VirtualFile child : virtualFile.getChildren()) {
                        String packageName;
                        String childName = child.getName();
                        String string = packageName = this.myQname.isEmpty() ? childName : this.myQname + "." + childName;
                        if (!child.isDirectory() || !PackageDirectoryCacheImpl.this.myPackageDirectoryFilter.test(child, packageName)) continue;
                        result.putValue(childName, child);
                    }
                }
                return result;
            });
        }

        @NotNull
        Collection<VirtualFile> getSubPackageDirectories(String shortName) {
            Collection<VirtualFile> collection = this.mySubPackages.getValue().get(shortName);
            if (collection == null) {
                PackageInfo.$$$reportNull$$$0(3);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qname";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageDirectories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageFiles";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/PackageDirectoryCacheImpl$PackageInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/PackageDirectoryCacheImpl$PackageInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubPackageDirectories";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

