/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.vfs.impl.GenericZipFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JavaZipFileWrapper
implements GenericZipFile {
    private final ZipFile myZipFile;

    public JavaZipFileWrapper(File file) throws IOException {
        this.myZipFile = new ZipFile(file);
    }

    @Override
    public GenericZipFile.GenericZipEntry getEntry(@NotNull String entryName) throws IOException {
        ZipEntry entry;
        if (entryName == null) {
            JavaZipFileWrapper.$$$reportNull$$$0(0);
        }
        return (entry = this.myZipFile.getEntry(entryName)) != null ? new EntryWrapper(entry, this.myZipFile) : null;
    }

    @Override
    @NotNull
    public List<? extends GenericZipFile.GenericZipEntry> getEntries() {
        Enumeration<? extends ZipEntry> entries = this.myZipFile.entries();
        ArrayList<EntryWrapper> list = new ArrayList<EntryWrapper>();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            list.add(new EntryWrapper(entry, this.myZipFile));
        }
        ArrayList<EntryWrapper> arrayList = list;
        if (arrayList == null) {
            JavaZipFileWrapper.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    public void close() throws IOException {
        this.myZipFile.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/JavaZipFileWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/JavaZipFileWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEntry";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EntryWrapper
    implements GenericZipFile.GenericZipEntry {
        private final ZipEntry myEntry;
        private final ZipFile myFile;

        EntryWrapper(ZipEntry entry, ZipFile file) {
            this.myEntry = entry;
            this.myFile = file;
        }

        @Override
        public long getSize() {
            return this.myEntry.getSize();
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myEntry.getName();
            if (string == null) {
                EntryWrapper.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public long getCrc() {
            return this.myEntry.getCrc();
        }

        @Override
        public boolean isDirectory() {
            return this.myEntry.isDirectory();
        }

        @Override
        @Nullable
        public InputStream getInputStream() throws IOException {
            return this.myFile.getInputStream(this.myEntry);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/JavaZipFileWrapper$EntryWrapper", "getName"));
        }
    }
}

