/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class NewVirtualFile
extends VirtualFile
implements VirtualFileWithId {
    @Override
    public boolean isValid() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.exists();
    }

    @Override
    public byte @NotNull [] contentsToByteArray() throws IOException {
        throw new IOException("Cannot get content of " + String.valueOf(this));
    }

    @Override
    @NotNull
    public abstract NewVirtualFileSystem getFileSystem();

    @Override
    public abstract NewVirtualFile getParent();

    @Override
    @Nullable
    public abstract NewVirtualFile getCanonicalFile();

    @Override
    @Nullable
    public abstract NewVirtualFile findChild(@NotNull @NonNls String var1);

    @Nullable
    public abstract NewVirtualFile refreshAndFindChild(@NotNull String var1);

    @Nullable
    public abstract NewVirtualFile findChildIfCached(@NotNull String var1);

    public abstract void setTimeStamp(long var1) throws IOException;

    @Override
    @NotNull
    public abstract CharSequence getNameSequence();

    @Override
    public abstract int getId();

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        RefreshQueue.getInstance().refresh(asynchronous, recursive, postRunnable, this);
    }

    @Override
    public abstract void setWritable(boolean var1) throws IOException;

    public abstract void markDirty();

    public abstract void markDirtyRecursively();

    public abstract boolean isDirty();

    @ApiStatus.Experimental
    public abstract boolean isOffline();

    @ApiStatus.Experimental
    public abstract void setOffline(boolean var1);

    public abstract void markClean();

    @Override
    public void move(Object requestor, @NotNull VirtualFile newParent) throws IOException {
        if (newParent == null) {
            NewVirtualFile.$$$reportNull$$$0(0);
        }
        if (!this.exists()) {
            throw new IOException("File to move does not exist: " + this.getPath());
        }
        if (!newParent.exists()) {
            throw new IOException("Destination folder does not exist: " + newParent.getPath());
        }
        if (!newParent.isDirectory()) {
            throw new IOException("Destination is not a folder: " + newParent.getPath());
        }
        VirtualFile child = newParent.findChild(this.getName());
        if (child != null) {
            throw new IOException("Destination already exists: " + newParent.getPath() + "/" + this.getName());
        }
        EncodingRegistry.doActionAndRestoreEncoding(this, () -> {
            this.getFileSystem().moveFile(requestor, this, newParent);
            return this;
        });
    }

    @NotNull
    public abstract @Unmodifiable Collection<VirtualFile> getCachedChildren();

    @NotNull
    public abstract @Unmodifiable Iterable<VirtualFile> iterInDbChildren();

    @ApiStatus.Internal
    @NotNull
    public @Unmodifiable Iterable<VirtualFile> iterInDbChildrenWithoutLoadingVfsFromOtherProjects() {
        Iterable<VirtualFile> iterable = this.iterInDbChildren();
        if (iterable == null) {
            NewVirtualFile.$$$reportNull$$$0(1);
        }
        return iterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/NewVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/NewVirtualFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "iterInDbChildrenWithoutLoadingVfsFromOtherProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

