/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.psi;

import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.Pair;
import com.intellij.platform.syntax.LanguageSyntaxDefinition;
import com.intellij.platform.syntax.lexer.Lexer;
import com.intellij.platform.syntax.lexer.TokenList;
import com.intellij.platform.syntax.psi.DefaultWhitespaceOrCommentPolicy;
import com.intellij.platform.syntax.psi.ElementTypeConverter;
import com.intellij.platform.syntax.psi.ElementTypeConverters;
import com.intellij.platform.syntax.psi.LanguageSyntaxDefinitions;
import com.intellij.platform.syntax.psi.PsiSyntaxBuilder;
import com.intellij.platform.syntax.psi.impl.LazyParseableToken;
import com.intellij.platform.syntax.psi.impl.LexingKt;
import com.intellij.platform.syntax.psi.impl.PsiSyntaxBuilderImpl;
import com.intellij.platform.syntax.psi.impl.PsiSyntaxBuilderImplKt;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000e2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/syntax/psi/PsiSyntaxBuilderFactory;", "", "<init>", "()V", "createBuilder", "Lcom/intellij/platform/syntax/psi/PsiSyntaxBuilder;", "chameleon", "Lcom/intellij/lang/ASTNode;", "lexer", "Lcom/intellij/platform/syntax/lexer/Lexer;", "lang", "Lcom/intellij/lang/Language;", "text", "", "Lcom/intellij/lang/LighterLazyParseableNode;", "getParserDefinition", "Lcom/intellij/lang/ParserDefinition;", "language", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "getConverter", "Lcom/intellij/platform/syntax/psi/ElementTypeConverter;", "Companion", "intellij.platform.syntax.psi"})
public final class PsiSyntaxBuilderFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final PsiSyntaxBuilder createBuilder(@NotNull ASTNode chameleon, @Nullable Lexer lexer, @NotNull Language lang, @NotNull CharSequence text) {
        ParserDefinition parserDefinition = this.getParserDefinition(lang, chameleon.getElementType());
        ElementTypeConverter tokenConverter = this.getConverter(lang, chameleon.getElementType());
        LanguageSyntaxDefinition languageSyntaxDefinition = (LanguageSyntaxDefinition)LanguageSyntaxDefinitions.Companion.getINSTANCE().forLanguage(lang);
        if (languageSyntaxDefinition == null) {
            throw new IllegalStateException("No SyntaxDefinition for language: " + lang);
        }
        LanguageSyntaxDefinition syntaxDefinition = languageSyntaxDefinition;
        Lexer lexer2 = lexer;
        if (lexer2 == null) {
            lexer2 = syntaxDefinition.getLexer();
        }
        Lexer actualLexer = lexer2;
        TokenList cachedLexemes = PsiSyntaxBuilderImplKt.extractCachedLexemes(chameleon);
        TokenList lexingResult = LexingKt.performLexingIfNecessary(cachedLexemes, actualLexer, text, lang);
        PsiFile psiFile = SharedImplUtil.getContainingFile(chameleon);
        CharTable charTable = SharedImplUtil.findCharTableByTree(chameleon);
        ASTNode aSTNode = Pair.getFirst(chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED));
        CharSequence charSequence = Pair.getSecond(chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED));
        DefaultWhitespaceOrCommentPolicy defaultWhitespaceOrCommentPolicy = new DefaultWhitespaceOrCommentPolicy(tokenConverter);
        return new PsiSyntaxBuilderImpl(psiFile, parserDefinition, syntaxDefinition, charTable, text, aSTNode, charSequence, null, 0, lexingResult, tokenConverter, null, defaultWhitespaceOrCommentPolicy);
    }

    public static /* synthetic */ PsiSyntaxBuilder createBuilder$default(PsiSyntaxBuilderFactory psiSyntaxBuilderFactory, ASTNode aSTNode, Lexer lexer, Language language, CharSequence charSequence, int n, Object object) {
        if ((n & 2) != 0) {
            lexer = null;
        }
        if ((n & 4) != 0) {
            language = aSTNode.getElementType().getLanguage();
        }
        if ((n & 8) != 0) {
            charSequence = aSTNode.getChars();
        }
        return psiSyntaxBuilderFactory.createBuilder(aSTNode, lexer, language, charSequence);
    }

    @NotNull
    public final PsiSyntaxBuilder createBuilder(@NotNull LighterLazyParseableNode chameleon, @Nullable Lexer lexer, @NotNull Language lang, @NotNull CharSequence text) {
        ParserDefinition parserDefinition = this.getParserDefinition(null, chameleon.getTokenType());
        ElementTypeConverter tokenConverter = this.getConverter(lang, chameleon.getTokenType());
        LanguageSyntaxDefinition languageSyntaxDefinition = (LanguageSyntaxDefinition)LanguageSyntaxDefinitions.Companion.getINSTANCE().forLanguage(lang);
        Lexer lexer2 = lexer;
        if (lexer2 == null) {
            lexer2 = languageSyntaxDefinition.getLexer();
        }
        Lexer actualLexer = lexer2;
        TokenList cachedLexemes = PsiSyntaxBuilderImplKt.extractCachedLexemes(chameleon);
        TokenList lexingResult = LexingKt.performLexingIfNecessary(cachedLexemes, actualLexer, text, lang);
        PsiFile psiFile = chameleon.getContainingFile();
        CharTable charTable = chameleon.getCharTable();
        Intrinsics.checkNotNull((Object)chameleon, (String)"null cannot be cast to non-null type com.intellij.platform.syntax.psi.impl.LazyParseableToken");
        return new PsiSyntaxBuilderImpl(psiFile, parserDefinition, languageSyntaxDefinition, charTable, text, null, null, ((LazyParseableToken)chameleon).getParentStructure(), ((LazyParseableToken)chameleon).getStartOffset(), lexingResult, tokenConverter, null, new DefaultWhitespaceOrCommentPolicy(tokenConverter));
    }

    public static /* synthetic */ PsiSyntaxBuilder createBuilder$default(PsiSyntaxBuilderFactory psiSyntaxBuilderFactory, LighterLazyParseableNode lighterLazyParseableNode, Lexer lexer, Language language, CharSequence charSequence, int n, Object object) {
        if ((n & 2) != 0) {
            lexer = null;
        }
        if ((n & 4) != 0) {
            language = lighterLazyParseableNode.getTokenType().getLanguage();
        }
        if ((n & 8) != 0) {
            charSequence = lighterLazyParseableNode.getText();
        }
        return psiSyntaxBuilderFactory.createBuilder(lighterLazyParseableNode, lexer, language, charSequence);
    }

    private final ParserDefinition getParserDefinition(Language language, IElementType tokenType) {
        Language adjusted;
        ParserDefinition parserDefinition;
        Language language2 = language;
        if (language2 == null) {
            language2 = tokenType.getLanguage();
        }
        if ((parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(adjusted = language2)) == null) {
            throw new AssertionError((Object)("ParserDefinition absent for language: '" + adjusted.getID() + "' (" + adjusted.getClass().getName() + "), for elementType: '" + tokenType.getDebugName() + "' (" + tokenType.getClass().getName() + ')'));
        }
        return parserDefinition;
    }

    private final ElementTypeConverter getConverter(Language language, IElementType tokenType) {
        Language language2 = language;
        if (language2 == null) {
            language2 = tokenType.getLanguage();
        }
        Language adjusted = language2;
        return ElementTypeConverters.getConverter(adjusted);
    }

    @JvmStatic
    @NotNull
    public static final PsiSyntaxBuilderFactory getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/syntax/psi/PsiSyntaxBuilderFactory$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/syntax/psi/PsiSyntaxBuilderFactory;", "intellij.platform.syntax.psi"})
    @SourceDebugExtension(value={"SMAP\nPsiSyntaxBuilderFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiSyntaxBuilderFactory.kt\ncom/intellij/platform/syntax/psi/PsiSyntaxBuilderFactory$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,105:1\n40#2,3:106\n*S KotlinDebug\n*F\n+ 1 PsiSyntaxBuilderFactory.kt\ncom/intellij/platform/syntax/psi/PsiSyntaxBuilderFactory$Companion\n*L\n96#1:106,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PsiSyntaxBuilderFactory getInstance() {
            boolean $i$f$service = false;
            Class<PsiSyntaxBuilderFactory> serviceClass$iv = PsiSyntaxBuilderFactory.class;
            PsiSyntaxBuilderFactory psiSyntaxBuilderFactory = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (psiSyntaxBuilderFactory == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return psiSyntaxBuilderFactory;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

