/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.bridge.impl.library;

import com.intellij.platform.workspace.jps.bridge.impl.library.JpsLibraryBridge;
import com.intellij.platform.workspace.jps.bridge.impl.library.JpsLibraryBridgeBase;
import com.intellij.platform.workspace.jps.bridge.impl.library.JpsLibraryRootTypesKt;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/workspace/jps/bridge/impl/library/JpsLibraryRootBridge;", "Lorg/jetbrains/jps/model/ex/JpsElementBase;", "Lorg/jetbrains/jps/model/library/JpsLibraryRoot;", "libraryRoot", "Lcom/intellij/platform/workspace/jps/entities/LibraryRoot;", "parentElement", "Lcom/intellij/platform/workspace/jps/bridge/impl/library/JpsLibraryBridgeBase;", "<init>", "(Lcom/intellij/platform/workspace/jps/entities/LibraryRoot;Lcom/intellij/platform/workspace/jps/bridge/impl/library/JpsLibraryBridgeBase;)V", "getRootType", "Lorg/jetbrains/jps/model/library/JpsOrderRootType;", "getUrl", "", "getInclusionOptions", "Lorg/jetbrains/jps/model/library/JpsLibraryRoot$InclusionOptions;", "getLibrary", "Lorg/jetbrains/jps/model/library/JpsLibrary;", "intellij.platform.workspace.jps"})
public final class JpsLibraryRootBridge
extends JpsElementBase<JpsLibraryRootBridge>
implements JpsLibraryRoot {
    @NotNull
    private final LibraryRoot libraryRoot;

    public JpsLibraryRootBridge(@NotNull LibraryRoot libraryRoot, @NotNull JpsLibraryBridgeBase<?> parentElement) {
        Intrinsics.checkNotNullParameter((Object)libraryRoot, (String)"libraryRoot");
        Intrinsics.checkNotNullParameter(parentElement, (String)"parentElement");
        this.libraryRoot = libraryRoot;
        this.setParent((JpsElementBase)parentElement);
    }

    @Override
    @NotNull
    public JpsOrderRootType getRootType() {
        return JpsLibraryRootTypesKt.asJpsOrderRootType(this.libraryRoot.getType());
    }

    @Override
    @NotNull
    public String getUrl() {
        String string = this.libraryRoot.getUrl().getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        return string;
    }

    @Override
    @NotNull
    public JpsLibraryRoot.InclusionOptions getInclusionOptions() {
        JpsLibraryRoot.InclusionOptions inclusionOptions;
        switch (WhenMappings.$EnumSwitchMapping$0[this.libraryRoot.getInclusionOptions().ordinal()]) {
            case 1: {
                inclusionOptions = JpsLibraryRoot.InclusionOptions.ROOT_ITSELF;
                break;
            }
            case 2: {
                inclusionOptions = JpsLibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT;
                break;
            }
            case 3: {
                inclusionOptions = JpsLibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT_RECURSIVELY;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return inclusionOptions;
    }

    @Override
    @NotNull
    public JpsLibrary getLibrary() {
        JpsElementBase jpsElementBase = this.getParent();
        Intrinsics.checkNotNull((Object)jpsElementBase, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.jps.bridge.impl.library.JpsLibraryBridge");
        return (JpsLibraryBridge)jpsElementBase;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LibraryRoot.InclusionOptions.values().length];
            try {
                nArray[LibraryRoot.InclusionOptions.ROOT_ITSELF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT_RECURSIVELY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

