/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.bridge.impl.serialization;

import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.platform.workspace.jps.bridge.impl.serialization.DefaultImlNormalizer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsComponentLoader;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.model.serialization.JpsProjectConfigurationLoading;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ$\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u0007H\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0007H\u0002R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/intellij/platform/workspace/jps/bridge/impl/serialization/ProjectDirectJpsFileContentReader;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentReader;", "projectBaseDir", "Ljava/nio/file/Path;", "externalConfigurationDirectory", "pathVariables", "", "", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/util/Map;)V", "getExternalConfigurationDirectory", "()Ljava/nio/file/Path;", "projectMacroExpander", "Lorg/jetbrains/jps/model/serialization/JpsMacroExpander;", "kotlin.jvm.PlatformType", "moduleLoadersCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/jps/model/serialization/JpsComponentLoader;", "projectComponentLoader", "getProjectComponentLoader", "()Lorg/jetbrains/jps/model/serialization/JpsComponentLoader;", "loadComponent", "Lorg/jdom/Element;", "fileUrl", "componentName", "customModuleFilePath", "loadProjectLevelComponent", "getExpandMacroMap", "Lcom/intellij/openapi/components/ExpandMacroToPathMap;", "getModuleLoader", "imlFileUrl", "intellij.platform.workspace.jps"})
public final class ProjectDirectJpsFileContentReader
implements JpsFileContentReader {
    @Nullable
    private final Path externalConfigurationDirectory;
    @NotNull
    private final Map<String, String> pathVariables;
    private final JpsMacroExpander projectMacroExpander;
    @NotNull
    private final ConcurrentHashMap<String, JpsComponentLoader> moduleLoadersCache;
    @NotNull
    private final JpsComponentLoader projectComponentLoader;

    public ProjectDirectJpsFileContentReader(@NotNull Path projectBaseDir, @Nullable Path externalConfigurationDirectory, @NotNull Map<String, String> pathVariables) {
        Intrinsics.checkNotNullParameter((Object)projectBaseDir, (String)"projectBaseDir");
        Intrinsics.checkNotNullParameter(pathVariables, (String)"pathVariables");
        this.externalConfigurationDirectory = externalConfigurationDirectory;
        this.pathVariables = pathVariables;
        this.projectMacroExpander = JpsProjectConfigurationLoading.createProjectMacroExpander(this.pathVariables, projectBaseDir);
        this.moduleLoadersCache = new ConcurrentHashMap();
        this.projectComponentLoader = new JpsComponentLoader(this.projectMacroExpander, this.externalConfigurationDirectory, true);
    }

    @Nullable
    public final Path getExternalConfigurationDirectory() {
        return this.externalConfigurationDirectory;
    }

    @NotNull
    public final JpsComponentLoader getProjectComponentLoader() {
        return this.projectComponentLoader;
    }

    @Override
    @Nullable
    public Element loadComponent(@NotNull String fileUrl, @NotNull String componentName, @Nullable String customModuleFilePath) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        if (StringsKt.endsWith$default((String)fileUrl, (String)".iml", (boolean)false, (int)2, null)) {
            JpsComponentLoader loader = this.getModuleLoader(fileUrl);
            String string = JpsPathUtil.urlToPath(fileUrl);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlToPath(...)");
            Path path = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Element rootElement = loader.loadRootElement(path);
            if (Intrinsics.areEqual((Object)componentName, (Object)"DeprecatedModuleOptionManager")) {
                return DefaultImlNormalizer.INSTANCE.createDeprecatedModuleOptionManager(rootElement);
            }
            return JDomSerializationUtil.findComponent(rootElement, componentName);
        }
        return this.loadProjectLevelComponent(fileUrl, componentName);
    }

    private final Element loadProjectLevelComponent(String fileUrl, String componentName) {
        String string = JpsPathUtil.urlToPath(fileUrl);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlToPath(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Element element = this.projectComponentLoader.loadRootElement(path);
        if (element == null) {
            return null;
        }
        Element rootElement = element;
        if (Intrinsics.areEqual((Object)rootElement.getName(), (Object)"component") && JDomSerializationUtil.isComponent(componentName, rootElement)) {
            return rootElement;
        }
        return JDomSerializationUtil.findComponent(rootElement, componentName);
    }

    @Override
    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        if (StringsKt.endsWith$default((String)fileUrl, (String)".iml", (boolean)false, (int)2, null)) {
            ExpandMacroToPathMap expandMacroToPathMap = this.getModuleLoader(fileUrl).getMacroExpander().getExpandMacroMap();
            Intrinsics.checkNotNullExpressionValue((Object)expandMacroToPathMap, (String)"getExpandMacroMap(...)");
            return expandMacroToPathMap;
        }
        ExpandMacroToPathMap expandMacroToPathMap = this.projectMacroExpander.getExpandMacroMap();
        Intrinsics.checkNotNullExpressionValue((Object)expandMacroToPathMap, (String)"getExpandMacroMap(...)");
        return expandMacroToPathMap;
    }

    private final JpsComponentLoader getModuleLoader(String imlFileUrl) {
        JpsComponentLoader jpsComponentLoader = this.moduleLoadersCache.get(imlFileUrl);
        if (jpsComponentLoader != null) {
            JpsComponentLoader it = jpsComponentLoader;
            boolean bl = false;
            return it;
        }
        String string = JpsPathUtil.urlToPath(imlFileUrl);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlToPath(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path moduleFile = path;
        JpsMacroExpander macroExpander = JpsProjectConfigurationLoading.createModuleMacroExpander(this.pathVariables, moduleFile);
        JpsComponentLoader loader = new JpsComponentLoader(macroExpander, null, true);
        ((Map)this.moduleLoadersCache).put(imlFileUrl, loader);
        return loader;
    }
}

