/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.entities.ExternalSystemModuleOptionsEntity;
import com.intellij.platform.workspace.jps.entities.ModuleCustomImlDataEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.serialization.SerializationContext;
import com.intellij.platform.workspace.jps.serialization.impl.ErrorReporter;
import com.intellij.platform.workspace.jps.serialization.impl.ExternalModuleImlFileEntitiesSerializerKt;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentReader;
import com.intellij.platform.workspace.jps.serialization.impl.JpsModuleListSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.LoadingResult;
import com.intellij.platform.workspace.jps.serialization.impl.ModuleImlFileEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.ModulePath;
import com.intellij.platform.workspace.jps.serialization.impl.WritableJpsFileContent;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJH\u0010\u0016\u001a*\u0012&\u0012$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u001c0\u001b0\u00180\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0014JF\u0010&\u001a \u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00130'2\u0006\u0010(\u001a\u00020)2\u0016\u0010*\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0018H\u0014JB\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010(\u001a\u00020)2\u0016\u0010/\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00182\b\u00100\u001a\u0004\u0018\u00010\u00132\u0006\u0010$\u001a\u00020%H\u0014J.\u00101\u001a\u00020,2\b\u0010/\u001a\u0004\u0018\u0001022\b\u00103\u001a\u0004\u0018\u00010\u00132\b\u00104\u001a\u0004\u0018\u0001052\u0006\u0010(\u001a\u000206H\u0014J\u0010\u00107\u001a\u0002082\u0006\u00100\u001a\u00020\u0013H\u0014J\b\u00109\u001a\u00020\u0013H\u0014J\b\u0010:\u001a\u00020\u0013H\u0016R\u0014\u0010\u000e\u001a\u00020\u000fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006;"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/ExternalModuleImlFileEntitiesSerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/ModuleImlFileEntitiesSerializer;", "modulePath", "Lcom/intellij/platform/workspace/jps/serialization/impl/ModulePath;", "fileUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "context", "Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;", "internalEntitySource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "internalModuleListSerializer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsModuleListSerializer;", "<init>", "(Lcom/intellij/platform/workspace/jps/serialization/impl/ModulePath;Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;Lcom/intellij/platform/workspace/jps/serialization/impl/JpsModuleListSerializer;)V", "externalStorage", "", "getExternalStorage", "()Z", "facetManagerComponentName", "", "getFacetManagerComponentName", "()Ljava/lang/String;", "loadEntities", "Lcom/intellij/platform/workspace/jps/serialization/impl/LoadingResult;", "", "Ljava/lang/Class;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity$Builder;", "reader", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentReader;", "errorReporter", "Lcom/intellij/platform/workspace/jps/serialization/impl/ErrorReporter;", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "acceptsSource", "entitySource", "Lcom/intellij/platform/workspace/storage/EntitySource;", "readExternalSystemOptions", "Lkotlin/Pair;", "content", "Lcom/intellij/platform/workspace/jps/serialization/impl/ModuleImlFileEntitiesSerializer$JpsFileContent;", "moduleOptions", "loadExternalSystemOptions", "", "module", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity$Builder;", "externalSystemOptions", "externalSystemId", "saveModuleOptions", "Lcom/intellij/platform/workspace/jps/entities/ExternalSystemModuleOptionsEntity;", "moduleType", "customImlData", "Lcom/intellij/platform/workspace/jps/entities/ModuleCustomImlDataEntity;", "Lcom/intellij/platform/workspace/jps/serialization/impl/WritableJpsFileContent;", "createExternalEntitySource", "Lcom/intellij/platform/workspace/jps/JpsImportedEntitySource;", "getBaseDirPath", "toString", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nExternalModuleImlFileEntitiesSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalModuleImlFileEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/ExternalModuleImlFileEntitiesSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,165:1\n1222#2,2:166\n1252#2,4:168\n14#3:172\n216#4,2:173\n*S KotlinDebug\n*F\n+ 1 ExternalModuleImlFileEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/ExternalModuleImlFileEntitiesSerializer\n*L\n51#1:166,2\n51#1:168,4\n79#1:172\n103#1:173,2\n*E\n"})
public final class ExternalModuleImlFileEntitiesSerializer
extends ModuleImlFileEntitiesSerializer {
    private final boolean externalStorage;
    @NotNull
    private final String facetManagerComponentName;

    public ExternalModuleImlFileEntitiesSerializer(@NotNull ModulePath modulePath, @NotNull VirtualFileUrl fileUrl, @NotNull SerializationContext context, @NotNull JpsFileEntitySource internalEntitySource, @NotNull JpsModuleListSerializer internalModuleListSerializer) {
        Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)internalEntitySource, (String)"internalEntitySource");
        Intrinsics.checkNotNullParameter((Object)internalModuleListSerializer, (String)"internalModuleListSerializer");
        super(modulePath, fileUrl, internalEntitySource, context, internalModuleListSerializer, null, 32, null);
        this.externalStorage = true;
        this.facetManagerComponentName = "ExternalFacetManager";
    }

    @Override
    protected boolean getExternalStorage() {
        return this.externalStorage;
    }

    @Override
    @NotNull
    protected String getFacetManagerComponentName() {
        return this.facetManagerComponentName;
    }

    @Override
    @NotNull
    public LoadingResult<Map<Class<? extends WorkspaceEntity>, Collection<WorkspaceEntity.Builder<? extends WorkspaceEntity>>>> loadEntities(@NotNull JpsFileContentReader reader, @NotNull ErrorReporter errorReporter, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        return new LoadingResult<Map<Class<? extends WorkspaceEntity>, Collection<WorkspaceEntity.Builder<? extends WorkspaceEntity>>>>(MapsKt.emptyMap(), null);
    }

    @Override
    protected boolean acceptsSource(@NotNull EntitySource entitySource) {
        Intrinsics.checkNotNullParameter((Object)entitySource, (String)"entitySource");
        return entitySource instanceof JpsImportedEntitySource && ((JpsImportedEntitySource)entitySource).getStoredExternally();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Pair<Map<String, String>, String> readExternalSystemOptions(@NotNull ModuleImlFileEntitiesSerializer.JpsFileContent content, @NotNull Map<String, String> moduleOptions) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(moduleOptions, (String)"moduleOptions");
        Element element = content.loadComponent("ExternalSystem");
        if (element == null) {
            return new Pair((Object)MapsKt.emptyMap(), null);
        }
        Element componentTag2 = element;
        List<Attribute> list = componentTag2.getAttributes();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAttributes(...)");
        Iterable $this$associateBy$iv = list;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Attribute attribute = (Attribute)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Attribute it = (Attribute)element$iv$iv;
            String string = it.getName();
            boolean bl2 = false;
            String string2 = it.getValue();
            map2.put(string, string2);
        }
        Map options = destination$iv$iv;
        return new Pair((Object)options, options.get("externalSystem"));
    }

    @Override
    protected void loadExternalSystemOptions(@NotNull ModuleEntity.Builder module, @NotNull ModuleImlFileEntitiesSerializer.JpsFileContent content, @NotNull Map<String, String> externalSystemOptions, @Nullable String externalSystemId, @NotNull EntitySource entitySource) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(externalSystemOptions, (String)"externalSystemOptions");
        Intrinsics.checkNotNullParameter((Object)entitySource, (String)"entitySource");
        if (!this.shouldCreateExternalSystemModuleOptions$intellij_platform_workspace_jps(externalSystemId, externalSystemOptions, ExternalModuleImlFileEntitiesSerializerKt.access$getMODULE_OPTIONS_TO_CHECK$p())) {
            return;
        }
        ExternalSystemModuleOptionsEntity.Companion.create(entitySource, (Function1<? super ExternalSystemModuleOptionsEntity.Builder, Unit>)((Function1)arg_0 -> ExternalModuleImlFileEntitiesSerializer.loadExternalSystemOptions$lambda$2(module, externalSystemId, externalSystemOptions, arg_0)));
    }

    @Override
    protected void saveModuleOptions(@Nullable ExternalSystemModuleOptionsEntity externalSystemOptions, @Nullable String moduleType, @Nullable ModuleCustomImlDataEntity customImlData, @NotNull WritableJpsFileContent content) {
        block8: {
            Object object;
            block7: {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                String fileUrlString = this.getFileUrl().getUrl();
                if (FileUtil.extensionEquals(fileUrlString, "iml")) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(ExternalModuleImlFileEntitiesSerializer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("External serializer should not write to iml files. Path:" + fileUrlString);
                }
                if (externalSystemOptions != null) {
                    Element componentTag2 = JDomSerializationUtil.createComponentElement("ExternalSystem");
                    ExternalModuleImlFileEntitiesSerializer.saveModuleOptions$saveOption(componentTag2, "externalSystem", externalSystemOptions.getExternalSystem());
                    ExternalModuleImlFileEntitiesSerializer.saveModuleOptions$saveOption(componentTag2, "externalSystemModuleGroup", externalSystemOptions.getExternalSystemModuleGroup());
                    ExternalModuleImlFileEntitiesSerializer.saveModuleOptions$saveOption(componentTag2, "externalSystemModuleType", externalSystemOptions.getExternalSystemModuleType());
                    ExternalModuleImlFileEntitiesSerializer.saveModuleOptions$saveOption(componentTag2, "externalSystemModuleVersion", externalSystemOptions.getExternalSystemModuleVersion());
                    ExternalModuleImlFileEntitiesSerializer.saveModuleOptions$saveOption(componentTag2, "linkedProjectId", externalSystemOptions.getLinkedProjectId());
                    ExternalModuleImlFileEntitiesSerializer.saveModuleOptions$saveOption(componentTag2, "linkedProjectPath", externalSystemOptions.getLinkedProjectPath());
                    ExternalModuleImlFileEntitiesSerializer.saveModuleOptions$saveOption(componentTag2, "rootProjectPath", externalSystemOptions.getRootProjectPath());
                    content.saveComponent("ExternalSystem", componentTag2);
                }
                if (moduleType != null) break block7;
                ModuleCustomImlDataEntity moduleCustomImlDataEntity = customImlData;
                Map<String, String> componentTag2 = moduleCustomImlDataEntity != null ? moduleCustomImlDataEntity.getCustomModuleOptions() : null;
                if (componentTag2 == null || componentTag2.isEmpty()) break block8;
            }
            Element componentTag3 = JDomSerializationUtil.createComponentElement("DeprecatedModuleOptionManager");
            if (moduleType != null) {
                componentTag3.addContent(new Element("option").setAttribute("key", "type").setAttribute("value", moduleType));
            }
            if ((object = customImlData) != null && (object = object.getCustomModuleOptions()) != null) {
                Object $this$forEach$iv = object;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator2.next();
                    boolean bl = false;
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    componentTag3.addContent(new Element("option").setAttribute("key", key).setAttribute("value", value));
                }
            }
            content.saveComponent("DeprecatedModuleOptionManager", componentTag3);
        }
    }

    @Override
    @NotNull
    protected JpsImportedEntitySource createExternalEntitySource(@NotNull String externalSystemId) {
        Intrinsics.checkNotNullParameter((Object)externalSystemId, (String)"externalSystemId");
        return new JpsImportedEntitySource(this.getInternalEntitySource(), externalSystemId, true);
    }

    @Override
    @NotNull
    protected String getBaseDirPath() {
        return this.getModulePath$intellij_platform_workspace_jps().getPath();
    }

    @Override
    @NotNull
    public String toString() {
        return "ExternalModuleImlFileEntitiesSerializer(" + this.getFileUrl() + ")";
    }

    private static final Unit loadExternalSystemOptions$lambda$2(ModuleEntity.Builder $module, String $externalSystemId, Map $externalSystemOptions, ExternalSystemModuleOptionsEntity.Builder $this$ExternalSystemModuleOptionsEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$ExternalSystemModuleOptionsEntity, (String)"$this$ExternalSystemModuleOptionsEntity");
        $this$ExternalSystemModuleOptionsEntity.setModule($module);
        $this$ExternalSystemModuleOptionsEntity.setExternalSystem($externalSystemId);
        $this$ExternalSystemModuleOptionsEntity.setExternalSystemModuleVersion((String)$externalSystemOptions.get("externalSystemModuleVersion"));
        $this$ExternalSystemModuleOptionsEntity.setLinkedProjectPath((String)$externalSystemOptions.get("linkedProjectPath"));
        $this$ExternalSystemModuleOptionsEntity.setLinkedProjectId((String)$externalSystemOptions.get("linkedProjectId"));
        $this$ExternalSystemModuleOptionsEntity.setRootProjectPath((String)$externalSystemOptions.get("rootProjectPath"));
        $this$ExternalSystemModuleOptionsEntity.setExternalSystemModuleGroup((String)$externalSystemOptions.get("externalSystemModuleGroup"));
        $this$ExternalSystemModuleOptionsEntity.setExternalSystemModuleType((String)$externalSystemOptions.get("externalSystemModuleType"));
        return Unit.INSTANCE;
    }

    private static final void saveModuleOptions$saveOption(Element componentTag2, String name, String value) {
        if (value != null) {
            componentTag2.setAttribute(name, value);
        }
    }
}

