/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.platform.workspace.storage.CachedValue;
import com.intellij.platform.workspace.storage.CachedValueWithParameter;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.VersionedEntityStorage;
import com.intellij.platform.workspace.storage.impl.StorageSnapshotCache;
import com.intellij.platform.workspace.storage.impl.ValuesCache;
import com.intellij.platform.workspace.storage.instrumentation.EntityStorageInstrumentationKt;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ5\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u00190\u001e2\u0006\u0010\u001f\u001a\u0002H\u001dH\u0016\u00a2\u0006\u0002\u0010 J\u001c\u0010!\u001a\u00020\"\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0016J5\u0010!\u001a\u00020\"\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u00190\u001e2\u0006\u0010\u001f\u001a\u0002H\u001dH\u0016\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lcom/intellij/platform/workspace/storage/impl/VersionedEntityStorageOnBuilder;", "Lcom/intellij/platform/workspace/storage/VersionedEntityStorage;", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "<init>", "(Lcom/intellij/platform/workspace/storage/MutableEntityStorage;)V", "currentSnapshot", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/platform/workspace/storage/impl/StorageSnapshotCache;", "valuesCache", "Lcom/intellij/platform/workspace/storage/impl/ValuesCache;", "getValuesCache", "()Lcom/intellij/platform/workspace/storage/impl/ValuesCache;", "version", "", "getVersion", "()J", "current", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "getCurrent", "()Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "base", "getBase", "()Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "cachedValue", "R", "value", "Lcom/intellij/platform/workspace/storage/CachedValue;", "(Lcom/intellij/platform/workspace/storage/CachedValue;)Ljava/lang/Object;", "P", "Lcom/intellij/platform/workspace/storage/CachedValueWithParameter;", "parameter", "(Lcom/intellij/platform/workspace/storage/CachedValueWithParameter;Ljava/lang/Object;)Ljava/lang/Object;", "clearCachedValue", "", "(Lcom/intellij/platform/workspace/storage/CachedValueWithParameter;Ljava/lang/Object;)V", "getCurrentSnapshot", "intellij.platform.workspace.storage"})
public final class VersionedEntityStorageOnBuilder
implements VersionedEntityStorage {
    @NotNull
    private final MutableEntityStorage builder;
    @NotNull
    private final AtomicReference<StorageSnapshotCache> currentSnapshot;

    public VersionedEntityStorageOnBuilder(@NotNull MutableEntityStorage builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.builder = builder;
        this.currentSnapshot = new AtomicReference();
    }

    private final ValuesCache getValuesCache() {
        return this.getCurrentSnapshot().getCache();
    }

    @Override
    public long getVersion() {
        return EntityStorageInstrumentationKt.getInstrumentation(this.builder).getModificationCount();
    }

    @Override
    @NotNull
    public ImmutableEntityStorage getCurrent() {
        return this.getCurrentSnapshot().getStorage();
    }

    @Override
    @NotNull
    public MutableEntityStorage getBase() {
        return this.builder;
    }

    @Override
    public <R> R cachedValue(@NotNull CachedValue<R> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.getValuesCache().cachedValue(value, this.getCurrent());
    }

    @Override
    public <P, R> R cachedValue(@NotNull CachedValueWithParameter<P, R> value, P parameter) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.getValuesCache().cachedValue(value, parameter, this.getCurrent());
    }

    @Override
    public <R> void clearCachedValue(@NotNull CachedValue<R> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.getValuesCache().clearCachedValue(value);
    }

    @Override
    public <P, R> void clearCachedValue(@NotNull CachedValueWithParameter<P, R> value, P parameter) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.getValuesCache().clearCachedValue(value, parameter);
    }

    private final StorageSnapshotCache getCurrentSnapshot() {
        StorageSnapshotCache snapshotCache = this.currentSnapshot.get();
        if (snapshotCache == null || EntityStorageInstrumentationKt.getInstrumentation(this.builder).getModificationCount() != snapshotCache.getStorageVersion()) {
            StorageSnapshotCache storageSnapshotCache = new StorageSnapshotCache(EntityStorageInstrumentationKt.getInstrumentation(this.builder).getModificationCount(), new ValuesCache(), this.builder.toSnapshot());
            this.currentSnapshot.set(storageSnapshotCache);
            return storageSnapshotCache;
        }
        return snapshotCache;
    }
}

