/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.PropertyIndexValue;
import com.intellij.psi.impl.SimplePropertiesExternalizer;
import com.intellij.psi.impl.source.JavaLightStubBuilder;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.stub.JavaStubImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.io.DataExternalizer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\"\"\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\" \u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"getFieldOfGetter", "Lcom/intellij/psi/PsiField;", "method", "Lcom/intellij/psi/PsiMethod;", "getFieldOfSetter", "resolveFieldFromIndexValue", "isGetter", "", "javaSimplePropertyGist", "Lcom/intellij/util/gist/PsiFileGist;", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/psi/impl/PropertyIndexValue;", "getJavaSimplePropertyGist", "()Lcom/intellij/util/gist/PsiFileGist;", "allowedExpressions", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getAllowedExpressions", "()Lcom/intellij/psi/tree/TokenSet;", "allowedExpressions$delegate", "Lkotlin/Lazy;", "findSimplePropertyCandidates", "tree", "Lcom/intellij/lang/LighterAST;", "intellij.java.indexing.impl"})
public final class JavaSimplePropertyGistKt {
    @VisibleForTesting
    @NotNull
    private static final PsiFileGist<Int2ObjectMap<PropertyIndexValue>> javaSimplePropertyGist;
    @NotNull
    private static final Lazy allowedExpressions$delegate;

    @Nullable
    public static final PsiField getFieldOfGetter(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return JavaSimplePropertyGistKt.resolveFieldFromIndexValue(method, true);
    }

    @Nullable
    public static final PsiField getFieldOfSetter(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return JavaSimplePropertyGistKt.resolveFieldFromIndexValue(method, false);
    }

    private static final PsiField resolveFieldFromIndexValue(PsiMethod method, boolean isGetter) {
        PsiFile file = method.getContainingFile();
        if (!Intrinsics.areEqual((Object)file.getFileType(), (Object)JavaFileType.INSTANCE)) {
            return null;
        }
        int id = JavaStubImplUtil.getMethodStubIndex(method);
        if (id != -1) {
            PropertyIndexValue propertyIndexValue = (PropertyIndexValue)((Int2ObjectMap)javaSimplePropertyGist.getFileData(file)).get(id);
            if (propertyIndexValue != null) {
                PsiClass psiClass;
                PropertyIndexValue indexValue = propertyIndexValue;
                boolean bl = false;
                if (isGetter != indexValue.getGetter()) {
                    return null;
                }
                PsiClass psiClass2 = psiClass = method.getContainingClass();
                Intrinsics.checkNotNull((Object)psiClass2);
                Project project = psiClass2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                PsiExpression psiExpression = JavaPsiFacade.getElementFactory(project2).createExpressionFromText(indexValue.getPropertyRefText(), psiClass);
                Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"createExpressionFromText(...)");
                PsiExpression expr = psiExpression;
                return PropertyUtilBase.getSimplyReturnedField(expr);
            }
            return null;
        }
        return null;
    }

    @NotNull
    public static final PsiFileGist<Int2ObjectMap<PropertyIndexValue>> getJavaSimplePropertyGist() {
        return javaSimplePropertyGist;
    }

    private static final TokenSet getAllowedExpressions() {
        Lazy lazy = allowedExpressions$delegate;
        return (TokenSet)lazy.getValue();
    }

    private static final Int2ObjectMap<PropertyIndexValue> findSimplePropertyCandidates(LighterAST tree) {
        Int2ObjectOpenHashMap<PropertyIndexValue> result = new Int2ObjectOpenHashMap<PropertyIndexValue>();
        var v0 = new RecursiveLighterASTNodeWalkingVisitor(tree, result){
            private int methodIndex;
            final /* synthetic */ LighterAST $tree;
            final /* synthetic */ Int2ObjectOpenHashMap<PropertyIndexValue> $result;
            {
                this.$tree = $tree;
                this.$result = $result;
                super($tree);
            }

            public final int getMethodIndex() {
                return this.methodIndex;
            }

            public final void setMethodIndex(int n) {
                this.methodIndex = n;
            }

            public void visitNode(LighterASTNode element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (JavaLightStubBuilder.isCodeBlockWithoutStubs(element)) {
                    return;
                }
                if (element.getTokenType() == JavaElementType.METHOD) {
                    PropertyIndexValue propertyIndexValue = this.extractProperty(element);
                    if (propertyIndexValue != null) {
                        PropertyIndexValue propertyIndexValue2 = propertyIndexValue;
                        Int2ObjectOpenHashMap<PropertyIndexValue> int2ObjectOpenHashMap = this.$result;
                        PropertyIndexValue it = propertyIndexValue2;
                        boolean bl = false;
                        int2ObjectOpenHashMap.put(this.methodIndex, it);
                    }
                    int n = this.methodIndex;
                    this.methodIndex = n + 1;
                }
                super.visitNode(element);
            }

            private final PropertyIndexValue extractProperty(LighterASTNode method) {
                PropertyIndexValue propertyIndexValue;
                boolean isConstructor = true;
                boolean isGetter = false;
                isGetter = true;
                boolean isVoidReturnType = false;
                String setterParameterName = null;
                String refText = null;
                for (LighterASTNode child : this.$tree.getChildren(method)) {
                    IElementType iElementType = child.getTokenType();
                    if (Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.TYPE)) {
                        List<LighterASTNode> children2;
                        Intrinsics.checkNotNullExpressionValue(this.$tree.getChildren(child), (String)"getChildren(...)");
                        if (children2.size() != 1) {
                            return null;
                        }
                        LighterASTNode typeElement = children2.get(0);
                        if (Intrinsics.areEqual((Object)typeElement.getTokenType(), (Object)JavaTokenType.VOID_KEYWORD)) {
                            isVoidReturnType = true;
                        }
                        isConstructor = false;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.PARAMETER_LIST)) {
                        List<LighterASTNode> parameters;
                        if (LightTreeUtil.firstChildOfType(this.$tree, child, JavaElementType.PARAMETER) == null) {
                            isGetter = true;
                            if (!isVoidReturnType) continue;
                            return null;
                        }
                        Intrinsics.checkNotNullExpressionValue(LightTreeUtil.getChildrenOfType(this.$tree, child, JavaElementType.PARAMETER), (String)"getChildrenOfType(...)");
                        if (parameters.size() != 1) {
                            return null;
                        }
                        isGetter = false;
                        setterParameterName = JavaLightTreeUtil.getNameIdentifierText(this.$tree, parameters.get(0));
                        if (setterParameterName != null) continue;
                        return null;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.CODE_BLOCK)) {
                        String string;
                        if (isGetter) {
                            Intrinsics.checkNotNull((Object)child);
                            string = this.getGetterPropertyRefText(child);
                        } else {
                            Intrinsics.checkNotNull((Object)child);
                            String string2 = setterParameterName;
                            Intrinsics.checkNotNull(string2);
                            string = this.getSetterPropertyRefText(child, string2);
                        }
                        if ((refText = string) != null) continue;
                        return null;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.IDENTIFIER) || !isConstructor) continue;
                    return null;
                }
                String string = refText;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    propertyIndexValue = new PropertyIndexValue(it, isGetter);
                } else {
                    propertyIndexValue = null;
                }
                return propertyIndexValue;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final String getSetterPropertyRefText(LighterASTNode codeBlock, String setterParameterName) {
                LighterASTNode $i$f$singleOrNull2;
                Object v1;
                LighterASTNode $this$singleOrNull$iv;
                block5: {
                    List<LighterASTNode> list = this.$tree.getChildren(codeBlock);
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getChildren(...)");
                    Iterable iterable = list;
                    boolean $i$f$singleOrNull2 = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    Iterator<T> iterator2 = $this$singleOrNull$iv.iterator();
                    while (iterator2.hasNext()) {
                        T element$iv = iterator2.next();
                        LighterASTNode it = (LighterASTNode)element$iv;
                        boolean bl = false;
                        if (!ElementType.JAVA_STATEMENT_BIT_SET.contains(it.getTokenType())) continue;
                        if (found$iv) {
                            v1 = null;
                            break block5;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                LighterASTNode lighterASTNode = v1;
                if (lighterASTNode == null) return null;
                LighterASTNode it = $i$f$singleOrNull2 = lighterASTNode;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)JavaElementType.EXPRESSION_STATEMENT)) return null;
                LighterASTNode lighterASTNode2 = $i$f$singleOrNull2;
                $this$singleOrNull$iv = lighterASTNode2;
                if ($this$singleOrNull$iv == null) return null;
                $i$f$singleOrNull2 = $this$singleOrNull$iv;
                LighterAST lighterAST = this.$tree;
                LighterASTNode it2 = $i$f$singleOrNull2;
                boolean bl2 = false;
                LighterASTNode lighterASTNode3 = LightTreeUtil.firstChildOfType(lighterAST, it2, JavaElementType.ASSIGNMENT_EXPRESSION);
                LighterASTNode assignment = lighterASTNode3;
                if (assignment == null) return null;
                if (LightTreeUtil.firstChildOfType(this.$tree, assignment, JavaTokenType.EQ) == null) {
                    return null;
                }
                List<LighterASTNode> list = JavaLightTreeUtil.getExpressionChildren(this.$tree, assignment);
                Intrinsics.checkNotNullExpressionValue(list, (String)"getExpressionChildren(...)");
                List<LighterASTNode> operands = list;
                if (operands.size() != 2) {
                    return null;
                }
                LighterASTNode unwrapped = JavaLightTreeUtil.skipParenthesesDown(this.$tree, operands.get(1));
                if (unwrapped == null) return null;
                if (!Intrinsics.areEqual((Object)LightTreeUtil.toFilteredString(this.$tree, unwrapped, null), (Object)setterParameterName)) {
                    return null;
                }
                String string = LightTreeUtil.toFilteredString(this.$tree, operands.get(0), null);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toFilteredString(...)");
                String lhsText = string;
                if (!Intrinsics.areEqual((Object)lhsText, (Object)setterParameterName)) return lhsText;
                return null;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final String getGetterPropertyRefText(LighterASTNode codeBlock) {
                LighterASTNode lighterASTNode;
                Object v1;
                block2: {
                    List<LighterASTNode> list = this.$tree.getChildren(codeBlock);
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getChildren(...)");
                    Iterable $this$singleOrNull$iv = list;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        LighterASTNode it = (LighterASTNode)element$iv;
                        boolean bl = false;
                        if (!ElementType.JAVA_STATEMENT_BIT_SET.contains(it.getTokenType())) continue;
                        if (found$iv) {
                            v1 = null;
                            break block2;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                LighterASTNode lighterASTNode2 = v1;
                if (lighterASTNode2 == null) return null;
                LighterASTNode it = lighterASTNode = lighterASTNode2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)JavaElementType.RETURN_STATEMENT)) return null;
                LighterASTNode lighterASTNode3 = lighterASTNode;
                LighterASTNode lighterASTNode4 = lighterASTNode3;
                if (lighterASTNode4 == null) return null;
                Object object = lighterASTNode4;
                Object object2 = this.$tree;
                LighterASTNode it2 = object;
                boolean bl2 = false;
                lighterASTNode = LightTreeUtil.firstChildOfType((LighterAST)object2, it2, JavaSimplePropertyGistKt.access$getAllowedExpressions());
                if (lighterASTNode == null) return null;
                Object p0 = object2 = lighterASTNode;
                boolean bl3 = false;
                if (!this.checkQualifiers((LighterASTNode)p0)) return null;
                Object object3 = object2;
                object = object3;
                if (object == null) return null;
                object2 = object;
                LighterAST lighterAST = this.$tree;
                Object it3 = object2;
                boolean bl4 = false;
                String string = LightTreeUtil.toFilteredString(lighterAST, (LighterASTNode)it3, null);
                return string;
            }

            private final boolean checkQualifiers(LighterASTNode expression) {
                if (!JavaSimplePropertyGistKt.access$getAllowedExpressions().contains(expression.getTokenType())) {
                    return false;
                }
                LighterASTNode qualifier = JavaLightTreeUtil.findExpressionChild(this.$tree, expression);
                return qualifier == null || this.checkQualifiers(qualifier);
            }
        };
        LighterASTNode lighterASTNode = tree.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)lighterASTNode, (String)"getRoot(...)");
        v0.visitNode(lighterASTNode);
        return result;
    }

    private static final Int2ObjectMap javaSimplePropertyGist$lambda$1(PsiFile file) {
        LighterAST lighterAST = file.getNode().getLighterAST();
        Intrinsics.checkNotNullExpressionValue((Object)lighterAST, (String)"getLighterAST(...)");
        return JavaSimplePropertyGistKt.findSimplePropertyCandidates(lighterAST);
    }

    private static final Int2ObjectMap javaSimplePropertyGist$lambda$2(Function1 $tmp0, Object p0) {
        return (Int2ObjectMap)$tmp0.invoke(p0);
    }

    private static final TokenSet allowedExpressions_delegate$lambda$3() {
        IElementType[] iElementTypeArray = new IElementType[]{ElementType.REFERENCE_EXPRESSION, ElementType.THIS_EXPRESSION, ElementType.SUPER_EXPRESSION, ElementType.PARENTH_EXPRESSION};
        return TokenSet.create(iElementTypeArray);
    }

    public static final /* synthetic */ TokenSet access$getAllowedExpressions() {
        return JavaSimplePropertyGistKt.getAllowedExpressions();
    }

    static {
        PsiFileGist psiFileGist = GistManager.getInstance().newPsiFileGist("java.simple.property", 3, (DataExternalizer)new SimplePropertiesExternalizer(), arg_0 -> JavaSimplePropertyGistKt.javaSimplePropertyGist$lambda$2(JavaSimplePropertyGistKt::javaSimplePropertyGist$lambda$1, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)psiFileGist, (String)"newPsiFileGist(...)");
        javaSimplePropertyGist = psiFileGist;
        allowedExpressions$delegate = LazyKt.lazy(JavaSimplePropertyGistKt::allowedExpressions_delegate$lambda$3);
    }
}

