/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.RecaptureTypeMapper;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class PsiDiamondTypeUtil {
    private static final Logger LOG = Logger.getInstance(PsiDiamondTypeUtil.class);

    private PsiDiamondTypeUtil() {
    }

    public static boolean canCollapseToDiamond(PsiNewExpression expression, PsiNewExpression context, @Nullable PsiType expectedType) {
        return PsiDiamondTypeUtil.canCollapseToDiamond(expression, context, expectedType, false);
    }

    public static boolean canChangeContextForDiamond(PsiNewExpression expression, PsiType expectedType) {
        PsiNewExpression copy = (PsiNewExpression)expression.copy();
        return PsiDiamondTypeUtil.canCollapseToDiamond(copy, copy, expectedType, true);
    }

    private static boolean canCollapseToDiamond(PsiNewExpression expression, PsiNewExpression context, @Nullable PsiType expectedType, boolean skipDiamonds) {
        PsiTypeElement[] typeElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference;
        if (PsiUtil.isAvailable(JavaFeature.DIAMOND_TYPES, context) && (classReference = expression.getClassOrAnonymousClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (typeElements = parameterList.getTypeParameterElements()).length > 0) {
            if (!skipDiamonds && typeElements.length == 1 && typeElements[0].getType() instanceof PsiDiamondType) {
                return false;
            }
            PsiDiamondType.DiamondInferenceResult inferenceResult = PsiDiamondTypeImpl.resolveInferredTypes(expression, context);
            if (inferenceResult.getErrorMessage() == null) {
                PsiAnonymousClass anonymousClass = expression.getAnonymousClass();
                if (anonymousClass != null && ContainerUtil.exists(anonymousClass.getMethods(), method -> !method.hasModifierProperty("private") && method.findSuperMethods().length == 0)) {
                    return false;
                }
                List<PsiType> types = inferenceResult.getInferredTypes();
                PsiType[] typeArguments = null;
                if (expectedType instanceof PsiClassType) {
                    typeArguments = ((PsiClassType)expectedType).getParameters();
                }
                if (typeArguments == null) {
                    typeArguments = parameterList.getTypeArguments();
                }
                if (types.size() == typeArguments.length) {
                    PsiMethod method2 = expression.resolveMethod();
                    PsiElement resolve = classReference.resolve();
                    if (resolve instanceof PsiClass) {
                        PsiTypeParameter[] typeParameters = ((PsiClass)resolve).getTypeParameters();
                        return PsiDiamondTypeUtil.areTypeArgumentsRedundant(typeArguments, context, true, method2, typeParameters);
                    }
                }
            }
        }
        return false;
    }

    public static PsiElement createExplicitReplacement(PsiElement psiElement) {
        if (psiElement instanceof PsiReferenceParameterList) {
            PsiNewExpression expression = (PsiNewExpression)JavaPsiFacade.getElementFactory(psiElement.getProject()).createExpressionFromText("new a<>()", psiElement);
            PsiJavaCodeReferenceElement classReference = expression.getClassReference();
            LOG.assertTrue(classReference != null);
            PsiReferenceParameterList parameterList = classReference.getParameterList();
            LOG.assertTrue(parameterList != null);
            return parameterList;
        }
        return null;
    }

    public static PsiElement replaceDiamondWithExplicitTypes(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiJavaCodeReferenceElement)) {
            return parent;
        }
        PsiJavaCodeReferenceElement javaCodeReferenceElement = (PsiJavaCodeReferenceElement)parent;
        PsiReferenceParameterList parameterList = javaCodeReferenceElement.getParameterList();
        if (parameterList == null) {
            return javaCodeReferenceElement;
        }
        StringBuilder text = new StringBuilder();
        text.append(javaCodeReferenceElement.getQualifiedName());
        text.append('<');
        PsiNewExpression newExpression = PsiTreeUtil.getParentOfType(element, PsiNewExpression.class);
        PsiDiamondType.DiamondInferenceResult result = PsiDiamondTypeImpl.resolveInferredTypesNoCheck(newExpression, newExpression);
        text.append(StringUtil.join(result.getInferredTypes(), psiType -> psiType.getCanonicalText(), ","));
        text.append('>');
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(element.getProject());
        PsiJavaCodeReferenceElement newReference = elementFactory.createReferenceFromText(text.toString(), element);
        PsiReferenceParameterList newReferenceParameterList = newReference.getParameterList();
        LOG.assertTrue(newReferenceParameterList != null);
        CodeStyleManager.getInstance(javaCodeReferenceElement.getProject()).reformat(parameterList.replace(newReferenceParameterList));
        return javaCodeReferenceElement;
    }

    public static PsiExpression expandTopLevelDiamondsInside(PsiExpression expr) {
        PsiTypeElement[] typeParameterElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference;
        if (expr instanceof PsiNewExpression && (classReference = ((PsiNewExpression)expr).getClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (typeParameterElements = parameterList.getTypeParameterElements()).length == 1 && typeParameterElements[0].getType() instanceof PsiDiamondType) {
            return (PsiExpression)PsiDiamondTypeUtil.replaceDiamondWithExplicitTypes(parameterList).getParent();
        }
        return expr;
    }

    public static String getCollapsedType(PsiType type, PsiElement context) {
        int idx;
        String typeText = type.getCanonicalText();
        if (PsiUtil.isAvailable(JavaFeature.DIAMOND_TYPES, context) && (idx = typeText.indexOf(60)) >= 0) {
            return typeText.substring(0, idx) + "<>";
        }
        return typeText;
    }

    private static boolean isAugmented(PsiExpression expression) {
        PsiElement gParent = PsiUtil.skipParenthesizedExprUp(expression.getParent());
        PsiTypeElement typeElement = null;
        if (gParent instanceof PsiVariable) {
            typeElement = ((PsiVariable)gParent).getTypeElement();
        } else if (gParent instanceof PsiReturnStatement) {
            Object method = PsiTreeUtil.getParentOfType(gParent, PsiMethod.class, PsiLambdaExpression.class);
            typeElement = method instanceof PsiMethod ? ((PsiMethod)method).getReturnTypeElement() : null;
        }
        return typeElement != null && PsiAugmentProvider.getInferredType(typeElement) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean areTypeArgumentsRedundant(PsiType[] typeArguments, PsiExpression context, boolean constructorRef, @Nullable PsiMethod method, PsiTypeParameter[] typeParameters) {
        PsiElement encoded;
        block40: {
            boolean bl;
            block39: {
                boolean elementFactory2;
                block38: {
                    boolean call222;
                    block37: {
                        boolean call222;
                        block36: {
                            boolean call222;
                            block35: {
                                boolean bl2;
                                block34: {
                                    boolean bl3;
                                    block33: {
                                        boolean bl4;
                                        block32: {
                                            encoded = null;
                                            try {
                                                PsiElement copy;
                                                PsiType typeByParent = PsiTypesUtil.getExpectedTypeByParent(context);
                                                if (typeByParent != null && PsiTypesUtil.isDenotableType(typeByParent, context)) {
                                                    if (PsiDiamondTypeUtil.isAugmented(context)) {
                                                        bl4 = false;
                                                        if (encoded == null) return bl4;
                                                        break block32;
                                                    }
                                                    encoded = context;
                                                    RecaptureTypeMapper.encode(encoded);
                                                    copy = LambdaUtil.copyWithExpectedType(context, typeByParent);
                                                } else {
                                                    PsiExpressionList argumentList = context instanceof PsiCallExpression ? ((PsiCallExpression)context).getArgumentList() : null;
                                                    Object marker = new Object();
                                                    PsiTreeUtil.mark(argumentList != null ? argumentList : context, marker);
                                                    PsiCall call222 = LambdaUtil.treeWalkUp(context);
                                                    if (call222 != null) {
                                                        encoded = call222;
                                                        RecaptureTypeMapper.encode(encoded);
                                                        PsiCall callCopy = LambdaUtil.copyTopLevelCall(call222);
                                                        copy = callCopy != null ? PsiTreeUtil.releaseMark(callCopy, marker) : null;
                                                    } else {
                                                        PsiElement startMethodElementInCopy;
                                                        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(context.getProject());
                                                        if (injectedLanguageManager.getInjectionHost(context) != null) {
                                                            bl3 = false;
                                                            if (encoded == null) return bl3;
                                                            break block33;
                                                        }
                                                        PsiFile containingFile = context.getContainingFile();
                                                        PsiFile fileCopy = (PsiFile)containingFile.copy();
                                                        copy = PsiTreeUtil.releaseMark(fileCopy, marker);
                                                        if (method != null && method.getContainingFile() == containingFile && (method = PsiTreeUtil.getParentOfType(startMethodElementInCopy = fileCopy.findElementAt(method.getTextOffset()), PsiMethod.class)) == null) {
                                                            bl2 = false;
                                                            if (encoded == null) return bl2;
                                                            break block34;
                                                        }
                                                    }
                                                }
                                                if (copy != null && copy.getContainingFile() != null) {
                                                    GlobalSearchScope.markFileForWeakScope(copy.getContainingFile().getViewProvider().getVirtualFile());
                                                }
                                                PsiCallExpression exprCopy = PsiTreeUtil.getParentOfType(copy, PsiCallExpression.class, false);
                                                if (context instanceof PsiMethodReferenceExpression) {
                                                    PsiMethodReferenceExpression methodRefCopy = PsiTreeUtil.getParentOfType(copy, PsiMethodReferenceExpression.class, false);
                                                    if (methodRefCopy != null && !PsiDiamondTypeUtil.isInferenceEquivalent(typeArguments, typeParameters, method, methodRefCopy)) {
                                                        call222 = false;
                                                        if (encoded == null) return call222;
                                                        break block35;
                                                    }
                                                } else if (exprCopy != null) {
                                                    PsiElementFactory elementFactory2 = JavaPsiFacade.getElementFactory(exprCopy.getProject());
                                                    if (constructorRef) {
                                                        if (!(exprCopy instanceof PsiNewExpression) || !PsiDiamondTypeUtil.isInferenceEquivalent(typeArguments, elementFactory2, (PsiNewExpression)exprCopy)) {
                                                            call222 = false;
                                                            if (encoded == null) return call222;
                                                            break block36;
                                                        }
                                                    } else {
                                                        LOG.assertTrue(method != null);
                                                        if (!PsiDiamondTypeUtil.isInferenceEquivalent(typeArguments, elementFactory2, exprCopy, method, typeParameters)) {
                                                            call222 = false;
                                                            if (encoded == null) return call222;
                                                            break block37;
                                                        }
                                                    }
                                                }
                                                if (typeByParent != null) {
                                                    elementFactory2 = true;
                                                    if (encoded == null) return elementFactory2;
                                                    break block38;
                                                }
                                                PsiCallExpression newParentCall = exprCopy != null ? PsiTreeUtil.getParentOfType((PsiElement)exprCopy, PsiCallExpression.class) : null;
                                                PsiCallExpression oldParentCall = PsiTreeUtil.getParentOfType((PsiElement)context, PsiCallExpression.class);
                                                if (newParentCall != null && oldParentCall != null) {
                                                    JavaResolveResult newResult = newParentCall.resolveMethodGenerics();
                                                    JavaResolveResult oldResult = oldParentCall.resolveMethodGenerics();
                                                    if (newResult.getElement() == null || !newResult.getElement().isEquivalentTo(oldResult.getElement()) || !new RecaptureTypeMapper().recapture(newResult.getSubstitutor()).equals(oldResult.getSubstitutor())) {
                                                        bl = false;
                                                        if (encoded == null) return bl;
                                                        break block39;
                                                    }
                                                }
                                                if (encoded == null) return true;
                                                break block40;
                                            }
                                            catch (IncorrectOperationException e) {
                                                LOG.info(e);
                                                boolean bl5 = false;
                                                return bl5;
                                            }
                                        }
                                        RecaptureTypeMapper.clean(encoded);
                                        return bl4;
                                    }
                                    RecaptureTypeMapper.clean(encoded);
                                    return bl3;
                                }
                                RecaptureTypeMapper.clean(encoded);
                                return bl2;
                            }
                            RecaptureTypeMapper.clean(encoded);
                            return call222;
                        }
                        RecaptureTypeMapper.clean(encoded);
                        return call222;
                    }
                    RecaptureTypeMapper.clean(encoded);
                    return call222;
                }
                RecaptureTypeMapper.clean(encoded);
                return elementFactory2;
            }
            RecaptureTypeMapper.clean(encoded);
            return bl;
        }
        RecaptureTypeMapper.clean(encoded);
        return true;
        finally {
            if (encoded != null) {
                RecaptureTypeMapper.clean(encoded);
            }
        }
    }

    private static boolean isInferenceEquivalent(PsiType[] typeArguments, PsiTypeParameter[] typeParameters, PsiMethod method, PsiMethodReferenceExpression methodRefCopy) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(methodRefCopy.getProject());
        PsiTypeElement qualifierType = methodRefCopy.getQualifierType();
        if (qualifierType != null) {
            qualifierType.replace(elementFactory.createTypeElement(((PsiClassType)qualifierType.getType()).rawType()));
        } else {
            PsiReferenceParameterList parameterList = methodRefCopy.getParameterList();
            if (parameterList != null) {
                parameterList.delete();
            }
        }
        JavaResolveResult result = methodRefCopy.advancedResolve(false);
        if (method != null && result.getElement() != method) {
            return false;
        }
        PsiSubstitutor psiSubstitutor = result.getSubstitutor();
        for (int i = 0; i < typeParameters.length; ++i) {
            PsiTypeParameter typeParameter = typeParameters[i];
            PsiType inferredType = psiSubstitutor.getSubstitutionMap().get(typeParameter);
            if (typeArguments[i].equals(inferredType)) continue;
            return false;
        }
        return PsiDiamondTypeUtil.checkParentApplicability(methodRefCopy);
    }

    private static boolean isInferenceEquivalent(PsiType[] typeArguments, PsiElementFactory elementFactory, PsiCallExpression exprCopy, PsiMethod method, PsiTypeParameter[] typeParameters) throws IncorrectOperationException {
        PsiReferenceParameterList list = ((PsiCallExpression)elementFactory.createExpressionFromText("foo()", null)).getTypeArgumentList();
        exprCopy.getTypeArgumentList().replace(list);
        JavaResolveResult copyResult = exprCopy.resolveMethodGenerics();
        if (!method.isEquivalentTo(copyResult.getElement())) {
            return false;
        }
        PsiSubstitutor psiSubstitutor = copyResult.getSubstitutor();
        int length = typeParameters.length;
        for (int i = 0; i < length; ++i) {
            PsiTypeParameter typeParameter = typeParameters[i];
            PsiType inferredType = psiSubstitutor.getSubstitutionMap().get(typeParameter);
            if (!typeArguments[i].equals(inferredType)) {
                return false;
            }
            if (PsiUtil.resolveClassInType(method.getReturnType()) != typeParameter || PsiPrimitiveType.getUnboxedType(inferredType) == null) continue;
            return false;
        }
        return PsiDiamondTypeUtil.checkParentApplicability(exprCopy);
    }

    private static boolean isInferenceEquivalent(PsiType[] typeArguments, PsiElementFactory elementFactory, PsiNewExpression exprCopy) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement collapsedClassReference = ((PsiNewExpression)elementFactory.createExpressionFromText("new A<>()", null)).getClassOrAnonymousClassReference();
        LOG.assertTrue(collapsedClassReference != null);
        PsiReferenceParameterList diamondParameterList = collapsedClassReference.getParameterList();
        LOG.assertTrue(diamondParameterList != null);
        PsiJavaCodeReferenceElement classReference = exprCopy.getClassOrAnonymousClassReference();
        LOG.assertTrue(classReference != null);
        PsiReferenceParameterList parameterList = classReference.getParameterList();
        LOG.assertTrue(parameterList != null);
        parameterList.replace(diamondParameterList);
        PsiType[] inferredArgs = classReference.getParameterList().getTypeArguments();
        if (typeArguments.length != inferredArgs.length) {
            return false;
        }
        for (int i = 0; i < typeArguments.length; ++i) {
            PsiWildcardType wildcardType;
            PsiType bound;
            PsiType typeArgument = typeArguments[i];
            if (inferredArgs[i] instanceof PsiWildcardType && (bound = (wildcardType = (PsiWildcardType)inferredArgs[i]).getBound()) != null && (!wildcardType.isExtends() ? typeArgument.isAssignableFrom(bound) : bound.isAssignableFrom(typeArgument)) || typeArgument.equals(inferredArgs[i])) continue;
            return false;
        }
        return PsiDiamondTypeUtil.checkParentApplicability(exprCopy);
    }

    private static boolean checkParentApplicability(PsiExpression exprCopy) {
        while (exprCopy != null) {
            JavaResolveResult resolveResult;
            JavaResolveResult javaResolveResult = resolveResult = exprCopy instanceof PsiCallExpression ? PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)((Object)exprCopy)) : null;
            if (resolveResult instanceof MethodCandidateInfo && !((MethodCandidateInfo)resolveResult).isApplicable()) {
                return false;
            }
            exprCopy = PsiTreeUtil.getParentOfType((PsiElement)exprCopy, PsiCallExpression.class, true);
        }
        return true;
    }
}

